/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.silverpeas.domains.sqldriver;

import com.stratelia.silverpeas.domains.sqldriver.SQLSettings;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.AdminException;
import com.stratelia.webactiv.beans.admin.Group;
import com.stratelia.webactiv.util.DBUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class SQLGroupTable {
    SQLSettings drvSettings = new SQLSettings();

    public SQLGroupTable(SQLSettings ds) {
        this.drvSettings = ds;
    }

    protected String getColumns() {
        return this.drvSettings.getGroupSpecificIdColumnName() + ", " + this.drvSettings.getGroupParentIdColumnName() + ", " + this.drvSettings.getGroupNameColumnName() + ", " + this.drvSettings.getGroupDescriptionColumnName();
    }

    protected Group fetchGroup(ResultSet rs) throws SQLException {
        Group g = new Group();
        g.setSpecificId(Integer.toString(rs.getInt(1)));
        g.setSuperGroupId(Integer.toString(rs.getInt(2)));
        if (rs.wasNull()) {
            g.setSuperGroupId(null);
        }
        g.setName(rs.getString(3));
        g.setDescription(rs.getString(4));
        return g;
    }

    public int createGroup(Connection c, Group group) throws AdminException {
        PreparedStatement statement = null;
        int nextId = 0;
        String theQuery = "insert into " + this.drvSettings.getGroupTableName() + "(" + this.getColumns() + ") values (?,?,?,?)";
        try {
            SilverTrace.debug("admin", "SQLGroupTable.createGroup", "root.MSG_QUERY", theQuery);
            statement = c.prepareStatement(theQuery);
            nextId = DBUtil.getNextId(this.drvSettings.getGroupTableName(), this.drvSettings.getGroupSpecificIdColumnName());
            statement.setInt(1, nextId);
            String gid = group.getSuperGroupId();
            if (gid == null || gid.length() <= 0 || gid.equals("-1")) {
                statement.setNull(2, 4);
            } else {
                statement.setInt(2, Integer.parseInt(gid));
            }
            statement.setString(3, this.drvSettings.trunc(group.getName(), 100));
            statement.setString(4, this.drvSettings.trunc(group.getDescription(), 400));
            statement.executeUpdate();
        }
        catch (Exception e) {
            try {
                throw new AdminException("SQLGroupTable.createGroup", 4, "root.EX_SQL_QUERY_FAILED", "Query = " + theQuery, e);
            }
            catch (Throwable throwable) {
                DBUtil.close(statement);
                throw throwable;
            }
        }
        DBUtil.close(statement);
        return nextId;
    }

    public void deleteGroup(Connection c, int groupId) throws AdminException {
        PreparedStatement statement = null;
        String theQuery = "delete from " + this.drvSettings.getGroupTableName() + " where " + this.drvSettings.getGroupSpecificIdColumnName() + " = ?";
        try {
            SilverTrace.debug("admin", "SQLGroupTable.deleteGroup", "root.MSG_QUERY", theQuery);
            statement = c.prepareStatement(theQuery);
            statement.setInt(1, groupId);
            statement.executeUpdate();
        }
        catch (Exception e) {
            try {
                throw new AdminException("SQLGroupTable.deleteGroup", 4, "root.EX_SQL_QUERY_FAILED", "Query = " + theQuery, e);
            }
            catch (Throwable throwable) {
                DBUtil.close(statement);
                throw throwable;
            }
        }
        DBUtil.close(statement);
    }

    public void updateGroup(Connection c, Group g) throws AdminException {
        PreparedStatement statement = null;
        String theQuery = "update " + this.drvSettings.getGroupTableName() + " set " + this.drvSettings.getGroupNameColumnName() + " = ?," + this.drvSettings.getGroupDescriptionColumnName() + " = ?" + " where " + this.drvSettings.getGroupSpecificIdColumnName() + " = ?";
        try {
            SilverTrace.debug("admin", "SQLGroupTable.updateGroup", "root.MSG_QUERY", theQuery);
            statement = c.prepareStatement(theQuery);
            statement.setString(1, this.drvSettings.trunc(g.getName(), 100));
            statement.setString(2, this.drvSettings.trunc(g.getDescription(), 400));
            statement.setInt(3, Integer.parseInt(g.getSpecificId()));
            statement.executeUpdate();
        }
        catch (Exception e) {
            try {
                throw new AdminException("SQLGroupTable.updateGroup", 4, "root.EX_SQL_QUERY_FAILED", "Query = " + theQuery, e);
            }
            catch (Throwable throwable) {
                DBUtil.close(statement);
                throw throwable;
            }
        }
        DBUtil.close(statement);
    }

    public Group getGroup(Connection c, int groupId) throws AdminException {
        Group group;
        String theQuery;
        PreparedStatement statement;
        ResultSet rs;
        block5: {
            rs = null;
            statement = null;
            theQuery = "select " + this.getColumns() + " from " + this.drvSettings.getGroupTableName() + " where id = ?";
            SilverTrace.debug("admin", "SQLGroupTable.getGroup", "root.MSG_QUERY", theQuery);
            statement = c.prepareStatement(theQuery);
            statement.setInt(1, groupId);
            rs = statement.executeQuery();
            if (!rs.next()) break block5;
            Group group2 = this.fetchGroup(rs);
            DBUtil.close(rs, statement);
            return group2;
        }
        try {
            group = null;
        }
        catch (SQLException e) {
            try {
                throw new AdminException("SQLGroupTable.getGroup", 4, "root.EX_SQL_QUERY_FAILED", "Query = " + theQuery, e);
            }
            catch (Throwable throwable) {
                DBUtil.close(rs, statement);
                throw throwable;
            }
        }
        DBUtil.close(rs, statement);
        return group;
    }

    public Group getGroupByName(Connection c, String groupName) throws AdminException {
        Group group;
        String theQuery;
        PreparedStatement statement;
        ResultSet rs;
        block5: {
            rs = null;
            statement = null;
            theQuery = "select " + this.getColumns() + " from " + this.drvSettings.getGroupTableName() + " where name = ?";
            SilverTrace.debug("admin", "SQLGroupTable.getGroupByName", "root.MSG_QUERY", theQuery);
            statement = c.prepareStatement(theQuery);
            statement.setString(1, groupName);
            rs = statement.executeQuery();
            if (!rs.next()) break block5;
            Group group2 = this.fetchGroup(rs);
            DBUtil.close(rs, statement);
            return group2;
        }
        try {
            group = null;
        }
        catch (SQLException e) {
            try {
                throw new AdminException("SQLGroupTable.getGroupByName", 4, "root.EX_SQL_QUERY_FAILED", "Query = " + theQuery, e);
            }
            catch (Throwable throwable) {
                DBUtil.close(rs, statement);
                throw throwable;
            }
        }
        DBUtil.close(rs, statement);
        return group;
    }

    public List<Group> getAllGroups(Connection c) throws AdminException {
        ArrayList<Group> arrayList;
        ResultSet rs = null;
        PreparedStatement statement = null;
        ArrayList<Group> theResult = new ArrayList<Group>();
        String theQuery = "select " + this.getColumns() + " from " + this.drvSettings.getGroupTableName();
        try {
            SilverTrace.debug("admin", "SQLGroupTable.getGroup", "root.MSG_QUERY", theQuery);
            statement = c.prepareStatement(theQuery);
            rs = statement.executeQuery();
            while (rs.next()) {
                theResult.add(this.fetchGroup(rs));
            }
            arrayList = theResult;
        }
        catch (SQLException e) {
            try {
                throw new AdminException("SQLGroupTable.getAllGroups", 4, "root.EX_SQL_QUERY_FAILED", "Query = " + theQuery, e);
            }
            catch (Throwable throwable) {
                DBUtil.close(rs, statement);
                throw throwable;
            }
        }
        DBUtil.close(rs, statement);
        return arrayList;
    }

    public List<Group> getDirectSubGroups(Connection c, int groupId) throws AdminException {
        ArrayList<Group> arrayList;
        ResultSet rs = null;
        PreparedStatement statement = null;
        ArrayList<Group> theResult = new ArrayList<Group>();
        String theQuery = "select " + this.getColumns() + " from " + this.drvSettings.getGroupTableName() + " where " + this.drvSettings.getGroupParentIdColumnName();
        try {
            theQuery = groupId == -1 ? theQuery + " is null" : theQuery + " = ?";
            SilverTrace.debug("admin", "SQLGroupTable.getGroup", "root.MSG_QUERY", theQuery);
            statement = c.prepareStatement(theQuery);
            if (groupId != -1) {
                statement.setInt(1, groupId);
            }
            rs = statement.executeQuery();
            while (rs.next()) {
                theResult.add(this.fetchGroup(rs));
            }
            arrayList = theResult;
        }
        catch (SQLException e) {
            try {
                throw new AdminException("SQLGroupTable.getAllGroups", 4, "root.EX_SQL_QUERY_FAILED", "Query = " + theQuery, e);
            }
            catch (Throwable throwable) {
                DBUtil.close(rs, statement);
                throw throwable;
            }
        }
        DBUtil.close(rs, statement);
        return arrayList;
    }
}

