/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.silverpeas.notificationManager;

import com.silverpeas.SilverpeasServiceProvider;
import com.silverpeas.util.CollectionUtil;
import com.silverpeas.util.StringUtil;
import com.silverpeas.util.i18n.I18NHelper;
import com.stratelia.silverpeas.notificationManager.CurrentUserNotificationContext;
import com.stratelia.silverpeas.notificationManager.NotificationManager;
import com.stratelia.silverpeas.notificationManager.NotificationManagerException;
import com.stratelia.silverpeas.notificationManager.NotificationMetaData;
import com.stratelia.silverpeas.notificationManager.NotificationParameters;
import com.stratelia.silverpeas.notificationManager.UserRecipient;
import com.stratelia.silverpeas.notificationManager.constant.NotifMediaType;
import com.stratelia.silverpeas.notificationManager.model.SentNotificationInterface;
import com.stratelia.silverpeas.notificationManager.model.SentNotificationInterfaceImpl;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.Group;
import com.stratelia.webactiv.beans.admin.UserDetail;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class NotificationSender
implements Serializable {
    private static final long serialVersionUID = 4165938893905145809L;
    protected NotificationManager notificationManager = null;
    protected int instanceId = -1;

    public NotificationSender(String instanceId) {
        this.instanceId = NotificationSender.extractLastNumber(instanceId);
        this.notificationManager = new NotificationManager(null);
    }

    public void notifyUser(NotificationMetaData metaData) throws NotificationManagerException {
        this.notifyUser(NotifMediaType.COMPONENT_DEFINED.getId(), metaData);
    }

    public void notifyUser(int aMediaType, NotificationMetaData metaData) throws NotificationManagerException {
        CurrentUserNotificationContext.getCurrentUserNotificationContext().checkManualUserNotification(metaData);
        Set<UserRecipient> usersSet = metaData.getAllUserRecipients(true);
        Set<String> languages = metaData.getLanguages();
        HashMap<String, String> usersLanguage = new HashMap<String, String>(usersSet.size());
        for (UserRecipient user : usersSet) {
            usersLanguage.put(user.getUserId(), SilverpeasServiceProvider.getPersonalizationService().getUserSettings(user.getUserId()).getLanguage());
        }
        NotificationParameters params = null;
        Set allUserIds = usersLanguage.keySet();
        SilverTrace.info("notificationManager", "NotificationSender.notifyUser()", "root.MSG_GEN_PARAM_VALUE", "allUserIds = " + allUserIds);
        for (String language : languages) {
            SilverTrace.info("notificationManager", "NotificationSender.notifyUser()", "root.MSG_GEN_PARAM_VALUE", "language = " + language);
            params = this.getNotificationParameters(aMediaType, metaData);
            params.sTitle = metaData.getTitle(language);
            params.sLinkLabel = metaData.getLinkLabel(language);
            params.sMessage = metaData.getContent(language);
            params.sLanguage = language;
            params.nNotificationResourceData = metaData.getNotificationResourceData(language);
            List<String> userIds = this.getUserIds(language, usersLanguage);
            allUserIds.removeAll(userIds);
            SilverTrace.info("notificationManager", "NotificationSender.notifyUser()", "root.MSG_GEN_PARAM_VALUE", "allUserIds apres remove= " + allUserIds);
            this.notificationManager.notifyUsers(params, userIds.toArray(new String[userIds.size()]));
        }
        this.notificationManager.notifyUsers(params, allUserIds.toArray(new String[allUserIds.size()]));
        if (CollectionUtil.isNotEmpty(metaData.getExternalRecipients())) {
            params.sLanguage = I18NHelper.defaultLanguage;
            params.sTitle = metaData.getTitle(params.sLanguage);
            params.sLinkLabel = metaData.getLinkLabel(params.sLanguage);
            params.sMessage = metaData.getContent(params.sLanguage);
            this.notificationManager.notifyExternals(params, metaData.getExternalRecipients());
        }
        if (metaData.isSendByAUser() && aMediaType != -15) {
            this.saveNotification(metaData, usersSet);
        }
        SilverTrace.info("notificationManager", "NotificationSender.notifyUser()", "root.MSG_GEN_EXIT_METHOD");
    }

    private void saveNotification(NotificationMetaData metaData, Set<UserRecipient> usersSet) throws NotificationManagerException {
        if (!usersSet.isEmpty()) {
            this.getNotificationInterface().saveNotifUser(metaData, usersSet);
        }
    }

    private SentNotificationInterface getNotificationInterface() throws NotificationManagerException {
        SentNotificationInterfaceImpl notificationInterface = null;
        try {
            notificationInterface = new SentNotificationInterfaceImpl();
        }
        catch (Exception e) {
            throw new NotificationManagerException("NotificationSender.getNotificationInterface()", 4, "root.EX_CANT_GET_REMOTE_OBJECT", e);
        }
        return notificationInterface;
    }

    private List<String> getUserIds(String lang, Map<String, String> usersLanguage) {
        ArrayList<String> userIds = new ArrayList<String>(usersLanguage.keySet());
        Iterator<String> languages = usersLanguage.values().iterator();
        ArrayList<String> result = new ArrayList<String>();
        int u = 0;
        while (languages.hasNext()) {
            String language = languages.next();
            SilverTrace.debug("notificationManager", "NotificationSender.getUserIds()", "root.MSG_GEN_PARAM_VALUE", "language = " + language);
            if (lang.equalsIgnoreCase(language)) {
                result.add((String)userIds.get(u));
            }
            ++u;
        }
        SilverTrace.info("notificationManager", "NotificationSender.getUserIds()", "root.MSG_GEN_EXIT_METHOD", result.size() + " users for language '" + lang + "' ");
        return result;
    }

    private NotificationParameters getNotificationParameters(int aMediaType, NotificationMetaData metaData) {
        NotificationParameters params = new NotificationParameters();
        params.iMessagePriority = metaData.getMessageType();
        params.dDate = metaData.getDate();
        params.sTitle = metaData.getTitle();
        params.sMessage = metaData.getContent();
        params.sSource = metaData.getSource();
        params.sURL = metaData.getLink();
        params.sSessionId = metaData.getSessionId();
        params.sOriginalExtraMessage = metaData.getOriginalExtraMessage();
        params.bSendImmediately = metaData.isSendImmediately();
        params.iComponentInstance = this.instanceId != -1 ? this.instanceId : NotificationSender.extractLastNumber(metaData.getComponentId());
        params.iMediaType = aMediaType;
        params.bAnswerAllowed = metaData.isAnswerAllowed();
        String sender = metaData.getSender();
        if (aMediaType == -10 || aMediaType == -15) {
            if (metaData.isAnswerAllowed() && StringUtil.isDefined(sender)) {
                params.iFromUserId = Integer.parseInt(metaData.getSender());
            }
        } else if (StringUtil.isInteger(sender)) {
            SilverTrace.info("notificationManager", "NotificationSender.getNotificationParameters()", "root.MSG_GEN_PARAM_VALUE", metaData.getSender());
            params.iFromUserId = Integer.parseInt(metaData.getSender());
        } else {
            params.iFromUserId = -1;
            params.senderName = sender;
        }
        params.eAction = metaData.getAction();
        return params;
    }

    static int extractLastNumber(String chaine) {
        String s = "";
        if (chaine != null) {
            block3: for (int i = 0; i < chaine.length(); ++i) {
                char car = chaine.charAt(i);
                switch (car) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        s = s + car;
                        continue block3;
                    }
                    default: {
                        s = "";
                    }
                }
            }
        }
        if (s.length() > 0) {
            return Integer.parseInt(s);
        }
        return -1;
    }

    public static String getIdsLineFromIdsArray(String[] asrc) {
        StringBuilder toIds = new StringBuilder("");
        if (asrc != null) {
            for (int i = 0; i < asrc.length; ++i) {
                if (i > 0) {
                    toIds.append('_');
                }
                toIds.append(asrc[i]);
            }
        }
        return toIds.toString();
    }

    public static String getIdsLineFromUserArray(UserDetail[] users) {
        StringBuilder toIds = new StringBuilder("");
        if (users != null) {
            for (int i = 0; i < users.length; ++i) {
                if (i > 0) {
                    toIds.append('_');
                }
                toIds.append(users[i].getId());
            }
        }
        return toIds.toString();
    }

    public static String getIdsLineFromGroupArray(Group[] groups) {
        StringBuilder toIds = new StringBuilder("");
        if (groups != null) {
            for (int i = 0; i < groups.length; ++i) {
                if (i > 0) {
                    toIds.append('_');
                }
                toIds.append(groups[i].getId());
            }
        }
        return toIds.toString();
    }

    public static String[] getIdsArrayFromIdsLine(String src) {
        if (src == null) {
            return new String[0];
        }
        StringTokenizer strTok = new StringTokenizer(src, "_");
        int nbElmt = strTok.countTokens();
        String[] valret = new String[nbElmt];
        for (int i = 0; i < nbElmt; ++i) {
            valret[i] = strTok.nextToken();
        }
        return valret;
    }
}

