/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.silverpeas.notificationManager.model;

import com.stratelia.silverpeas.notificationManager.model.NotifAddressRow;
import com.stratelia.silverpeas.notificationManager.model.NotifDefaultAddressRow;
import com.stratelia.silverpeas.notificationManager.model.NotifDefaultAddressTable;
import com.stratelia.silverpeas.notificationManager.model.NotifPreferenceRow;
import com.stratelia.silverpeas.notificationManager.model.NotifPreferenceTable;
import com.stratelia.silverpeas.notificationManager.model.NotifSchema;
import com.stratelia.webactiv.util.AbstractTable;
import com.stratelia.webactiv.util.Schema;
import com.stratelia.webactiv.util.exception.UtilException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class NotifAddressTable
extends AbstractTable<NotifAddressRow> {
    protected static final String NOTIFADDRESS_COLUMNS = "id,userId,notifName,notifChannelId,address,usage,priority";
    private static final String SELECT_NOTIFADDRESS_BY_ID = "Select id,userId,notifName,notifChannelId,address,usage,priority from ST_NotifAddress Where id = ?";
    private static final String SELECT_ALL_NOTIFADDRESS_WITH_GIVEN_NOTIFCHANNELID = "select id,userId,notifName,notifChannelId,address,usage,priority from ST_NotifAddress where notifChannelId=?";
    private static final String SELECT_ALL_NOTIFADDRESS_WITH_GIVEN_USERID = "select id,userId,notifName,notifChannelId,address,usage,priority from ST_NotifAddress where userId=?";
    private static final String SELECT_ALL_NOTIFADDRESS = "select id,userId,notifName,notifChannelId,address,usage,priority from ST_NotifAddress";
    private static final String INSERT_NOTIFADDRESS = "insert into ST_NotifAddress (id, userId, notifName, notifChannelId, address, usage, priority) values  (?, ?, ?, ?, ?, ?, ?)";
    private static final String UPDATE_NOTIFADDRESS = "update ST_NotifAddress set userId = ?, notifName = ?, notifChannelId = ?, address = ?, usage = ?, priority = ? Where id = ?";
    private static final String DELETE_NOTIFADDRESS = "delete from ST_NotifAddress where id=?";

    public NotifAddressTable(Schema schema) {
        super(schema, "ST_NotifAddress");
    }

    public NotifAddressRow getNotifAddress(int id) throws UtilException {
        return (NotifAddressRow)this.getUniqueRow(SELECT_NOTIFADDRESS_BY_ID, id);
    }

    public NotifAddressRow[] getAllByUserId(int aUserId, String orderField) throws UtilException {
        String req = "select id,userId,notifName,notifChannelId,address,usage,priority from ST_NotifAddress Where UserId = " + aUserId;
        if (orderField != null) {
            req = req + " order by " + orderField;
        }
        List<NotifAddressRow> rows = this.getRows(req);
        return rows.toArray(new NotifAddressRow[rows.size()]);
    }

    public NotifAddressRow[] getAllByNotifChannelId(int notifChannelId) throws UtilException {
        List<NotifAddressRow> rows = this.getRows(SELECT_ALL_NOTIFADDRESS_WITH_GIVEN_NOTIFCHANNELID, notifChannelId);
        return rows.toArray(new NotifAddressRow[rows.size()]);
    }

    public NotifAddressRow[] getAllByUserId(int userId) throws UtilException {
        List<NotifAddressRow> rows = this.getRows(SELECT_ALL_NOTIFADDRESS_WITH_GIVEN_USERID, userId);
        return rows.toArray(new NotifAddressRow[rows.size()]);
    }

    public NotifAddressRow[] getAllRows() throws UtilException {
        List<NotifAddressRow> rows = this.getRows(SELECT_ALL_NOTIFADDRESS);
        return rows.toArray(new NotifAddressRow[rows.size()]);
    }

    public NotifAddressRow getNotifAddress(String query) throws UtilException {
        return (NotifAddressRow)this.getUniqueRow(query);
    }

    public NotifAddressRow[] getNotifAddresss(String query) throws UtilException {
        List<NotifAddressRow> rows = this.getRows(query);
        return rows.toArray(new NotifAddressRow[rows.size()]);
    }

    public int create(NotifAddressRow notifAddress) throws UtilException {
        this.insertRow(INSERT_NOTIFADDRESS, notifAddress);
        return notifAddress.getId();
    }

    public void update(NotifAddressRow notifAddress) throws UtilException {
        this.updateRow(UPDATE_NOTIFADDRESS, notifAddress);
    }

    public void save(NotifAddressRow notifAddress) throws UtilException {
        if (notifAddress.getId() == -1) {
            this.create(notifAddress);
        } else {
            this.update(notifAddress);
        }
    }

    public void delete(int id) throws UtilException {
        this.updateRelation(DELETE_NOTIFADDRESS, id);
    }

    public void dereferenceNotifChannelId(int notifChannelId) throws UtilException {
        NotifAddressRow[] notifAddressToBeDeleted;
        for (NotifAddressRow aNotifAddressToBeDeleted : notifAddressToBeDeleted = this.getAllByNotifChannelId(notifChannelId)) {
            this.delete(aNotifAddressToBeDeleted.getId());
        }
    }

    public void dereferenceUserId(int userId) throws UtilException {
        NotifAddressRow[] notifAddressToBeDeleted;
        for (NotifAddressRow aNotifAddressToBeDeleted : notifAddressToBeDeleted = this.getAllByUserId(userId)) {
            this.delete(aNotifAddressToBeDeleted.getId());
        }
    }

    @Override
    protected NotifAddressRow fetchRow(ResultSet rs) throws SQLException {
        return new NotifAddressRow(rs.getInt("id"), rs.getInt("userId"), rs.getString("notifName"), rs.getInt("notifChannelId"), rs.getString("address"), rs.getString("usage"), rs.getInt("priority"));
    }

    @Override
    protected void prepareUpdate(String updateQuery, PreparedStatement update, NotifAddressRow row) throws SQLException {
        update.setInt(1, row.getUserId());
        update.setString(2, NotifAddressTable.truncate(row.getNotifName(), 20));
        update.setInt(3, row.getNotifChannelId());
        update.setString(4, NotifAddressTable.truncate(row.getAddress(), 250));
        update.setString(5, NotifAddressTable.truncate(row.getUsage(), 20));
        update.setInt(6, row.getPriority());
        update.setInt(7, row.getId());
    }

    @Override
    protected void prepareInsert(String insertQuery, PreparedStatement insert, NotifAddressRow row) throws SQLException {
        if (row.getId() == -1) {
            row.setId(this.getNextId());
        }
        insert.setInt(1, row.getId());
        insert.setInt(2, row.getUserId());
        insert.setString(3, NotifAddressTable.truncate(row.getNotifName(), 20));
        insert.setInt(4, row.getNotifChannelId());
        insert.setString(5, NotifAddressTable.truncate(row.getAddress(), 250));
        insert.setString(6, NotifAddressTable.truncate(row.getUsage(), 20));
        insert.setInt(7, row.getPriority());
    }

    public void deleteAndPropagate(int notifAddressId, int defaultAddress) throws UtilException {
        int i;
        NotifPreferenceRow[] nprs = null;
        NotifPreferenceTable npt = ((NotifSchema)this.schema).notifPreference;
        NotifDefaultAddressRow[] ndars = null;
        NotifDefaultAddressTable ndat = ((NotifSchema)this.schema).notifDefaultAddress;
        nprs = npt.getNotifPreferences("select * from ST_NotifPreference where notifAddressId = " + Integer.toString(notifAddressId));
        for (i = 0; i < nprs.length; ++i) {
            npt.delete(nprs[i].getId());
        }
        ndars = ndat.getNotifDefaultAddresss("select * from ST_NotifDefaultAddress where notifAddressId = " + Integer.toString(notifAddressId));
        for (i = 0; i < ndars.length; ++i) {
            ndars[i].setNotifAddressId(defaultAddress);
            ndat.update(ndars[i]);
        }
        this.delete(notifAddressId);
    }
}

