/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.silverpeas.notificationManager.model;

import com.stratelia.silverpeas.notificationManager.model.NotifDefaultAddressRow;
import com.stratelia.webactiv.util.AbstractTable;
import com.stratelia.webactiv.util.Schema;
import com.stratelia.webactiv.util.exception.UtilException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class NotifDefaultAddressTable
extends AbstractTable<NotifDefaultAddressRow> {
    protected static final String NOTIFDEFAULTADDRESS_COLUMNS = "id,userId,notifAddressId";
    private static final String SELECT_NOTIFDEFAULTADDRESS_BY_ID = "select id,userId,notifAddressId from ST_NotifDefaultAddress Where id = ?";
    private static final String SELECT_ALL_NOTIFDEFAULTADDRESS_WITH_GIVEN_USERID = "select id,userId,notifAddressId from ST_NotifDefaultAddress where userId=?";
    private static final String SELECT_ALL_NOTIFDEFAULTADDRESS = "select id,userId,notifAddressId from ST_NotifDefaultAddress";
    private static final String INSERT_NOTIFDEFAULTADDRESS = "insert into ST_NotifDefaultAddress (id, userId, notifAddressId) values  (?, ?, ?)";
    private static final String UPDATE_NOTIFDEFAULTADDRESS = "update ST_NotifDefaultAddress set userId = ?, notifAddressId = ? Where id = ?";
    private static final String DELETE_NOTIFDEFAULTADDRESS = "delete from ST_NotifDefaultAddress where id=?";

    public NotifDefaultAddressTable(Schema schema) {
        super(schema, "ST_NotifDefaultAddress");
    }

    public NotifDefaultAddressRow getNotifDefaultAddress(int id) throws UtilException {
        return (NotifDefaultAddressRow)this.getUniqueRow(SELECT_NOTIFDEFAULTADDRESS_BY_ID, id);
    }

    public NotifDefaultAddressRow[] getAllByUserId(int userId) throws UtilException {
        List<NotifDefaultAddressRow> rows = this.getRows(SELECT_ALL_NOTIFDEFAULTADDRESS_WITH_GIVEN_USERID, userId);
        return rows.toArray(new NotifDefaultAddressRow[rows.size()]);
    }

    public NotifDefaultAddressRow[] getAllRows() throws UtilException {
        List<NotifDefaultAddressRow> rows = this.getRows(SELECT_ALL_NOTIFDEFAULTADDRESS);
        return rows.toArray(new NotifDefaultAddressRow[rows.size()]);
    }

    public NotifDefaultAddressRow getNotifDefaultAddress(String query) throws UtilException {
        return (NotifDefaultAddressRow)this.getUniqueRow(query);
    }

    public NotifDefaultAddressRow[] getNotifDefaultAddresss(String query) throws UtilException {
        List<NotifDefaultAddressRow> rows = this.getRows(query);
        return rows.toArray(new NotifDefaultAddressRow[rows.size()]);
    }

    public int create(NotifDefaultAddressRow notifDefaultAddress) throws UtilException {
        this.insertRow(INSERT_NOTIFDEFAULTADDRESS, notifDefaultAddress);
        return notifDefaultAddress.getId();
    }

    public void update(NotifDefaultAddressRow notifDefaultAddress) throws UtilException {
        this.updateRow(UPDATE_NOTIFDEFAULTADDRESS, notifDefaultAddress);
    }

    public void save(NotifDefaultAddressRow notifDefaultAddress) throws UtilException {
        if (notifDefaultAddress.getId() == -1) {
            this.create(notifDefaultAddress);
        } else {
            this.update(notifDefaultAddress);
        }
    }

    public void delete(int id) throws UtilException {
        this.updateRelation(DELETE_NOTIFDEFAULTADDRESS, id);
    }

    public void dereferenceUserId(int userId) throws UtilException {
        NotifDefaultAddressRow[] notifDefaultAddressToBeDeleted;
        for (NotifDefaultAddressRow aNotifDefaultAddressToBeDeleted : notifDefaultAddressToBeDeleted = this.getAllByUserId(userId)) {
            this.delete(aNotifDefaultAddressToBeDeleted.getId());
        }
    }

    @Override
    protected NotifDefaultAddressRow fetchRow(ResultSet rs) throws SQLException {
        return new NotifDefaultAddressRow(rs.getInt("id"), rs.getInt("userId"), rs.getInt("notifAddressId"));
    }

    @Override
    protected void prepareUpdate(String updateQuery, PreparedStatement update, NotifDefaultAddressRow r) throws SQLException {
        update.setInt(1, r.getUserId());
        update.setInt(2, r.getNotifAddressId());
        update.setInt(3, r.getId());
    }

    @Override
    protected void prepareInsert(String insertQuery, PreparedStatement insert, NotifDefaultAddressRow r) throws SQLException {
        if (r.getId() == -1) {
            r.setId(this.getNextId());
        }
        insert.setInt(1, r.getId());
        insert.setInt(2, r.getUserId());
        insert.setInt(3, r.getNotifAddressId());
    }
}

