/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.silverpeas.notificationserver.channel;

import com.stratelia.silverpeas.notificationserver.NotificationData;
import com.stratelia.silverpeas.notificationserver.NotificationServerException;
import com.stratelia.silverpeas.notificationserver.NotificationServerUtil;
import com.stratelia.silverpeas.notificationserver.channel.INotificationServerChannel;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;

public abstract class AbstractListener
implements INotificationServerChannel {
    protected String channel;
    protected String payLoad;

    protected void processMessage(Message msg) throws NotificationServerException {
        this.extractData(msg);
        NotificationData nd = NotificationServerUtil.convertXMLToNotificationData(this.payLoad);
        if (nd != null) {
            SilverTrace.info("notificationServer", "AbstractListener.processMessage()", "notificationServer.INFO_PROCESS_MESSAGE");
            nd.traceObject();
        }
        this.send(nd);
    }

    private void extractData(Message msg) throws NotificationServerException {
        TextMessage tm = (TextMessage)msg;
        try {
            this.channel = tm.getStringProperty("CHANNEL");
        }
        catch (JMSException e) {
            throw new NotificationServerException("AbstractListener.extractData()", 4, "notificationServer.EX_CHANNEL_NOT_DEFINED", (Exception)((Object)e));
        }
        try {
            this.payLoad = tm.getText();
        }
        catch (JMSException e) {
            throw new NotificationServerException("AbstractListener.extractData()", 4, "notificationServer.EX_NOTIF_DATA_NOT_DEFINED", (Exception)((Object)e));
        }
    }
}

