/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.silverpeas.util;

import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.util.DBUtil;
import com.stratelia.webactiv.util.JNDINames;
import com.stratelia.webactiv.util.exception.UtilException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class LongText {
    public static final int PART_SIZE_MAX = 1998;

    public static int addLongText(String theText) throws UtilException {
        Connection privateConnection;
        PreparedStatement stmt;
        int theId;
        block6: {
            theId = DBUtil.getNextId("ST_LongText", "id");
            stmt = null;
            privateConnection = null;
            int orderNum = 0;
            String partText = null;
            String theQuery = "insert into ST_LongText (id, orderNum, bodyContent) values (?, ?, ?)";
            try {
                privateConnection = LongText.openConnection();
                stmt = privateConnection.prepareStatement(theQuery);
                if (theText == null || theText.length() <= 0) {
                    stmt.setInt(1, theId);
                    stmt.setInt(2, orderNum);
                    stmt.setString(3, "");
                    stmt.executeUpdate();
                    break block6;
                }
                while (orderNum * 1998 < theText.length()) {
                    partText = (orderNum + 1) * 1998 < theText.length() ? theText.substring(orderNum * 1998, (orderNum + 1) * 1998) : theText.substring(orderNum * 1998);
                    stmt.setInt(1, theId);
                    stmt.setInt(2, orderNum);
                    stmt.setString(3, partText);
                    stmt.executeUpdate();
                    ++orderNum;
                }
            }
            catch (Exception e) {
                try {
                    throw new UtilException("LongText.addLongText()", 3, "root.MSG_PARAM_VALUE", theText, e);
                }
                catch (Throwable throwable) {
                    DBUtil.close(stmt);
                    LongText.closeConnection(privateConnection);
                    throw throwable;
                }
            }
        }
        DBUtil.close(stmt);
        LongText.closeConnection(privateConnection);
        return theId;
    }

    public static String getLongText(int longTextId) throws UtilException {
        String string;
        PreparedStatement stmt = null;
        Connection privateConnection = null;
        ResultSet rs = null;
        StringBuilder valret = new StringBuilder();
        String theQuery = "select bodyContent from ST_LongText where id = ? order by orderNum";
        try {
            privateConnection = LongText.openConnection();
            stmt = privateConnection.prepareStatement(theQuery);
            stmt.setInt(1, longTextId);
            rs = stmt.executeQuery();
            while (rs.next()) {
                valret.append(rs.getString(1));
            }
            string = valret.toString();
        }
        catch (Exception e) {
            try {
                throw new UtilException("LongText.getLongText()", 3, "root.MSG_PARAM_VALUE", Integer.toString(longTextId), e);
            }
            catch (Throwable throwable) {
                DBUtil.close(rs, stmt);
                LongText.closeConnection(privateConnection);
                throw throwable;
            }
        }
        DBUtil.close(rs, stmt);
        LongText.closeConnection(privateConnection);
        return string;
    }

    public static void removeLongText(int longTextId) throws UtilException {
        PreparedStatement stmt = null;
        Connection privateConnection = null;
        String theQuery = "delete from ST_LongText where id = ?";
        try {
            privateConnection = LongText.openConnection();
            stmt = privateConnection.prepareStatement(theQuery);
            stmt.setInt(1, longTextId);
            stmt.executeUpdate();
        }
        catch (Exception e) {
            try {
                throw new UtilException("LongText.removeLongText()", 3, "root.MSG_PARAM_VALUE", Integer.toString(longTextId), e);
            }
            catch (Throwable throwable) {
                DBUtil.close(stmt);
                LongText.closeConnection(privateConnection);
                throw throwable;
            }
        }
        DBUtil.close(stmt);
        LongText.closeConnection(privateConnection);
    }

    protected static Connection openConnection() throws UtilException {
        Connection con = null;
        try {
            con = DBUtil.makeConnection(JNDINames.SILVERPEAS_DATASOURCE);
        }
        catch (Exception e) {
            throw new UtilException("LongText.openConnection()", 3, "root.MSG_PARAM_VALUE", e);
        }
        return con;
    }

    protected static void closeConnection(Connection con) {
        try {
            con.close();
        }
        catch (Exception e) {
            SilverTrace.error("util", "LongText.closeConnection()", "root.EX_CONNECTION_CLOSE_FAILED", e);
        }
    }
}

