/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.silverpeas.util;

import com.silverpeas.util.FileUtil;
import com.stratelia.webactiv.util.GeneralPropertiesManager;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ResourceBundleWrapper
extends ResourceBundle {
    private ResourceBundle bundle;
    private ResourceBundle parentBundle;

    public ResourceBundleWrapper(String file, Locale locale, boolean hasParent) {
        this.bundle = FileUtil.loadBundle(file, locale);
        if (hasParent) {
            this.parentBundle = GeneralPropertiesManager.getGeneralMultilang(locale.getLanguage()).getResourceBundle();
        }
    }

    public ResourceBundleWrapper(String file, Locale locale) {
        this(file, locale, !"org.silverpeas.multilang.generalMultilang".equalsIgnoreCase(file));
    }

    @Override
    public Enumeration<String> getKeys() {
        return this.bundle.getKeys();
    }

    @Override
    protected Object handleGetObject(String key) {
        Object result = null;
        try {
            result = this.bundle.getObject(key);
        }
        catch (MissingResourceException mrex) {
            // empty catch block
        }
        if (result == null && this.parentBundle != null) {
            try {
                result = this.parentBundle.getObject(key);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return result;
    }
}

