/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.beans.admin;

import com.stratelia.webactiv.beans.admin.AdminException;
import com.stratelia.webactiv.beans.admin.DomainDriverManager;
import com.stratelia.webactiv.beans.admin.GroupProfileInst;
import com.stratelia.webactiv.organization.GroupRow;
import com.stratelia.webactiv.organization.GroupUserRoleRow;
import java.util.ArrayList;

public class GroupProfileInstManager {
    public String createGroupProfileInst(GroupProfileInst groupProfileInst, DomainDriverManager DDManager, String sgroupId) throws AdminException {
        try {
            int nI;
            GroupUserRoleRow newRole = this.makeGroupUserRoleRow(groupProfileInst);
            newRole.groupId = this.idAsInt(sgroupId);
            DDManager.getOrganization().groupUserRole.createGroupUserRole(newRole);
            String sProfileId = GroupProfileInstManager.idAsString(newRole.id);
            for (nI = 0; nI < groupProfileInst.getNumGroup(); ++nI) {
                DDManager.getOrganization().groupUserRole.addGroupInGroupUserRole(this.idAsInt(groupProfileInst.getGroup(nI)), this.idAsInt(sProfileId));
            }
            for (nI = 0; nI < groupProfileInst.getNumUser(); ++nI) {
                DDManager.getOrganization().groupUserRole.addUserInGroupUserRole(this.idAsInt(groupProfileInst.getUser(nI)), this.idAsInt(sProfileId));
            }
            return sProfileId;
        }
        catch (Exception e) {
            throw new AdminException("GroupProfileInstManager.addGroupProfileInst", 4, "admin.EX_ERR_ADD_SPACE_PROFILE", "space profile name: '" + groupProfileInst.getName() + "'", e);
        }
    }

    public GroupProfileInst getGroupProfileInst(DomainDriverManager ddManager, String sProfileId, String sGroupId) throws AdminException {
        if (sGroupId == null) {
            try {
                ddManager.getOrganizationSchema();
                GroupRow group = ddManager.getOrganization().group.getGroupOfGroupUserRole(this.idAsInt(sProfileId));
                if (group == null) {
                    group = new GroupRow();
                }
                sGroupId = GroupProfileInstManager.idAsString(group.id);
            }
            catch (Exception e) {
                throw new AdminException("GroupProfileInstManager.getGroupProfileInst", 4, "admin.EX_ERR_GET_SPACE_PROFILE", "space profile Id: '" + sProfileId + "', groupId: '" + sGroupId + "'", e);
            }
            finally {
                ddManager.releaseOrganizationSchema();
            }
        }
        GroupProfileInst groupProfileInst = new GroupProfileInst();
        groupProfileInst.removeAllGroups();
        groupProfileInst.removeAllUsers();
        this.setGroupProfileInst(groupProfileInst, ddManager, sProfileId, sGroupId);
        return groupProfileInst;
    }

    public void setGroupProfileInst(GroupProfileInst groupProfileInst, DomainDriverManager ddManager, String sProfileId, String sGroupId) throws AdminException {
        try {
            ddManager.getOrganizationSchema();
            GroupUserRoleRow groupUserRole = ddManager.getOrganization().groupUserRole.getGroupUserRoleByGroupId(this.idAsInt(sGroupId));
            groupProfileInst.setGroupId(sGroupId);
            if (groupUserRole != null) {
                groupProfileInst.setId(Integer.toString(groupUserRole.id));
                groupProfileInst.setName(groupUserRole.roleName);
                sProfileId = groupProfileInst.getId();
                String[] asGroupIds = ddManager.getOrganization().group.getDirectGroupIdsInGroupUserRole(this.idAsInt(sProfileId));
                for (int nI = 0; asGroupIds != null && nI < asGroupIds.length; ++nI) {
                    groupProfileInst.addGroup(asGroupIds[nI]);
                }
                String[] asUsersIds = ddManager.getOrganization().user.getDirectUserIdsOfGroupUserRole(this.idAsInt(sProfileId));
                for (int nI = 0; asUsersIds != null && nI < asUsersIds.length; ++nI) {
                    groupProfileInst.addUser(asUsersIds[nI]);
                }
            }
        }
        catch (Exception e) {
            throw new AdminException("GroupProfileInstManager.setGroupProfileInst", 4, "admin.EX_ERR_SET_SPACE_PROFILE", "space profile Id: '" + sProfileId + "', groupId = '" + sGroupId + "'", e);
        }
        finally {
            ddManager.releaseOrganizationSchema();
        }
    }

    public void deleteGroupProfileInst(GroupProfileInst groupProfileInst, DomainDriverManager ddManager) throws AdminException {
        try {
            int nI;
            for (nI = 0; nI < groupProfileInst.getNumGroup(); ++nI) {
                ddManager.getOrganization().groupUserRole.removeGroupFromGroupUserRole(this.idAsInt(groupProfileInst.getGroup(nI)), this.idAsInt(groupProfileInst.getId()));
            }
            for (nI = 0; nI < groupProfileInst.getNumUser(); ++nI) {
                ddManager.getOrganization().groupUserRole.removeUserFromGroupUserRole(this.idAsInt(groupProfileInst.getUser(nI)), this.idAsInt(groupProfileInst.getId()));
            }
            ddManager.getOrganization().groupUserRole.removeGroupUserRole(this.idAsInt(groupProfileInst.getId()));
        }
        catch (Exception e) {
            throw new AdminException("GroupProfileInstManager.deleteGroupProfileInst", 4, "admin.EX_ERR_DELETE_SPACEPROFILE", "space profile Id: '" + groupProfileInst.getId() + "'", e);
        }
    }

    public String updateGroupProfileInst(GroupProfileInst groupProfileInst, DomainDriverManager ddManager, GroupProfileInst groupProfileInstNew) throws AdminException {
        ArrayList<String> alOldProfileGroup = new ArrayList<String>();
        ArrayList<String> alNewProfileGroup = new ArrayList<String>();
        ArrayList<String> alAddGroup = new ArrayList<String>();
        ArrayList<String> alRemGroup = new ArrayList<String>();
        ArrayList<String> alStayGroup = new ArrayList<String>();
        ArrayList<String> alOldProfileUser = new ArrayList<String>();
        ArrayList<String> alNewProfileUser = new ArrayList<String>();
        ArrayList<String> alAddUser = new ArrayList<String>();
        ArrayList<String> alRemUser = new ArrayList<String>();
        ArrayList<String> alStayUser = new ArrayList<String>();
        try {
            ArrayList<String> alGroup = groupProfileInst.getAllGroups();
            for (String anAlGroup : alGroup) {
                alOldProfileGroup.add(anAlGroup);
            }
            alGroup = groupProfileInstNew.getAllGroups();
            for (String anAlGroup : alGroup) {
                alNewProfileGroup.add(anAlGroup);
            }
            for (String anAlOldProfileGroup : alOldProfileGroup) {
                if (alNewProfileGroup.contains(anAlOldProfileGroup)) continue;
                alRemGroup.add(anAlOldProfileGroup);
            }
            for (String anAlNewProfileGroup : alNewProfileGroup) {
                if (!alOldProfileGroup.contains(anAlNewProfileGroup)) {
                    alAddGroup.add(anAlNewProfileGroup);
                    continue;
                }
                alStayGroup.add(anAlNewProfileGroup);
            }
            for (String anAlAddGroup : alAddGroup) {
                ddManager.getOrganization().groupUserRole.addGroupInGroupUserRole(this.idAsInt(anAlAddGroup), this.idAsInt(groupProfileInst.getId()));
            }
            for (String anAlRemGroup : alRemGroup) {
                ddManager.getOrganization().groupUserRole.removeGroupFromGroupUserRole(this.idAsInt(anAlRemGroup), this.idAsInt(groupProfileInst.getId()));
            }
            ArrayList<String> alUser = groupProfileInst.getAllUsers();
            for (String anAlUser : alUser) {
                alOldProfileUser.add(anAlUser);
            }
            alUser = groupProfileInstNew.getAllUsers();
            for (String anAlUser : alUser) {
                alNewProfileUser.add(anAlUser);
            }
            for (String anAlOldProfileUser : alOldProfileUser) {
                if (alNewProfileUser.contains(anAlOldProfileUser)) continue;
                alRemUser.add(anAlOldProfileUser);
            }
            for (String anAlNewProfileUser : alNewProfileUser) {
                if (!alOldProfileUser.contains(anAlNewProfileUser)) {
                    alAddUser.add(anAlNewProfileUser);
                    continue;
                }
                alStayUser.add(anAlNewProfileUser);
            }
            for (String anAlAddUser : alAddUser) {
                ddManager.getOrganization().groupUserRole.addUserInGroupUserRole(this.idAsInt(anAlAddUser), this.idAsInt(groupProfileInst.getId()));
            }
            for (String anAlRemUser : alRemUser) {
                ddManager.getOrganization().groupUserRole.removeUserFromGroupUserRole(this.idAsInt(anAlRemUser), this.idAsInt(groupProfileInst.getId()));
            }
            return groupProfileInst.getId();
        }
        catch (Exception e) {
            throw new AdminException("GroupProfileInstManager.updateGroupProfileInst", 4, "admin.EX_ERR_UPDATE_SPACEPROFILE", "space profile Id: '" + groupProfileInst.getId() + "'", e);
        }
    }

    private GroupUserRoleRow makeGroupUserRoleRow(GroupProfileInst groupProfileInst) {
        GroupUserRoleRow groupUserRole = new GroupUserRoleRow();
        groupUserRole.id = this.idAsInt(groupProfileInst.getId());
        groupUserRole.roleName = groupProfileInst.getName();
        return groupUserRole;
    }

    private int idAsInt(String id) {
        if (id == null || id.length() == 0) {
            return -1;
        }
        try {
            return Integer.parseInt(id);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private static String idAsString(int id) {
        return Integer.toString(id);
    }
}

