/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.beans.admin;

import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.AdminException;
import com.stratelia.webactiv.beans.admin.DomainDriverManager;
import com.stratelia.webactiv.beans.admin.ProfileInst;
import com.stratelia.webactiv.beans.admin.dao.RoleDAO;
import com.stratelia.webactiv.organization.AdminPersistenceException;
import com.stratelia.webactiv.organization.UserRoleRow;
import com.stratelia.webactiv.util.DBUtil;
import com.stratelia.webactiv.util.JNDINames;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ProfileInstManager {
    public String createProfileInst(ProfileInst profileInst, DomainDriverManager ddManager, String sFatherCompoId) throws AdminException {
        try {
            int nI;
            UserRoleRow newRole = this.makeUserRoleRow(profileInst);
            newRole.id = -1;
            newRole.instanceId = this.idAsInt(sFatherCompoId);
            ddManager.getOrganization().userRole.createUserRole(newRole);
            String sProfileNodeId = ProfileInstManager.idAsString(newRole.id);
            for (nI = 0; nI < profileInst.getNumGroup(); ++nI) {
                ddManager.getOrganization().userRole.addGroupInUserRole(this.idAsInt(profileInst.getGroup(nI)), this.idAsInt(sProfileNodeId));
            }
            for (nI = 0; nI < profileInst.getNumUser(); ++nI) {
                ddManager.getOrganization().userRole.addUserInUserRole(this.idAsInt(profileInst.getUser(nI)), this.idAsInt(sProfileNodeId));
            }
            return sProfileNodeId;
        }
        catch (Exception e) {
            throw new AdminException("ProfileInstManager.createProfileInst", 4, "admin.EX_ERR_ADD_PROFILE", "profile name: '" + profileInst.getName() + "', father component Id: '" + sFatherCompoId + "'", e);
        }
    }

    public ProfileInst getProfileInst(DomainDriverManager ddManager, String sProfileId, String sFatherId) throws AdminException {
        ProfileInst profileInst = null;
        try {
            ddManager.getOrganizationSchema();
            UserRoleRow userRole = ddManager.getOrganization().userRole.getUserRole(this.idAsInt(sProfileId));
            if (userRole != null) {
                profileInst = this.userRoleRow2ProfileInst(userRole);
                this.setUsersAndGroups(ddManager, profileInst);
            } else {
                SilverTrace.error("admin", "ProfileInstManager.getProfileInst", "root.EX_RECORD_NOT_FOUND", "sProfileId = " + sProfileId);
            }
        }
        catch (Exception e) {
            throw new AdminException("ProfileInstManager.getProfileInst", 4, "admin.EX_ERR_SET_PROFILE", "profile Id: '" + sProfileId + "', father component Id: '" + sFatherId + "'", e);
        }
        finally {
            ddManager.releaseOrganizationSchema();
        }
        return profileInst;
    }

    private ProfileInst userRoleRow2ProfileInst(UserRoleRow userRole) {
        ProfileInst profileInst = new ProfileInst();
        profileInst.setId(Integer.toString(userRole.id));
        profileInst.setName(userRole.roleName);
        profileInst.setLabel(userRole.name);
        profileInst.setDescription(userRole.description);
        profileInst.setComponentFatherId(Integer.toString(userRole.instanceId));
        if (userRole.isInherited == 1) {
            profileInst.setInherited(true);
        }
        if (userRole.objectId > 0) {
            profileInst.setObjectId(userRole.objectId);
        }
        profileInst.setObjectType(userRole.objectType);
        return profileInst;
    }

    private void setUsersAndGroups(DomainDriverManager ddManager, ProfileInst profileInst) throws AdminPersistenceException {
        String[] asUsersIds;
        String[] asGroupIds = ddManager.getOrganization().group.getDirectGroupIdsInUserRole(this.idAsInt(profileInst.getId()));
        if (asGroupIds != null) {
            for (String groupId : asGroupIds) {
                profileInst.addGroup(groupId);
            }
        }
        if ((asUsersIds = ddManager.getOrganization().user.getDirectUserIdsOfUserRole(this.idAsInt(profileInst.getId()))) != null) {
            for (String userId : asUsersIds) {
                profileInst.addUser(userId);
            }
        }
    }

    public ProfileInst getInheritedProfileInst(DomainDriverManager ddManager, String instanceId, String roleName) throws AdminException {
        try {
            ddManager.getOrganizationSchema();
            UserRoleRow userRole = ddManager.getOrganization().userRole.getUserRole(this.idAsInt(instanceId), roleName, 1);
            ProfileInst profileInst = null;
            if (userRole != null) {
                profileInst = this.userRoleRow2ProfileInst(userRole);
                this.setUsersAndGroups(ddManager, profileInst);
            }
            ProfileInst profileInst2 = profileInst;
            return profileInst2;
        }
        catch (Exception e) {
            throw new AdminException("ProfileInstManager.getInheritedProfileInst", 4, "admin.EX_ERR_GET_SPACE_PROFILE", "instanceId = " + instanceId + ", role = " + roleName, e);
        }
        finally {
            ddManager.releaseOrganizationSchema();
        }
    }

    public void deleteProfileInst(ProfileInst profileInst, DomainDriverManager ddManager) throws AdminException {
        try {
            ddManager.getOrganization().userRole.removeUserRole(this.idAsInt(profileInst.getId()));
        }
        catch (Exception e) {
            throw new AdminException("ProfileInstManager.deleteProfileInst", 4, "admin.EX_ERR_DELETE_PROFILE", "profile Id: '" + profileInst.getId() + "'", e);
        }
    }

    public String updateProfileInst(DomainDriverManager ddManager, ProfileInst profileInstNew) throws AdminException {
        ProfileInst profileInst = this.getProfileInst(ddManager, profileInstNew.getId(), null);
        ArrayList<String> alOldProfileGroup = new ArrayList<String>();
        ArrayList<String> alNewProfileGroup = new ArrayList<String>();
        ArrayList<String> alAddGroup = new ArrayList<String>();
        ArrayList<String> alRemGroup = new ArrayList<String>();
        ArrayList<String> alOldProfileUser = new ArrayList<String>();
        ArrayList<String> alNewProfileUser = new ArrayList<String>();
        ArrayList<String> alAddUser = new ArrayList<String>();
        ArrayList<String> alRemUser = new ArrayList<String>();
        try {
            ArrayList<String> alGroup = profileInst.getAllGroups();
            for (String groupId : alGroup) {
                alOldProfileGroup.add(groupId);
            }
            alGroup = profileInstNew.getAllGroups();
            for (String groupId : alGroup) {
                alNewProfileGroup.add(groupId);
            }
            for (String groupId : alOldProfileGroup) {
                if (alNewProfileGroup.contains(groupId)) continue;
                alRemGroup.add(groupId);
            }
            for (String groupId : alNewProfileGroup) {
                if (alOldProfileGroup.contains(groupId)) continue;
                alAddGroup.add(groupId);
            }
            for (String groupId : alAddGroup) {
                ddManager.getOrganization().userRole.addGroupInUserRole(this.idAsInt(groupId), this.idAsInt(profileInst.getId()));
            }
            for (String groupId : alRemGroup) {
                ddManager.getOrganization().userRole.removeGroupFromUserRole(this.idAsInt(groupId), this.idAsInt(profileInst.getId()));
            }
            ArrayList<String> alUser = profileInst.getAllUsers();
            for (String userId : alUser) {
                alOldProfileUser.add(userId);
            }
            alUser = profileInstNew.getAllUsers();
            for (String userId : alUser) {
                alNewProfileUser.add(userId);
            }
            for (String userId : alOldProfileUser) {
                if (alNewProfileUser.contains(userId)) continue;
                alRemUser.add(userId);
            }
            for (String userId : alNewProfileUser) {
                if (alOldProfileUser.contains(userId)) continue;
                alAddUser.add(userId);
            }
            for (String userId : alAddUser) {
                ddManager.getOrganization().userRole.addUserInUserRole(this.idAsInt(userId), this.idAsInt(profileInst.getId()));
            }
            for (String userId : alRemUser) {
                ddManager.getOrganization().userRole.removeUserFromUserRole(this.idAsInt(userId), this.idAsInt(profileInst.getId()));
            }
            UserRoleRow changedUserRole = this.makeUserRoleRow(profileInstNew);
            changedUserRole.id = this.idAsInt(profileInstNew.getId());
            ddManager.getOrganization().userRole.updateUserRole(changedUserRole);
            return ProfileInstManager.idAsString(changedUserRole.id);
        }
        catch (Exception e) {
            throw new AdminException("ProfileInstManager.updateProfileInst", 4, "admin.EX_ERR_UPDATE_PROFILE", "profile Id: '" + profileInst.getId() + "'", e);
        }
    }

    public String[] getProfileIdsOfUser(String sUserId, List<String> groupIds) throws AdminException {
        Connection con = null;
        try {
            con = DBUtil.makeConnection(JNDINames.ADMIN_DATASOURCE);
            List<UserRoleRow> roles = RoleDAO.getRoles(con, groupIds, Integer.parseInt(sUserId));
            ArrayList<String> roleIds = new ArrayList<String>();
            for (UserRoleRow role : roles) {
                roleIds.add(Integer.toString(role.id));
            }
            String[] stringArray = roleIds.toArray(new String[roleIds.size()]);
            return stringArray;
        }
        catch (Exception e) {
            throw new AdminException("ProfiledObjectManager.getProfileIdsOfUserAndGroups", 4, "admin.EX_ERR_GET_PROFILES", e);
        }
        finally {
            DBUtil.close(con);
        }
    }

    public String[] getAllComponentObjectProfileIdsOfUser(String sUserId, List<String> groupIds) throws AdminException {
        Connection con = null;
        try {
            con = DBUtil.makeConnection(JNDINames.ADMIN_DATASOURCE);
            List<UserRoleRow> roles = RoleDAO.getAllComponentObjectRoles(con, groupIds, Integer.parseInt(sUserId));
            ArrayList<String> roleIds = new ArrayList<String>();
            for (UserRoleRow role : roles) {
                roleIds.add(Integer.toString(role.id));
            }
            String[] stringArray = roleIds.toArray(new String[roleIds.size()]);
            return stringArray;
        }
        catch (Exception e) {
            throw new AdminException("ProfiledObjectManager.getNodeProfileIdsOfUserAndGroups", 4, "admin.EX_ERR_GET_PROFILES", e);
        }
        finally {
            DBUtil.close(con);
        }
    }

    public String[] getProfileNamesOfUser(String sUserId, List<String> groupIds, int componentId) throws AdminException {
        Connection con = null;
        try {
            con = DBUtil.makeConnection(JNDINames.ADMIN_DATASOURCE);
            List<UserRoleRow> roles = RoleDAO.getRoles(con, groupIds, Integer.parseInt(sUserId), componentId);
            ArrayList<String> roleNames = new ArrayList<String>();
            for (UserRoleRow role : roles) {
                if (roleNames.contains(role.roleName)) continue;
                roleNames.add(role.roleName);
            }
            String[] stringArray = roleNames.toArray(new String[roleNames.size()]);
            return stringArray;
        }
        catch (Exception e) {
            throw new AdminException("ProfiledObjectManager.getProfileNamesOfUserAndGroup", 4, "admin.EX_ERR_GET_PROFILES", e);
        }
        finally {
            DBUtil.close(con);
        }
    }

    public String[] getProfileIdsOfGroup(String sGroupId) throws AdminException {
        Connection con = null;
        try {
            con = DBUtil.makeConnection(JNDINames.ADMIN_DATASOURCE);
            ArrayList<String> groupIds = new ArrayList<String>();
            groupIds.add(sGroupId);
            List<UserRoleRow> roles = RoleDAO.getRoles(con, groupIds, -1);
            ArrayList<String> roleIds = new ArrayList<String>();
            for (UserRoleRow role : roles) {
                roleIds.add(Integer.toString(role.id));
            }
            String[] stringArray = roleIds.toArray(new String[roleIds.size()]);
            return stringArray;
        }
        catch (Exception e) {
            throw new AdminException("ProfiledObjectManager.getProfileIdsOfGroup", 4, "admin.EX_ERR_GET_PROFILES", e);
        }
        finally {
            DBUtil.close(con);
        }
    }

    public String[] getAllComponentObjectProfileIdsOfGroup(String groupId) throws AdminException {
        Connection con = null;
        try {
            con = DBUtil.makeConnection(JNDINames.ADMIN_DATASOURCE);
            List<UserRoleRow> roles = RoleDAO.getAllComponentObjectRoles(con, Collections.singletonList(groupId), -1);
            ArrayList<String> roleIds = new ArrayList<String>();
            for (UserRoleRow role : roles) {
                roleIds.add(Integer.toString(role.id));
            }
            String[] stringArray = roleIds.toArray(new String[roleIds.size()]);
            return stringArray;
        }
        catch (Exception e) {
            throw new AdminException("ProfiledObjectManager.getNodeProfileIdsOfGroup", 4, "admin.EX_ERR_GET_PROFILES", e);
        }
        finally {
            DBUtil.close(con);
        }
    }

    private UserRoleRow makeUserRoleRow(ProfileInst profileInst) {
        UserRoleRow userRole = new UserRoleRow();
        userRole.id = this.idAsInt(profileInst.getId());
        userRole.roleName = profileInst.getName();
        userRole.name = profileInst.getLabel();
        userRole.description = profileInst.getDescription();
        if (profileInst.isInherited()) {
            userRole.isInherited = 1;
        }
        userRole.objectId = profileInst.getObjectId();
        userRole.objectType = profileInst.getObjectType();
        return userRole;
    }

    private int idAsInt(String id) {
        if (id == null || id.length() == 0) {
            return -1;
        }
        try {
            return Integer.parseInt(id);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private static String idAsString(int id) {
        return Integer.toString(id);
    }
}

