/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.beans.admin;

import com.stratelia.webactiv.beans.admin.AdminException;
import com.stratelia.webactiv.beans.admin.DomainDriverManager;
import com.stratelia.webactiv.beans.admin.ProfileInst;
import com.stratelia.webactiv.beans.admin.ProfileInstManager;
import com.stratelia.webactiv.beans.admin.dao.RoleDAO;
import com.stratelia.webactiv.organization.UserRoleRow;
import com.stratelia.webactiv.util.DBUtil;
import com.stratelia.webactiv.util.JNDINames;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProfiledObjectManager {
    static ProfileInstManager m_ProfileInstManager = new ProfileInstManager();

    public List<ProfileInst> getProfiles(DomainDriverManager ddManager, int objectId, String objectType, int componentId) throws AdminException {
        ArrayList<ProfileInst> profiles = new ArrayList<ProfileInst>();
        String[] asProfileIds = null;
        try {
            ddManager.getOrganizationSchema();
            asProfileIds = ddManager.getOrganization().userRole.getAllUserRoleIdsOfObject(objectId, objectType, componentId);
        }
        catch (Exception e) {
            throw new AdminException("ProfiledObjectManager.getProfiles", 4, "admin.EX_ERR_GET_PROFILE", "objectId = " + objectId + ", componentId = " + componentId, e);
        }
        finally {
            ddManager.releaseOrganizationSchema();
        }
        for (int nI = 0; asProfileIds != null && nI < asProfileIds.length; ++nI) {
            ProfileInst profileInst = m_ProfileInstManager.getProfileInst(ddManager, asProfileIds[nI], Integer.toString(componentId));
            profileInst.setObjectType(objectType);
            profiles.add(profileInst);
        }
        return profiles;
    }

    public String[] getUserProfileNames(int objectId, String objectType, int componentId, int userId, List<String> groupIds) throws AdminException {
        if (objectId == -1) {
            return new String[0];
        }
        Connection con = null;
        try {
            con = DBUtil.makeConnection(JNDINames.ADMIN_DATASOURCE);
            List<UserRoleRow> roles = RoleDAO.getRoles(con, objectId, objectType, componentId, groupIds, userId);
            ArrayList<String> roleNames = new ArrayList<String>();
            for (UserRoleRow role : roles) {
                roleNames.add(role.roleName);
            }
            String[] stringArray = roleNames.toArray(new String[roleNames.size()]);
            return stringArray;
        }
        catch (Exception e) {
            throw new AdminException("ProfiledObjectManager.getUserProfileNames", 4, "admin.EX_ERR_GET_PROFILES", e);
        }
        finally {
            DBUtil.close(con);
        }
    }

    public Map<Integer, List<String>> getUserProfileNames(String objectType, int componentId, int userId, List<String> groupIds) throws AdminException {
        Connection con = null;
        try {
            con = DBUtil.makeConnection(JNDINames.ADMIN_DATASOURCE);
            List<UserRoleRow> roles = RoleDAO.getRoles(con, -1, objectType, componentId, groupIds, userId);
            HashMap<Integer, List<String>> objectProfiles = new HashMap<Integer, List<String>>(roles.size());
            Collections.sort(roles, new Comparator<UserRoleRow>(){

                @Override
                public int compare(UserRoleRow o1, UserRoleRow o2) {
                    return o1.objectId - o2.objectId;
                }
            });
            int currentObjectId = -1;
            ArrayList<String> roleNames = new ArrayList<String>();
            for (UserRoleRow role : roles) {
                if (currentObjectId != role.objectId) {
                    currentObjectId = role.objectId;
                    roleNames = new ArrayList();
                    objectProfiles.put(currentObjectId, roleNames);
                }
                roleNames.add(role.roleName);
            }
            HashMap<Integer, List<String>> hashMap = objectProfiles;
            return hashMap;
        }
        catch (Exception e) {
            throw new AdminException("ProfiledObjectManager.getUserProfileNames", 4, "admin.EX_ERR_GET_PROFILES", e);
        }
        finally {
            DBUtil.close(con);
        }
    }

    public List<ProfileInst> getProfiles(DomainDriverManager ddManager, int componentId) throws AdminException {
        ArrayList<ProfileInst> profiles = new ArrayList<ProfileInst>();
        String[] asProfileIds = null;
        try {
            ddManager.getOrganizationSchema();
            asProfileIds = ddManager.getOrganization().userRole.getAllObjectUserRoleIdsOfInstance(componentId);
        }
        catch (Exception e) {
            throw new AdminException("ProfiledObjectManager.getProfiles", 4, "admin.EX_ERR_GET_PROFILE", "componentId = " + componentId, e);
        }
        finally {
            ddManager.releaseOrganizationSchema();
        }
        for (int nI = 0; asProfileIds != null && nI < asProfileIds.length; ++nI) {
            ProfileInst profileInst = m_ProfileInstManager.getProfileInst(ddManager, asProfileIds[nI], Integer.toString(componentId));
            profiles.add(profileInst);
        }
        return profiles;
    }
}

