/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.beans.admin;

import com.silverpeas.util.StringUtil;
import com.stratelia.webactiv.beans.admin.AdminException;
import com.stratelia.webactiv.beans.admin.DomainDriverManager;
import com.stratelia.webactiv.beans.admin.SpaceProfileInst;
import com.stratelia.webactiv.organization.AdminPersistenceException;
import com.stratelia.webactiv.organization.SpaceRow;
import com.stratelia.webactiv.organization.SpaceUserRoleRow;
import java.util.ArrayList;

public class SpaceProfileInstManager {
    public String[] getSpaceProfileIdsOfUserType(DomainDriverManager domainManager, String sUserId) throws AdminException {
        try {
            SpaceUserRoleRow[] tabSpaceUserRole;
            domainManager.getOrganizationSchema();
            ArrayList<String> roleIds = new ArrayList<String>();
            for (SpaceUserRoleRow role : tabSpaceUserRole = domainManager.getOrganization().spaceUserRole.getDirectSpaceUserRolesOfUser(Integer.parseInt(sUserId))) {
                roleIds.add(Integer.toString(role.id));
            }
            String[] stringArray = roleIds.toArray(new String[roleIds.size()]);
            return stringArray;
        }
        catch (Exception e) {
            throw new AdminException("SpaceProfileInstManager.getSpaceProfileIdsOfUser", 4, "admin.EX_ERR_GET_PROFILES", e);
        }
        finally {
            domainManager.releaseOrganizationSchema();
        }
    }

    public String[] getSpaceProfileIdsOfGroupType(DomainDriverManager domainManager, String groupId) throws AdminException {
        try {
            SpaceUserRoleRow[] tabSpaceGroupRole;
            domainManager.getOrganizationSchema();
            ArrayList<String> roleIds = new ArrayList<String>();
            for (SpaceUserRoleRow role : tabSpaceGroupRole = domainManager.getOrganization().spaceUserRole.getDirectSpaceUserRolesOfGroup(Integer.parseInt(groupId))) {
                roleIds.add(Integer.toString(role.id));
            }
            String[] stringArray = roleIds.toArray(new String[roleIds.size()]);
            return stringArray;
        }
        catch (Exception e) {
            throw new AdminException("SpaceProfileInstManager.getSpaceProfileIdsOfGroup", 4, "admin.EX_ERR_GET_PROFILES", e);
        }
        finally {
            domainManager.releaseOrganizationSchema();
        }
    }

    public String createSpaceProfileInst(SpaceProfileInst spaceProfileInst, DomainDriverManager domainManager, String parentSpaceId) throws AdminException {
        try {
            SpaceUserRoleRow newRole = this.makeSpaceUserRoleRow(spaceProfileInst);
            newRole.spaceId = this.idAsInt(parentSpaceId);
            domainManager.getOrganization().spaceUserRole.createSpaceUserRole(newRole);
            String spaceProfileNodeId = SpaceProfileInstManager.idAsString(newRole.id);
            for (String groupId : spaceProfileInst.getAllGroups()) {
                domainManager.getOrganization().spaceUserRole.addGroupInSpaceUserRole(this.idAsInt(groupId), this.idAsInt(spaceProfileNodeId));
            }
            for (String userId : spaceProfileInst.getAllUsers()) {
                domainManager.getOrganization().spaceUserRole.addUserInSpaceUserRole(this.idAsInt(userId), this.idAsInt(spaceProfileNodeId));
            }
            return spaceProfileNodeId;
        }
        catch (Exception e) {
            throw new AdminException("SpaceProfileInstManager.addSpaceProfileInst", 4, "admin.EX_ERR_ADD_SPACE_PROFILE", "space profile name: '" + spaceProfileInst.getName() + "'", e);
        }
    }

    public SpaceProfileInst getSpaceProfileInst(DomainDriverManager ddManager, String spaceProfileId, String parentSpaceId) throws AdminException {
        if (!StringUtil.isDefined(parentSpaceId)) {
            try {
                ddManager.getOrganizationSchema();
                SpaceRow space = ddManager.getOrganization().space.getSpaceOfSpaceUserRole(this.idAsInt(spaceProfileId));
                if (space == null) {
                    space = new SpaceRow();
                }
                parentSpaceId = SpaceProfileInstManager.idAsString(space.id);
            }
            catch (Exception e) {
                throw new AdminException("SpaceProfileInstManager.getSpaceProfileInst", 4, "admin.EX_ERR_GET_SPACE_PROFILE", "space profile Id: '" + spaceProfileId + "', space Id: '" + parentSpaceId + "'", e);
            }
            finally {
                ddManager.releaseOrganizationSchema();
            }
        }
        try {
            ddManager.getOrganizationSchema();
            SpaceUserRoleRow spaceUserRole = ddManager.getOrganization().spaceUserRole.getSpaceUserRole(this.idAsInt(spaceProfileId));
            SpaceProfileInst spaceProfileInst = null;
            if (spaceUserRole != null) {
                spaceProfileInst = this.spaceUserRoleRow2SpaceProfileInst(spaceUserRole);
                this.setUsersAndGroups(ddManager, spaceProfileInst);
            }
            SpaceProfileInst spaceProfileInst2 = spaceProfileInst;
            return spaceProfileInst2;
        }
        catch (Exception e) {
            throw new AdminException("SpaceProfileInstManager.getSpaceProfileInst", 4, "admin.EX_ERR_SET_SPACE_PROFILE", "space profile Id: '" + spaceProfileId + "', space Id: '" + parentSpaceId + "'", e);
        }
        finally {
            ddManager.releaseOrganizationSchema();
        }
    }

    public SpaceProfileInst getInheritedSpaceProfileInstByName(DomainDriverManager ddManager, String spaceId, String roleName) throws AdminException {
        return this.getSpaceProfileInst(ddManager, spaceId, roleName, true);
    }

    public SpaceProfileInst getSpaceProfileInstByName(DomainDriverManager ddManager, String spaceId, String roleName) throws AdminException {
        return this.getSpaceProfileInst(ddManager, spaceId, roleName, false);
    }

    private SpaceProfileInst getSpaceProfileInst(DomainDriverManager ddManager, String spaceId, String roleName, boolean isInherited) throws AdminException {
        try {
            ddManager.getOrganizationSchema();
            int inherited = 0;
            if (isInherited) {
                inherited = 1;
            }
            SpaceUserRoleRow spaceUserRole = ddManager.getOrganization().spaceUserRole.getSpaceUserRole(this.idAsInt(spaceId), roleName, inherited);
            SpaceProfileInst spaceProfileInst = null;
            if (spaceUserRole != null) {
                spaceProfileInst = this.spaceUserRoleRow2SpaceProfileInst(spaceUserRole);
                this.setUsersAndGroups(ddManager, spaceProfileInst);
            }
            SpaceProfileInst spaceProfileInst2 = spaceProfileInst;
            return spaceProfileInst2;
        }
        catch (Exception e) {
            throw new AdminException("SpaceProfileInstManager.getInheritedSpaceProfileInst", 4, "admin.EX_ERR_GET_SPACE_PROFILE", "spaceId = " + spaceId + ", role = " + roleName, e);
        }
        finally {
            ddManager.releaseOrganizationSchema();
        }
    }

    private void setUsersAndGroups(DomainDriverManager ddManager, SpaceProfileInst spaceProfileInst) throws AdminPersistenceException {
        String[] asUsersIds;
        String[] asGroupIds = ddManager.getOrganization().group.getDirectGroupIdsInSpaceUserRole(this.idAsInt(spaceProfileInst.getId()));
        if (asGroupIds != null) {
            for (String groupId : asGroupIds) {
                spaceProfileInst.addGroup(groupId);
            }
        }
        if ((asUsersIds = ddManager.getOrganization().user.getDirectUserIdsOfSpaceUserRole(this.idAsInt(spaceProfileInst.getId()))) != null) {
            for (String userId : asUsersIds) {
                spaceProfileInst.addUser(userId);
            }
        }
    }

    private SpaceProfileInst spaceUserRoleRow2SpaceProfileInst(SpaceUserRoleRow spaceUserRole) {
        SpaceProfileInst spaceProfileInst = new SpaceProfileInst();
        spaceProfileInst.setId(Integer.toString(spaceUserRole.id));
        spaceProfileInst.setName(spaceUserRole.roleName);
        spaceProfileInst.setLabel(spaceUserRole.name);
        spaceProfileInst.setDescription(spaceUserRole.description);
        spaceProfileInst.setSpaceFatherId(Integer.toString(spaceUserRole.spaceId));
        if (spaceUserRole.isInherited == 1) {
            spaceProfileInst.setInherited(true);
        }
        return spaceProfileInst;
    }

    public void deleteSpaceProfileInst(SpaceProfileInst spaceProfileInst, DomainDriverManager ddManager) throws AdminException {
        try {
            ddManager.getOrganization().spaceUserRole.removeSpaceUserRole(this.idAsInt(spaceProfileInst.getId()));
        }
        catch (Exception e) {
            throw new AdminException("SpaceProfileInstManager.deleteSpaceProfileInst", 4, "admin.EX_ERR_DELETE_SPACEPROFILE", "space profile Id: '" + spaceProfileInst.getId() + "'", e);
        }
    }

    public String updateSpaceProfileInst(SpaceProfileInst spaceProfileInst, DomainDriverManager ddManager, SpaceProfileInst spaceProfileInstNew) throws AdminException {
        ArrayList<String> alOldSpaceProfileGroup = new ArrayList<String>();
        ArrayList<String> alNewSpaceProfileGroup = new ArrayList<String>();
        ArrayList<String> alAddGroup = new ArrayList<String>();
        ArrayList<String> alRemGroup = new ArrayList<String>();
        ArrayList<String> alOldSpaceProfileUser = new ArrayList<String>();
        ArrayList<String> alNewSpaceProfileUser = new ArrayList<String>();
        ArrayList<String> alAddUser = new ArrayList<String>();
        ArrayList<String> alRemUser = new ArrayList<String>();
        try {
            ArrayList<String> alGroup = spaceProfileInst.getAllGroups();
            for (String groupId : alGroup) {
                alOldSpaceProfileGroup.add(groupId);
            }
            alGroup = spaceProfileInstNew.getAllGroups();
            for (String groupId : alGroup) {
                alNewSpaceProfileGroup.add(groupId);
            }
            for (String groupId : alOldSpaceProfileGroup) {
                if (alNewSpaceProfileGroup.contains(groupId)) continue;
                alRemGroup.add(groupId);
            }
            for (String groupId : alNewSpaceProfileGroup) {
                if (alOldSpaceProfileGroup.contains(groupId)) continue;
                alAddGroup.add(groupId);
            }
            for (String groupId : alAddGroup) {
                ddManager.getOrganization().spaceUserRole.addGroupInSpaceUserRole(this.idAsInt(groupId), this.idAsInt(spaceProfileInst.getId()));
            }
            for (String groupId : alRemGroup) {
                ddManager.getOrganization().spaceUserRole.removeGroupFromSpaceUserRole(this.idAsInt(groupId), this.idAsInt(spaceProfileInst.getId()));
            }
            ArrayList<String> alUser = spaceProfileInst.getAllUsers();
            for (String userId : alUser) {
                alOldSpaceProfileUser.add(userId);
            }
            alUser = spaceProfileInstNew.getAllUsers();
            for (String userId : alUser) {
                alNewSpaceProfileUser.add(userId);
            }
            for (String userId : alOldSpaceProfileUser) {
                if (alNewSpaceProfileUser.contains(userId)) continue;
                alRemUser.add(userId);
            }
            for (String userId : alNewSpaceProfileUser) {
                if (alOldSpaceProfileUser.contains(userId)) continue;
                alAddUser.add(userId);
            }
            for (String userId : alAddUser) {
                ddManager.getOrganization().spaceUserRole.addUserInSpaceUserRole(this.idAsInt(userId), this.idAsInt(spaceProfileInst.getId()));
            }
            for (String userId : alRemUser) {
                ddManager.getOrganization().spaceUserRole.removeUserFromSpaceUserRole(this.idAsInt(userId), this.idAsInt(spaceProfileInst.getId()));
            }
            SpaceUserRoleRow changedSpaceUserRole = this.makeSpaceUserRoleRow(spaceProfileInstNew);
            changedSpaceUserRole.id = this.idAsInt(spaceProfileInstNew.getId());
            ddManager.getOrganization().spaceUserRole.updateSpaceUserRole(changedSpaceUserRole);
            return SpaceProfileInstManager.idAsString(changedSpaceUserRole.id);
        }
        catch (Exception e) {
            throw new AdminException("SpaceProfileInstManager.updateSpaceProfileInst", 4, "admin.EX_ERR_UPDATE_SPACEPROFILE", "space profile Id: '" + spaceProfileInst.getId() + "'", e);
        }
    }

    private SpaceUserRoleRow makeSpaceUserRoleRow(SpaceProfileInst spaceProfileInst) {
        SpaceUserRoleRow spaceUserRole = new SpaceUserRoleRow();
        spaceUserRole.id = this.idAsInt(spaceProfileInst.getId());
        spaceUserRole.roleName = spaceProfileInst.getName();
        spaceUserRole.name = spaceProfileInst.getLabel();
        spaceUserRole.description = spaceProfileInst.getDescription();
        if (spaceProfileInst.isInherited()) {
            spaceUserRole.isInherited = 1;
        }
        return spaceUserRole;
    }

    private int idAsInt(String id) {
        if (id == null || id.length() == 0) {
            return -1;
        }
        try {
            return Integer.parseInt(id);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private static String idAsString(int id) {
        return Integer.toString(id);
    }
}

