/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.beans.admin;

import com.silverpeas.scheduler.Scheduler;
import com.silverpeas.scheduler.SchedulerEvent;
import com.silverpeas.scheduler.SchedulerEventListener;
import com.silverpeas.scheduler.SchedulerFactory;
import com.silverpeas.scheduler.trigger.JobTrigger;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.AdminException;
import com.stratelia.webactiv.beans.admin.AdminReference;
import com.stratelia.webactiv.beans.admin.SynchroGroupReport;
import java.util.ArrayList;
import java.util.List;

public class SynchroGroupScheduler
implements SchedulerEventListener {
    public static final String ADMINSYNCHROGROUP_JOB_NAME = "AdminSynchroGroupJob";
    private List<String> synchronizedGroupIds = null;

    public void initialize(String cron, List<String> synchronizedGroupIds) {
        try {
            this.synchronizedGroupIds = synchronizedGroupIds;
            SchedulerFactory schedulerFactory = SchedulerFactory.getFactory();
            Scheduler scheduler = schedulerFactory.getScheduler();
            scheduler.unscheduleJob(ADMINSYNCHROGROUP_JOB_NAME);
            JobTrigger trigger = JobTrigger.triggerAt(cron);
            scheduler.scheduleJob(ADMINSYNCHROGROUP_JOB_NAME, trigger, (SchedulerEventListener)this);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "SynchroGroupScheduler.initialize()", "importExport.EX_CANT_INIT_SCHEDULED_IMPORT", e);
        }
    }

    public void doSynchroGroup() {
        SilverTrace.info("admin", "SynchroGroupScheduler.doSynchroGroup()", "root.MSG_GEN_ENTER_METHOD");
        SynchroGroupReport.startSynchro();
        for (int i = 0; this.synchronizedGroupIds != null && i < this.synchronizedGroupIds.size(); ++i) {
            String groupId = this.synchronizedGroupIds.get(i);
            try {
                AdminReference.getAdminService().synchronizeGroupByRule(groupId, true);
                continue;
            }
            catch (AdminException e) {
                SilverTrace.error("admin", "SynchroGroupScheduler.doSynchroGroup", "admin.MSG_ERR_SYNCHRONIZE_GROUP", e);
            }
        }
        SynchroGroupReport.stopSynchro();
        SilverTrace.info("admin", "SynchroGroupScheduler.doScheduledImport()", "root.MSG_GEN_EXIT_METHOD");
    }

    public void addGroup(String groupId) {
        if (this.synchronizedGroupIds == null) {
            this.synchronizedGroupIds = new ArrayList<String>();
        }
        this.synchronizedGroupIds.add(groupId);
    }

    public void removeGroup(String groupId) {
        if (this.synchronizedGroupIds != null) {
            this.synchronizedGroupIds.remove(groupId);
        }
    }

    @Override
    public void triggerFired(SchedulerEvent anEvent) {
        String jobName = anEvent.getJobExecutionContext().getJobName();
        SilverTrace.debug("admin", "SynchroGroupScheduler.handleSchedulerEvent", "The job '" + jobName + "' is executed");
        this.doSynchroGroup();
    }

    @Override
    public void jobSucceeded(SchedulerEvent anEvent) {
        String jobName = anEvent.getJobExecutionContext().getJobName();
        SilverTrace.debug("admin", "SynchroGroupScheduler.handleSchedulerEvent", "The job '" + jobName + "' was successfull");
    }

    @Override
    public void jobFailed(SchedulerEvent anEvent) {
        String jobName = anEvent.getJobExecutionContext().getJobName();
        SilverTrace.error("admin", "SynchroGroupScheduler.handleSchedulerEvent", "The job '" + jobName + "' was not successfull");
    }
}

