/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.beans.admin.dao;

import com.silverpeas.util.StringUtil;
import com.stratelia.webactiv.beans.admin.SpaceInstLight;
import com.stratelia.webactiv.util.DBUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class SpaceDAO {
    private static final String SPACE_COLUMNS = "id,domainFatherId,name,description,createdBy,firstPageType,firstPageExtraParam,orderNum,createTime,updateTime,removeTime,spaceStatus,updatedBy,removedBy,lang,isInheritanceBlocked,look,displaySpaceFirst,isPersonal";
    private static final String querySortedRootSpaceIds = "SELECT id FROM st_space WHERE domainFatherId IS NULL AND spacestatus IS NULL AND isPersonal IS NULL ORDER BY orderNum";
    private static final String querySortedSubSpaces = "select id,domainFatherId,name,description,createdBy,firstPageType,firstPageExtraParam,orderNum,createTime,updateTime,removeTime,spaceStatus,updatedBy,removedBy,lang,isInheritanceBlocked,look,displaySpaceFirst,isPersonal from st_space where domainFatherId = ?  and spacestatus is null order by orderNum";
    private static final String queryGetManageableSpaceIdsByUser = "SELECT st_spaceuserrole.spaceid FROM st_spaceuserrole_user_rel, st_spaceuserrole WHERE st_spaceuserrole_user_rel.spaceuserroleid = st_spaceuserrole.id AND st_spaceuserrole.rolename='Manager' AND st_spaceuserrole_user_rel.userid=?";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getRootSpaceIds(Connection con) throws SQLException {
        ArrayList<String> arrayList;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            ArrayList<String> spaceIds = new ArrayList<String>();
            stmt = con.prepareStatement(querySortedRootSpaceIds);
            rs = stmt.executeQuery();
            while (rs.next()) {
                spaceIds.add(Integer.toString(rs.getInt(1)));
            }
            arrayList = spaceIds;
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, stmt);
            throw throwable;
        }
        DBUtil.close(rs, stmt);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<SpaceInstLight> getSubSpaces(Connection con, int spaceId) throws SQLException {
        ArrayList<SpaceInstLight> arrayList;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            ArrayList<SpaceInstLight> spaces = new ArrayList<SpaceInstLight>();
            stmt = con.prepareStatement(querySortedSubSpaces);
            stmt.setInt(1, spaceId);
            rs = stmt.executeQuery();
            while (rs.next()) {
                spaces.add(SpaceDAO.fetchSpace(rs));
            }
            arrayList = spaces;
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, stmt);
            throw throwable;
        }
        DBUtil.close(rs, stmt);
        return arrayList;
    }

    public static List<String> getManageableSpaceIds(Connection con, String userId, List<String> groupIds) throws SQLException {
        HashSet<String> manageableSpaceIds = new HashSet<String>();
        if (StringUtil.isDefined(userId)) {
            manageableSpaceIds.addAll(SpaceDAO.getManageableSpaceIdsByUser(con, userId));
        }
        if (groupIds != null && groupIds.size() > 0) {
            manageableSpaceIds.addAll(SpaceDAO.getManageableSpaceIdsByGroups(con, groupIds));
        }
        return new ArrayList<String>(manageableSpaceIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getManageableSpaceIdsByUser(Connection con, String userId) throws SQLException {
        ArrayList<String> arrayList;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            ArrayList<String> groupIds = new ArrayList<String>();
            stmt = con.prepareStatement(queryGetManageableSpaceIdsByUser);
            stmt.setInt(1, Integer.parseInt(userId));
            rs = stmt.executeQuery();
            while (rs.next()) {
                groupIds.add(Integer.toString(rs.getInt(1)));
            }
            arrayList = groupIds;
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, stmt);
            throw throwable;
        }
        DBUtil.close(rs, stmt);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getManageableSpaceIdsByGroups(Connection con, List<String> groupIds) throws SQLException {
        ArrayList<String> arrayList;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            String query = "SELECT st_spaceuserrole.spaceid FROM st_spaceuserrole_group_rel, st_spaceuserrole WHERE st_spaceuserrole_group_rel.spaceuserroleid = st_spaceuserrole.id AND st_spaceuserrole.rolename='Manager' AND st_spaceuserrole_group_rel.groupid IN (" + SpaceDAO.list2String(groupIds) + ")";
            ArrayList<String> manageableSpaceIds = new ArrayList<String>();
            stmt = con.createStatement();
            rs = stmt.executeQuery(query);
            while (rs.next()) {
                manageableSpaceIds.add(Integer.toString(rs.getInt(1)));
            }
            arrayList = manageableSpaceIds;
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, stmt);
            throw throwable;
        }
        DBUtil.close(rs, stmt);
        return arrayList;
    }

    private static String list2String(List<String> ids) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < ids.size(); ++i) {
            if (i != 0) {
                str.append(',');
            }
            str.append(ids.get(i));
        }
        return str.toString();
    }

    private static SpaceInstLight fetchSpace(ResultSet rs) throws SQLException {
        SpaceInstLight space = new SpaceInstLight();
        space.setId(rs.getInt("id"));
        space.setFatherId(rs.getInt("domainFatherId"));
        space.setName(rs.getString("name"));
        space.setOrderNum(rs.getInt("orderNum"));
        space.setLook(rs.getString("look"));
        boolean isPersonalSpace = rs.getInt("isPersonal") == 1;
        space.setPersonalSpace(isPersonalSpace);
        boolean inheritanceBlocked = rs.getInt("isInheritanceBlocked") == 1;
        space.setInheritanceBlocked(inheritanceBlocked);
        return space;
    }
}

