/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.organization;

import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.silverpeasinitialize.CallBackManager;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.SynchroGroupReport;
import com.stratelia.webactiv.beans.admin.SynchroReport;
import com.stratelia.webactiv.beans.admin.cache.GroupCache;
import com.stratelia.webactiv.organization.AdminPersistenceException;
import com.stratelia.webactiv.organization.GroupRow;
import com.stratelia.webactiv.organization.OrganizationSchema;
import com.stratelia.webactiv.organization.SpaceUserRoleRow;
import com.stratelia.webactiv.organization.Table;
import com.stratelia.webactiv.organization.UserRoleRow;
import com.stratelia.webactiv.organization.UserRow;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class GroupTable
extends Table<GroupRow> {
    private static final String GROUP_COLUMNS = "id, specificId, domainId, superGroupId, name, description, synchroRule";
    private static final String SELECT_GROUP_BY_ID = "SELECT id, specificId, domainId, superGroupId, name, description, synchroRule FROM ST_Group WHERE id = ?";
    private static final String SELECT_GROUP_BY_SPECIFICID = "SELECT id, specificId, domainId, superGroupId, name, description, synchroRule FROM ST_Group WHERE domainId = ? AND specificId = ?";
    private static final String SELECT_ROOT_GROUP_BY_NAME = "SELECT id, specificId, domainId, superGroupId, name, description, synchroRule FROM ST_Group WHERE superGroupId IS NULL AND name = ?";
    private static final String SELECT_GROUP_BY_NAME = "SELECT id, specificId, domainId, superGroupId, name, description, synchroRule FROM ST_Group WHERE superGroupId = ? AND name = ?";
    private static final String SELECT_ALL_GROUPS = "select id, specificId, domainId, superGroupId, name, description, synchroRule from ST_Group";
    private static final String SELECT_SYNCHRONIZED_GROUPS = "select id, specificId, domainId, superGroupId, name, description, synchroRule from ST_Group where synchroRule is not null";
    private static final String SELECT_ALL_GROUP_IDS = "select id from ST_Group";
    private static final String SELECT_ALL_ROOT_GROUPS = "select id, specificId, domainId, superGroupId, name, description, synchroRule, UPPER(name) from ST_Group where superGroupId is null order by UPPER(name)";
    private static final String SELECT_ALL_ROOT_GROUP_IDS = "select id, UPPER(name) from ST_Group where superGroupId is null order by UPPER(name)";
    private static final String SELECT_SUBGROUPS = "select id, specificId, domainId, superGroupId, name, description, synchroRule from ST_Group where superGroupId = ?";
    private static final String SELECT_SUBGROUP_IDS = "select id from ST_Group where superGroupId = ?";
    private static final String SELECT_ALL_ROOT_GROUPS_IN_DOMAIN = "select id, specificId, domainId, superGroupId, name, description, synchroRule from ST_Group where (domainId=?) AND (superGroupId is null)";
    private static final String SELECT_ALL_ROOT_GROUPS_IDS_IN_DOMAIN = "select id from ST_Group where (domainId=?) AND (superGroupId is null)";
    private static final String SELECT_ALL_GROUPS_IN_DOMAIN = "select id, specificId, domainId, superGroupId, name, description, synchroRule from ST_Group where domainId=?";
    private static final String SELECT_SUPERGROUP = "select " + GroupTable.aliasColumns("sg", "id, specificId, domainId, superGroupId, name, description, synchroRule") + " from ST_Group sg, ST_GROUP g where sg.id=g.superGroupId and g.id=?";
    private static final String SELECT_USER_GROUPS = "select id, specificId, domainId, superGroupId, name, description, synchroRule from ST_Group,ST_Group_User_Rel where id = groupId and userId = ?";
    private static final String SELECT_USERROLE_GROUP_IDS = "SELECT id FROM st_group, st_userrole_group_rel WHERE id = groupid AND userroleid = ?";
    private static final String SELECT_SPACEUSERROLE_GROUP_IDS = "SELECT id FROM st_group, st_spaceuserrole_group_rel WHERE id = groupId AND spaceUserRoleId = ?";
    private static final String SELECT_GROUPUSERROLE_GROUPS = "SELECT id, specificId, domainId, superGroupId, name, description, synchroRule FROM ST_Group, ST_GroupUserRole_Group_Rel WHERE id = groupId AND groupUserRoleId = ?";
    private static final String SELECT_GROUPUSERROLE_GROUP = "SELECT " + GroupTable.aliasColumns("i", "id, specificId, domainId, superGroupId, name, description, synchroRule") + " FROM ST_Group i, ST_GroupUserRole us" + " WHERE i.id = us.groupId AND us.id = ?";
    private static final String SELECT_GROUPUSERROLE_GROUP_IDS = "SELECT id FROM ST_Group, ST_GroupUserRole_Group_Rel WHERE id = groupId AND groupUserRoleId = ?";
    private static final String SELECT_SEARCH_GROUPSID = "select DISTINCT ST_Group.id, UPPER(ST_Group.name) from ST_Group";
    private static final String SELECT_SEARCH_GROUPSID_IN_COMPONENT = "select DISTINCT ST_Group.id, UPPER(ST_Group.name) from ST_Group,ST_UserRole_Group_Rel,ST_UserRole";
    private static final String SELECT_SEARCH_GROUPSID_IN_ROLE = "select DISTINCT ST_Group.id, UPPER(ST_Group.name) from ST_Group,ST_UserRole_Group_Rel";
    private static final String SELECT_SEARCH_GROUPS = "SELECT id, specificId, domainId, superGroupId, name, description, synchroRule, UPPER(name) FROM ST_Group";
    private static final String INSERT_GROUP = "INSERT INTO ST_Group(id, specificId, domainId, superGroupId, name, description, synchroRule) VALUES (? ,? ,? ,? ,? ,? ,?)";
    private static final String UPDATE_GROUP = "update ST_Group set domainId = ?, specificId = ?, name = ?, description = ?, superGroupId = ?, synchroRule = ? where id = ?";
    private static final String DELETE_GROUP = "delete from ST_Group where id = ?";
    private static final String SELECT_COUNT_GROUP_USER_REL = "select count(*) from ST_Group_User_Rel where userId = ? and groupId = ?";
    private static final String INSERT_A_GROUP_USER_REL = "insert into ST_Group_User_Rel(groupId, userId) values(?,?)";
    private static final String DELETE_GROUP_USER_REL = "delete from ST_Group_User_Rel where groupId = ? and userId = ?";
    private OrganizationSchema organization = null;

    public GroupTable(OrganizationSchema schema) {
        super(schema, "ST_Group");
        this.organization = schema;
    }

    protected GroupRow fetchGroup(ResultSet rs) throws SQLException {
        GroupRow g = new GroupRow();
        g.id = rs.getInt("id");
        g.specificId = rs.getString("specificId");
        if ("-1".equals(g.specificId)) {
            g.specificId = null;
        }
        g.domainId = rs.getInt("domainId");
        g.superGroupId = rs.getInt("superGroupId");
        if (rs.wasNull()) {
            g.superGroupId = -1;
        }
        g.name = rs.getString("name");
        g.description = rs.getString("description");
        g.rule = rs.getString("synchroRule");
        return g;
    }

    public GroupRow getGroup(int id) throws AdminPersistenceException {
        return (GroupRow)this.getUniqueRow(SELECT_GROUP_BY_ID, id);
    }

    public GroupRow getGroupBySpecificId(int domainId, String specificId) throws AdminPersistenceException {
        ArrayList<Object> params = new ArrayList<Object>(2);
        params.add(domainId);
        params.add(specificId);
        List groups = this.getRows(SELECT_GROUP_BY_SPECIFICID, params);
        if (groups.isEmpty()) {
            return null;
        }
        if (groups.size() == 1) {
            return (GroupRow)groups.get(0);
        }
        throw new AdminPersistenceException("GroupTable.getGroupBySpecificId", 4, "admin.EX_ERR_GROUP_SPECIFIC_ID_FOUND_TWICE", "domain Id: '" + domainId + "', specific Id: '" + specificId + "'");
    }

    public GroupRow getRootGroup(String name) throws AdminPersistenceException {
        List groups = this.getRows(SELECT_ROOT_GROUP_BY_NAME, Collections.singletonList(name));
        if (groups.isEmpty()) {
            return null;
        }
        if (groups.size() == 1) {
            return (GroupRow)groups.get(0);
        }
        throw new AdminPersistenceException("GroupTable.getRootGroup", 4, "admin.EX_ERR_GROUP_NAME_FOUND_TWICE", "group name: '" + name + "'");
    }

    public GroupRow getGroup(int superGroupId, String name) throws AdminPersistenceException {
        ArrayList<Object> params = new ArrayList<Object>(2);
        params.add(superGroupId);
        params.add(name);
        List groups = this.getRows(SELECT_GROUP_BY_NAME, params);
        if (groups.isEmpty()) {
            return null;
        }
        if (groups.size() == 1) {
            return (GroupRow)groups.get(0);
        }
        throw new AdminPersistenceException("GroupTable.getGroup", 4, "admin.EX_ERR_GROUP_NAME_ID_FOUND_TWICE", "group name: '" + name + "', father group id: '" + superGroupId + "'");
    }

    public GroupRow[] getAllGroups() throws AdminPersistenceException {
        List<GroupRow> rows = this.getRows(SELECT_ALL_GROUPS);
        return rows.toArray(new GroupRow[rows.size()]);
    }

    public GroupRow[] getSynchronizedGroups() throws AdminPersistenceException {
        List<GroupRow> rows = this.getRows(SELECT_SYNCHRONIZED_GROUPS);
        return rows.toArray(new GroupRow[rows.size()]);
    }

    public String[] getAllGroupIds() throws AdminPersistenceException {
        List<String> ids = this.getIds(SELECT_ALL_GROUP_IDS);
        return ids.toArray(new String[ids.size()]);
    }

    public GroupRow[] getAllRootGroups() throws AdminPersistenceException {
        List<GroupRow> rows = this.getRows(SELECT_ALL_ROOT_GROUPS);
        return rows.toArray(new GroupRow[rows.size()]);
    }

    public String[] getAllRootGroupIds() throws AdminPersistenceException {
        List<String> ids = this.getIds(SELECT_ALL_ROOT_GROUP_IDS);
        return ids.toArray(new String[ids.size()]);
    }

    public GroupRow[] getDirectSubGroups(int superGroupId) throws AdminPersistenceException {
        List<GroupRow> rows = this.getRows(SELECT_SUBGROUPS, superGroupId);
        return rows.toArray(new GroupRow[rows.size()]);
    }

    public String[] getDirectSubGroupIds(int superGroupId) throws AdminPersistenceException {
        List<String> ids = this.getIds(SELECT_SUBGROUP_IDS, superGroupId);
        return ids.toArray(new String[ids.size()]);
    }

    public GroupRow[] getAllRootGroupsOfDomain(int domainId) throws AdminPersistenceException {
        List<GroupRow> rows = this.getRows(SELECT_ALL_ROOT_GROUPS_IN_DOMAIN, domainId);
        return rows.toArray(new GroupRow[rows.size()]);
    }

    public String[] getAllRootGroupIdsOfDomain(int domainId) throws AdminPersistenceException {
        List<String> ids = this.getIds(SELECT_ALL_ROOT_GROUPS_IDS_IN_DOMAIN, domainId);
        return ids.toArray(new String[ids.size()]);
    }

    public GroupRow[] getAllGroupsOfDomain(int domainId) throws AdminPersistenceException {
        SynchroReport.debug("GroupTable.getAllGroupsOfDomain()", "Recherche de l'ensemble des groupes du domaine LDAP dans la base (ID " + domainId + "), requ\u00eate : " + SELECT_ALL_GROUPS_IN_DOMAIN, null);
        List<GroupRow> rows = this.getRows(SELECT_ALL_GROUPS_IN_DOMAIN, domainId);
        return rows.toArray(new GroupRow[rows.size()]);
    }

    public GroupRow getSuperGroup(int subGroupId) throws AdminPersistenceException {
        return (GroupRow)this.getUniqueRow(SELECT_SUPERGROUP, subGroupId);
    }

    public GroupRow[] getDirectGroupsOfUser(int userId) throws AdminPersistenceException {
        List<GroupRow> rows = this.getRows(SELECT_USER_GROUPS, userId);
        return rows.toArray(new GroupRow[rows.size()]);
    }

    public String[] getDirectGroupIdsInUserRole(int userRoleId) throws AdminPersistenceException {
        List<String> ids = this.getIds(SELECT_USERROLE_GROUP_IDS, userRoleId);
        return ids.toArray(new String[ids.size()]);
    }

    public String[] getDirectGroupIdsInSpaceUserRole(int spaceUserRoleId) throws AdminPersistenceException {
        List<String> ids = this.getIds(SELECT_SPACEUSERROLE_GROUP_IDS, spaceUserRoleId);
        return ids.toArray(new String[ids.size()]);
    }

    public GroupRow[] getDirectGroupsInGroupUserRole(int groupUserRoleId) throws AdminPersistenceException {
        List<GroupRow> rows = this.getRows(SELECT_GROUPUSERROLE_GROUPS, groupUserRoleId);
        return rows.toArray(new GroupRow[rows.size()]);
    }

    public GroupRow getGroupOfGroupUserRole(int groupUserRoleId) throws AdminPersistenceException {
        return (GroupRow)this.getUniqueRow(SELECT_GROUPUSERROLE_GROUP, groupUserRoleId);
    }

    public String[] getDirectGroupIdsInGroupUserRole(int groupUserRoleId) throws AdminPersistenceException {
        List<String> ids = this.getIds(SELECT_GROUPUSERROLE_GROUP_IDS, groupUserRoleId);
        return ids.toArray(new String[ids.size()]);
    }

    public GroupRow[] getAllMatchingGroups(GroupRow sampleGroup) throws AdminPersistenceException {
        String[] columns = new String[]{"name", "description"};
        String[] values = new String[]{sampleGroup.name, sampleGroup.description};
        List<GroupRow> rows = this.getMatchingRows(GROUP_COLUMNS, columns, values);
        return rows.toArray(new GroupRow[rows.size()]);
    }

    public String[] searchGroupsIds(boolean isRootGroup, int componentId, int[] aRoleId, GroupRow groupModel) throws AdminPersistenceException {
        StringBuilder theQuery;
        boolean concatAndOr = false;
        String andOr = ") AND (";
        ArrayList<Object> params = new ArrayList<Object>();
        if (aRoleId != null && aRoleId.length > 0) {
            theQuery = new StringBuilder(SELECT_SEARCH_GROUPSID_IN_ROLE);
            theQuery.append(" WHERE ((ST_Group.id = ST_UserRole_Group_Rel.groupId) AND ");
            if (aRoleId.length > 1) {
                theQuery.append("(");
            }
            for (int i = 0; i < aRoleId.length; ++i) {
                params.add(aRoleId[i]);
                if (i > 0) {
                    theQuery.append(" OR ");
                }
                theQuery.append("(ST_UserRole_Group_Rel.userRoleId = ?)");
            }
            if (aRoleId.length > 1) {
                theQuery.append(")");
            }
            concatAndOr = true;
        } else if (componentId >= 0) {
            theQuery = new StringBuilder(SELECT_SEARCH_GROUPSID_IN_COMPONENT);
            params.add(componentId);
            theQuery.append(" WHERE ((ST_UserRole.id = ST_UserRole_Group_Rel.userRoleId) AND (");
            theQuery.append("ST_Group.id = ST_UserRole_Group_Rel.groupId) AND (ST_UserRole.instanceId = ?)");
            concatAndOr = true;
        } else {
            theQuery = new StringBuilder(SELECT_SEARCH_GROUPSID);
        }
        if (isRootGroup) {
            if (concatAndOr) {
                theQuery.append(andOr);
            } else {
                theQuery.append(" WHERE (");
                concatAndOr = true;
            }
            theQuery.append("ST_Group.superGroupId IS NULL");
        } else {
            concatAndOr = this.addIdToQuery(params, theQuery, groupModel.superGroupId, "ST_Group.superGroupId", concatAndOr, andOr);
        }
        concatAndOr = this.addIdToQuery(params, theQuery, groupModel.id, "ST_Group.id", concatAndOr, andOr);
        concatAndOr = this.addIdToQuery(params, theQuery, groupModel.domainId, "ST_Group.domainId", concatAndOr, andOr);
        concatAndOr = this.addParamToQuery(params, theQuery, groupModel.name, "ST_Group.name", concatAndOr, andOr);
        concatAndOr = this.addParamToQuery(params, theQuery, groupModel.description, "ST_Group.description", concatAndOr, andOr);
        concatAndOr = this.addParamToQuery(params, theQuery, groupModel.specificId, "ST_Group.specificId", concatAndOr, andOr);
        if (concatAndOr) {
            theQuery.append(")");
        }
        theQuery.append(" ORDER BY UPPER(ST_Group.name)");
        List<String> groupIds = this.getIds(theQuery.toString(), params);
        return groupIds.toArray(new String[groupIds.size()]);
    }

    public GroupRow[] searchGroups(GroupRow groupModel, boolean isAnd) throws AdminPersistenceException {
        boolean concatAndOr = false;
        StringBuilder theQuery = new StringBuilder(SELECT_SEARCH_GROUPS);
        ArrayList<Object> params = new ArrayList<Object>();
        String andOr = isAnd ? ") AND (" : ") OR (";
        concatAndOr = this.addIdToQuery(params, theQuery, groupModel.id, "id", concatAndOr, andOr);
        concatAndOr = this.addIdToQuery(params, theQuery, groupModel.domainId, "domainId", concatAndOr, andOr);
        concatAndOr = this.addIdToQuery(params, theQuery, groupModel.superGroupId, "superGroupId", concatAndOr, andOr);
        concatAndOr = this.addParamToQuery(params, theQuery, groupModel.name, "name", concatAndOr, andOr);
        concatAndOr = this.addParamToQuery(params, theQuery, groupModel.description, "description", concatAndOr, andOr);
        if (concatAndOr = this.addParamToQuery(params, theQuery, groupModel.specificId, "specificId", concatAndOr, andOr)) {
            theQuery.append(")");
        }
        theQuery.append(" order by UPPER(name)");
        List<GroupRow> groups = this.getRows(theQuery.toString(), params);
        return groups.toArray(new GroupRow[groups.size()]);
    }

    public void createGroup(GroupRow group) throws AdminPersistenceException {
        GroupRow superGroup;
        if (group.superGroupId != -1 && (superGroup = this.getGroup(group.superGroupId)) == null) {
            throw new AdminPersistenceException("GroupTable.createGroup", 4, "admin.EX_ERR_GROUP_NOT_FOUND", "father group id: '" + group.superGroupId + "'");
        }
        SynchroReport.debug("GroupTable.createGroup()", "Ajout de " + group.name + ", requ\u00eate : " + INSERT_GROUP, null);
        this.insertRow(INSERT_GROUP, group);
        CallBackManager callBackManager = CallBackManager.get();
        callBackManager.invoke(2, group.id, null, null);
    }

    @Override
    protected void prepareInsert(String insertQuery, PreparedStatement insert, GroupRow row) throws SQLException {
        if (row.id == -1) {
            row.id = this.getNextId();
        }
        insert.setInt(1, row.id);
        if (row.specificId == null) {
            row.specificId = String.valueOf(row.id);
        }
        insert.setString(2, GroupTable.truncate(row.specificId, 500));
        insert.setInt(3, row.domainId);
        if (row.superGroupId == -1) {
            insert.setNull(4, 4);
        } else {
            insert.setInt(4, row.superGroupId);
        }
        insert.setString(5, GroupTable.truncate(row.name, 100));
        insert.setString(6, GroupTable.truncate(row.description, 500));
        insert.setString(7, StringUtil.isDefined(row.rule) ? row.rule : null);
    }

    public void updateGroup(GroupRow group) throws AdminPersistenceException {
        SynchroReport.debug("GroupTable.updateGroup()", "Maj de " + group.name + ", Id=" + group.id + ", requ\u00eate : " + UPDATE_GROUP, null);
        this.updateRow(UPDATE_GROUP, group);
    }

    @Override
    protected void prepareUpdate(String updateQuery, PreparedStatement update, GroupRow row) throws SQLException {
        update.setInt(1, row.domainId);
        if (row.specificId == null) {
            row.specificId = String.valueOf(row.id);
        }
        update.setString(2, GroupTable.truncate(row.specificId, 500));
        update.setString(3, GroupTable.truncate(row.name, 100));
        update.setString(4, GroupTable.truncate(row.description, 500));
        if (row.superGroupId != -1) {
            update.setInt(5, row.superGroupId);
        } else {
            update.setNull(5, 4);
        }
        update.setString(6, StringUtil.isDefined(row.rule) ? row.rule : null);
        update.setInt(7, row.id);
    }

    public void removeGroup(int id) throws AdminPersistenceException {
        UserRow[] users;
        CallBackManager callBackManager = CallBackManager.get();
        callBackManager.invoke(3, id, null, null);
        GroupRow group = this.getGroup(id);
        if (group == null) {
            return;
        }
        SynchroReport.info("GroupTable.removeGroup()", "Suppression du groupe " + group.name + " dans la base...", null);
        UserRoleRow[] roles = this.organization.userRole.getDirectUserRolesOfGroup(id);
        SynchroReport.info("GroupTable.removeGroup()", "Suppression de " + group.name + " des r\u00f4les dans la base", null);
        for (UserRoleRow role : roles) {
            this.organization.userRole.removeGroupFromUserRole(id, role.id);
        }
        SpaceUserRoleRow[] spaceRoles = this.organization.spaceUserRole.getDirectSpaceUserRolesOfGroup(id);
        SynchroReport.info("GroupTable.removeGroup()", "Suppression de " + group.name + " comme manager d'espace dans la base", null);
        for (SpaceUserRoleRow spaceRole : spaceRoles) {
            this.organization.spaceUserRole.removeGroupFromSpaceUserRole(id, spaceRole.id);
        }
        GroupRow[] subGroups = this.getDirectSubGroups(id);
        if (subGroups.length > 0) {
            SynchroReport.info("GroupTable.removeGroup()", "Suppression des groupes fils de " + group.name + " dans la base", null);
        }
        for (GroupRow subGroup : subGroups) {
            this.removeGroup(subGroup.id);
        }
        for (UserRow user : users = this.organization.user.getDirectUsersOfGroup(id)) {
            this.removeUserFromGroup(user.id, id);
        }
        SynchroReport.info("GroupTable.removeGroup()", "Suppression de " + users.length + " utilisateurs inclus directement dans le groupe " + group.name + " dans la base", null);
        SynchroReport.debug("GroupTable.removeGroup()", "Suppression de " + group.name + " (ID=" + id + "), requ\u00eate : " + DELETE_GROUP, null);
        this.updateRelation(DELETE_GROUP, id);
    }

    private boolean isUserDirectlyInGroup(int userId, int groupId) throws AdminPersistenceException {
        int[] ids = new int[]{userId, groupId};
        Integer result = this.getInteger(SELECT_COUNT_GROUP_USER_REL, ids);
        return result != null && result >= 1;
    }

    public void addUserInGroup(int userId, int groupId) throws AdminPersistenceException {
        if (this.isUserDirectlyInGroup(userId, groupId)) {
            return;
        }
        UserRow user = this.organization.user.getUser(userId);
        if (user == null) {
            throw new AdminPersistenceException("GroupTable.addUserInGroup", 4, "admin.EX_ERR_USER_NOT_FOUND", "user id: '" + userId + "'");
        }
        GroupRow group = this.getGroup(groupId);
        if (group == null) {
            throw new AdminPersistenceException("GroupTable.addUserInGroup", 4, "admin.EX_ERR_GROUP_NOT_FOUND", "group id: '" + groupId + "'");
        }
        int[] params = new int[]{groupId, userId};
        SynchroReport.debug("GroupTable.addUserInGroup()", "Ajout de l'utilisateur d'ID " + userId + " dans le groupe d'ID " + groupId + ", requ\u00eate : " + INSERT_A_GROUP_USER_REL, null);
        this.updateRelation(INSERT_A_GROUP_USER_REL, params);
        GroupCache.removeCacheOfUser(Integer.toString(userId));
    }

    public void addUsersInGroup(String[] userIds, int groupId, boolean checkRelation) throws AdminPersistenceException {
        SilverTrace.info("admin", "GroupTable.addUsersInGroup", "root.MSG_GEN_ENTER_METHOD", "groupId = " + groupId + ", userIds = " + Arrays.toString(userIds));
        GroupRow group = this.getGroup(groupId);
        if (group == null) {
            throw new AdminPersistenceException("GroupTable.addUsersInGroup", 4, "admin.EX_ERR_GROUP_NOT_FOUND", "group id: '" + groupId + "'");
        }
        for (String userId1 : userIds) {
            int userId = Integer.parseInt(userId1);
            boolean userInGroup = false;
            if (checkRelation) {
                userInGroup = this.isUserDirectlyInGroup(userId, groupId);
            }
            if (userInGroup) continue;
            UserRow user = this.organization.user.getUser(userId);
            if (user == null) {
                throw new AdminPersistenceException("GroupTable.addUsersInGroup", 4, "admin.EX_ERR_USER_NOT_FOUND", "user id: '" + userId + "'");
            }
            int[] params = new int[]{groupId, userId};
            SynchroGroupReport.debug("GroupTable.addUsersInGroup()", "Ajout de l'utilisateur d'ID " + userId + " dans le groupe d'ID " + groupId + ", requ\u00eate : " + INSERT_A_GROUP_USER_REL, null);
            this.updateRelation(INSERT_A_GROUP_USER_REL, params);
            GroupCache.removeCacheOfUser(Integer.toString(userId));
        }
    }

    public void removeUserFromGroup(int userId, int groupId) throws AdminPersistenceException {
        if (!this.isUserDirectlyInGroup(userId, groupId)) {
            throw new AdminPersistenceException("GroupTable.removeUserFromGroup", 4, "admin.EX_ERR_USER_NOT_IN_GROUP", "group id: '" + groupId + "', user id: '" + userId + "'");
        }
        int[] params = new int[]{groupId, userId};
        SynchroReport.debug("GroupTable.removeUserFromGroup()", "Retrait de l'utilisateur d'ID " + userId + " du groupe d'ID " + groupId + ", requ\u00eate : " + DELETE_GROUP_USER_REL, null);
        this.updateRelation(DELETE_GROUP_USER_REL, params);
        GroupCache.removeCacheOfUser(Integer.toString(userId));
    }

    public void removeUsersFromGroup(String[] userIds, int groupId, boolean checkRelation) throws AdminPersistenceException {
        SilverTrace.info("admin", "GroupTable.removeUsersFromGroup", "root.MSG_GEN_ENTER_METHOD", "groupId = " + groupId + ", userIds = " + Arrays.toString(userIds));
        GroupRow group = this.getGroup(groupId);
        if (group == null) {
            throw new AdminPersistenceException("GroupTable.removeUsersFromGroup()", 4, "admin.EX_ERR_GROUP_NOT_FOUND", "group id: '" + groupId + "'");
        }
        for (String userId1 : userIds) {
            int userId = Integer.parseInt(userId1);
            boolean userInGroup = true;
            if (checkRelation) {
                userInGroup = this.isUserDirectlyInGroup(userId, groupId);
            }
            if (!userInGroup) {
                throw new AdminPersistenceException("GroupTable.removeUsersFromGroup()", 4, "admin.EX_ERR_USER_NOT_IN_GROUP", "group id: '" + groupId + "', user id: '" + userId + "'");
            }
            int[] params = new int[]{groupId, userId};
            SynchroGroupReport.debug("GroupTable.removeUsersFromGroup()", "Retrait de l'utilisateur d'ID " + userId + " du groupe d'ID " + groupId + ", requ\u00eate : " + DELETE_GROUP_USER_REL, null);
            this.updateRelation(DELETE_GROUP_USER_REL, params);
            GroupCache.removeCacheOfUser(Integer.toString(userId));
        }
    }

    @Override
    protected GroupRow fetchRow(ResultSet rs) throws SQLException {
        return this.fetchGroup(rs);
    }
}

