/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.organization;

import com.silverpeas.scheduler.Scheduler;
import com.silverpeas.scheduler.SchedulerEvent;
import com.silverpeas.scheduler.SchedulerEventListener;
import com.silverpeas.scheduler.SchedulerFactory;
import com.silverpeas.scheduler.trigger.JobTrigger;
import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.AdminController;

public class ScheduledDBReset
implements SchedulerEventListener {
    private static final String DBRESET_JOB_NAME = "ScheduledDBReset";
    private AdminController adminController = null;

    public void initialize(String cronString) {
        try {
            SchedulerFactory schedulerFactory = SchedulerFactory.getFactory();
            Scheduler scheduler = schedulerFactory.getScheduler();
            scheduler.unscheduleJob(DBRESET_JOB_NAME);
            if (StringUtil.isDefined(cronString)) {
                JobTrigger trigger = JobTrigger.triggerAt(cronString);
                scheduler.scheduleJob(DBRESET_JOB_NAME, trigger, (SchedulerEventListener)this);
            }
        }
        catch (Exception e) {
            SilverTrace.error("admin", "ScheduledDBReset.initialize", "admin.EX_ERR_INITIALIZE", e);
        }
    }

    public void doDBReset() {
        if (this.adminController == null) {
            this.adminController = new AdminController(null);
        }
        try {
            this.adminController.resetAllDBConnections(true);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "ScheduledDBReset.doDBReset", "admin.EX_ERR_TIMEOUT_MANAGEMENT", e);
        }
    }

    @Override
    public void triggerFired(SchedulerEvent anEvent) {
        SilverTrace.debug("admin", "ScheduledDBReset.handleSchedulerEvent", "The job '" + anEvent.getJobExecutionContext().getJobName() + "' is executed");
        this.doDBReset();
    }

    @Override
    public void jobSucceeded(SchedulerEvent anEvent) {
        SilverTrace.debug("admin", "ScheduledDBReset.handleSchedulerEvent", "The job '" + anEvent.getJobExecutionContext().getJobName() + "' was successfull");
    }

    @Override
    public void jobFailed(SchedulerEvent anEvent) {
        SilverTrace.error("admin", "ScheduledDBReset.handleSchedulerEvent", "The job '" + anEvent.getJobExecutionContext().getJobName() + "' was not successfull");
    }
}

