/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.organization;

import com.stratelia.webactiv.organization.AdminPersistenceException;
import com.stratelia.webactiv.organization.OrganizationSchema;
import com.stratelia.webactiv.organization.SpaceI18NRow;
import com.stratelia.webactiv.organization.Table;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class SpaceI18NTable
extends Table<SpaceI18NRow> {
    private static final String COLUMNS = "id,spaceId,lang,name,description";
    private static final String SELECT_TRANSLATIONS = "select id,spaceId,lang,name,description from ST_SpaceI18N where spaceId = ?";
    private static final String INSERT_TRANSLATION = "insert into ST_SpaceI18N(id,spaceId,lang,name,description) values  (?, ?, ?, ?, ?)";
    private static final String UPDATE_TRANSLATION = "update ST_SpaceI18N set name = ?, description = ?  WHERE id = ? ";
    private static final String DELETE_TRANSLATION = "delete from ST_SpaceI18N where id = ?";
    private static final String DELETE_TRANSLATIONS = "delete from ST_SpaceI18N where spaceId = ?";

    public SpaceI18NTable(OrganizationSchema organization) {
        super(organization, "ST_SpaceI18N");
    }

    protected SpaceI18NRow fetchTranslation(ResultSet rs) throws SQLException {
        SpaceI18NRow s = new SpaceI18NRow();
        s.id = rs.getInt(1);
        s.spaceId = rs.getInt(2);
        s.lang = rs.getString(3);
        s.name = rs.getString(4);
        s.description = rs.getString(5);
        return s;
    }

    public List<SpaceI18NRow> getTranslations(int spaceId) throws AdminPersistenceException {
        return this.getRows(SELECT_TRANSLATIONS, spaceId);
    }

    public void createTranslation(SpaceI18NRow translation) throws AdminPersistenceException {
        this.insertRow(INSERT_TRANSLATION, translation);
    }

    @Override
    protected void prepareInsert(String insertQuery, PreparedStatement insert, SpaceI18NRow row) throws SQLException {
        row.id = this.getNextId();
        insert.setInt(1, row.id);
        insert.setInt(2, row.spaceId);
        insert.setString(3, row.lang);
        insert.setString(4, SpaceI18NTable.truncate(row.name, 100));
        insert.setString(5, SpaceI18NTable.truncate(row.description, 500));
    }

    public void updateTranslation(SpaceI18NRow space) throws AdminPersistenceException {
        this.updateRow(UPDATE_TRANSLATION, space);
    }

    @Override
    protected void prepareUpdate(String updateQuery, PreparedStatement update, SpaceI18NRow row) throws SQLException {
        update.setString(1, SpaceI18NTable.truncate(row.name, 100));
        update.setString(2, SpaceI18NTable.truncate(row.description, 500));
        update.setInt(3, row.id);
    }

    public void removeTranslation(int id) throws AdminPersistenceException {
        this.updateRelation(DELETE_TRANSLATION, id);
    }

    public void removeTranslations(int spaceId) throws AdminPersistenceException {
        this.updateRelation(DELETE_TRANSLATIONS, spaceId);
    }

    @Override
    protected SpaceI18NRow fetchRow(ResultSet rs) throws SQLException {
        return this.fetchTranslation(rs);
    }
}

