/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.organization;

import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.organization.UserFavoriteSpaceBean;
import com.stratelia.webactiv.organization.UserFavoriteSpaceDAO;
import com.stratelia.webactiv.organization.UserFavoriteSpaceVO;
import com.stratelia.webactiv.persistence.IdPK;
import com.stratelia.webactiv.persistence.PersistenceException;
import com.stratelia.webactiv.persistence.SilverpeasBeanDAO;
import com.stratelia.webactiv.persistence.SilverpeasBeanDAOFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UserFavoriteSpaceDAOImpl
implements UserFavoriteSpaceDAO {
    @Override
    public List<UserFavoriteSpaceVO> getListUserFavoriteSpace(String userId) {
        ArrayList<UserFavoriteSpaceVO> listUserFavoriteSpaces = new ArrayList<UserFavoriteSpaceVO>();
        IdPK pk = new IdPK();
        Collection beansUserFavoriteSpaces = null;
        String whereClause = " userid = " + userId;
        try {
            SilverpeasBeanDAO dao = SilverpeasBeanDAOFactory.getDAO("com.stratelia.webactiv.organization.UserFavoriteSpaceBean");
            beansUserFavoriteSpaces = dao.findByWhereClause(pk, whereClause);
            if (!beansUserFavoriteSpaces.isEmpty()) {
                for (UserFavoriteSpaceBean userFavoriteSpaceBean : beansUserFavoriteSpaces) {
                    listUserFavoriteSpaces.add(new UserFavoriteSpaceVO(userFavoriteSpaceBean.getUserId(), userFavoriteSpaceBean.getSpaceId()));
                }
            }
        }
        catch (PersistenceException e) {
            SilverTrace.error("server", "UserFavoriteSpaceDAO.getListUserFavoriteSpace()", "server.EX_CANT_GET_FAVORITE_SPACES", "userid=" + userId, e);
        }
        return listUserFavoriteSpaces;
    }

    @Override
    public boolean addUserFavoriteSpace(UserFavoriteSpaceVO ufsVO) {
        boolean result = false;
        try {
            if (this.isUserFavoriteSpaceAlreadyExist(ufsVO.getUserId(), ufsVO.getSpaceId())) {
                result = true;
            } else {
                SilverpeasBeanDAO<UserFavoriteSpaceBean> dao = SilverpeasBeanDAOFactory.getDAO("com.stratelia.webactiv.organization.UserFavoriteSpaceBean");
                dao.add(new UserFavoriteSpaceBean(ufsVO.getUserId(), ufsVO.getSpaceId()));
                result = true;
            }
        }
        catch (PersistenceException e) {
            SilverTrace.error("server", "UserFavoriteSpaceDAO.addUserFavoriteSpace", "", "userid= " + ufsVO.getUserId() + ", spaceid=" + ufsVO.getSpaceId(), e);
        }
        return result;
    }

    private boolean isUserFavoriteSpaceAlreadyExist(int userId, int spaceId) {
        boolean exist = false;
        IdPK pk = new IdPK();
        Collection beansUserFavoriteSpaces = null;
        String whereClause = " userid = " + userId + " AND spaceId = " + spaceId;
        try {
            SilverpeasBeanDAO dao = SilverpeasBeanDAOFactory.getDAO("com.stratelia.webactiv.organization.UserFavoriteSpaceBean");
            beansUserFavoriteSpaces = dao.findByWhereClause(pk, whereClause);
            if (!beansUserFavoriteSpaces.isEmpty()) {
                exist = true;
            }
        }
        catch (PersistenceException e) {
            SilverTrace.error("server", "UserFavoriteSpaceDAO.getListUserFavoriteSpace()", "server.EX_CANT_GET_FAVORITE_SPACES", "userid=" + userId, e);
        }
        return exist;
    }

    @Override
    public boolean removeUserFavoriteSpace(UserFavoriteSpaceVO ufsVO) {
        boolean result = false;
        StringBuffer whereBuff = new StringBuffer();
        int removedUserId = ufsVO.getUserId();
        int removedSpaceId = ufsVO.getSpaceId();
        if (removedUserId == -1 && removedSpaceId == -1) {
            return true;
        }
        boolean firstCondition = false;
        if (removedUserId != -1) {
            whereBuff.append(" userid=").append(removedUserId);
            firstCondition = true;
        }
        if (removedSpaceId != -1) {
            if (firstCondition) {
                whereBuff.append(" AND");
            }
            whereBuff.append(" spaceid=").append(removedSpaceId);
        }
        try {
            SilverpeasBeanDAO dao = SilverpeasBeanDAOFactory.getDAO("com.stratelia.webactiv.organization.UserFavoriteSpaceBean");
            dao.removeWhere(new IdPK(), whereBuff.toString());
            result = true;
        }
        catch (PersistenceException e) {
            SilverTrace.error("server", "UserFavoriteSpaceDAO.addUserFavoriteSpace", "", "userid= " + ufsVO.getUserId() + ", spaceid=" + ufsVO.getSpaceId(), e);
        }
        return result;
    }
}

