/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.persistence;

import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.persistence.JdbcData;
import com.stratelia.webactiv.persistence.PersistenceException;
import com.stratelia.webactiv.persistence.SilverpeasBean;
import com.stratelia.webactiv.persistence.SilverpeasBeanDAO;
import com.stratelia.webactiv.persistence.SilverpeasBeanIntf;
import com.stratelia.webactiv.util.DBUtil;
import com.stratelia.webactiv.util.DateUtil;
import com.stratelia.webactiv.util.JNDINames;
import com.stratelia.webactiv.util.WAPrimaryKey;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.constant.Constable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;

public class SilverpeasBeanDAOImpl<T extends SilverpeasBeanIntf>
implements SilverpeasBeanDAO<T> {
    private final PropertyDescriptor[] properties;
    private Class<T> silverpeasBeanClass;
    private int connectionType = 1;
    private String datasourceName = null;
    private JdbcData jdbcConnectionParameters = null;
    private String tableName = null;

    public SilverpeasBeanDAOImpl(String beanClassName) throws PersistenceException {
        try {
            this.silverpeasBeanClass = Class.forName(beanClassName);
            SilverpeasBeanIntf object = (SilverpeasBeanIntf)this.silverpeasBeanClass.newInstance();
            if (!(object instanceof SilverpeasBean)) {
                throw new PersistenceException("SilverpeasBeanDAOImpl.SilverpeasBeanDAOImpl( String beanClassName )", 4, "persistence.EX_ISNOT_SILVERPEASBEAN", "classe= " + beanClassName, null);
            }
            BeanInfo infos = Introspector.getBeanInfo(this.silverpeasBeanClass);
            for (PropertyDescriptor property : this.properties = infos.getPropertyDescriptors()) {
                String type = property.getPropertyType().getName();
                SilverTrace.debug("persistence", "SilverpeasBeanDAOImpl.SilverpeasBeanDAOImpl( String beanClassName )", "root.MSG_GEN_PARAM_VALUE", "new(" + beanClassName + "), property Name = " + property.getName() + ", type = " + type);
                if (this.isTypeValid(type)) continue;
                SilverTrace.warn("persistence", "SilverpeasBeanDAOImpl.SilverpeasBeanDAOImpl( String beanClassName )", "persistence.MSG_WARN_PROPERTIE_NOT_MANAGED", "");
            }
            this.connectionType = object._getConnectionType();
            switch (this.connectionType) {
                case 2: {
                    this.datasourceName = object._getDatasourceName();
                    break;
                }
                case 3: {
                    this.jdbcConnectionParameters = object._getJdbcData();
                }
            }
            this.tableName = object._getTableName();
        }
        catch (IntrospectionException ex) {
            throw new PersistenceException("SilverpeasBeanDAOImpl.SilverpeasBeanDAOImpl(String beanClassName)", 4, "persistence.EX_CANT_INITIALISE_CLASS", "classe= " + beanClassName, ex);
        }
        catch (ClassNotFoundException ex) {
            throw new PersistenceException("SilverpeasBeanDAOImpl.SilverpeasBeanDAOImpl(String beanClassName)", 4, "persistence.EX_CANT_INITIALISE_CLASS", "classe= " + beanClassName, ex);
        }
        catch (InstantiationException ex) {
            throw new PersistenceException("SilverpeasBeanDAOImpl.SilverpeasBeanDAOImpl(String beanClassName)", 4, "persistence.EX_CANT_INITIALISE_CLASS", "classe= " + beanClassName, ex);
        }
        catch (IllegalAccessException ex) {
            throw new PersistenceException("SilverpeasBeanDAOImpl.SilverpeasBeanDAOImpl(String beanClassName)", 4, "persistence.EX_CANT_INITIALISE_CLASS", "classe= " + beanClassName, ex);
        }
    }

    @Override
    public void remove(WAPrimaryKey pk) throws PersistenceException {
        this.remove(null, pk);
    }

    @Override
    public void remove(Connection connection, WAPrimaryKey pk) throws PersistenceException {
        Connection con = connection == null ? this.getConnection() : connection;
        PreparedStatement prepStmt = null;
        try {
            String updateStatement = "delete from " + this.getTableName(pk) + " where id = ?";
            prepStmt = con.prepareStatement(updateStatement);
            SilverTrace.debug("persistence", "SilverpeasBeanDAOImpl.remove(WAPrimaryKey pk)", "root.MSG_GEN_PARAM_VALUE", "queryStr = " + updateStatement + ", id= " + pk.getId());
            prepStmt.setInt(1, Integer.parseInt(pk.getId()));
            prepStmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException("SilverpeasBeanDAOImpl.remove(WAPrimaryKey pk)", 4, "persistence.EX_CANT_REMOVE_OBJECT", "", e);
            }
            catch (Throwable throwable) {
                DBUtil.close(prepStmt);
                if (connection == null) {
                    DBUtil.close(con);
                }
                throw throwable;
            }
        }
        DBUtil.close(prepStmt);
        if (connection == null) {
            DBUtil.close(con);
        }
    }

    @Override
    public void removeWhere(WAPrimaryKey pk, String whereClause) throws PersistenceException {
        this.removeWhere(null, pk, whereClause);
    }

    @Override
    public void removeWhere(Connection connection, WAPrimaryKey pk, String whereClause) throws PersistenceException {
        Connection con = connection == null ? this.getConnection() : connection;
        PreparedStatement prepStmt = null;
        try {
            String updateStatement = "delete from " + this.getTableName(pk) + " where " + whereClause;
            prepStmt = con.prepareStatement(updateStatement);
            SilverTrace.debug("persistence", "SilverpeasBeanDAOImpl.removeWhere(WAPrimaryKey pk, String p_WhereClause)", "root.MSG_GEN_PARAM_VALUE", "queryStr = " + updateStatement + ", id= " + pk.getId() + ", whereClause= " + whereClause);
            prepStmt.executeUpdate();
        }
        catch (Exception e) {
            try {
                throw new PersistenceException("SilverpeasBeanDAOImpl.removeWhere(WAPrimaryKey pk, String p_WhereClause)", 4, "persistence.EX_CANT_REMOVE_OBJECT", "", e);
            }
            catch (Throwable throwable) {
                DBUtil.close(prepStmt);
                if (connection == null) {
                    DBUtil.close(con);
                }
                throw throwable;
            }
        }
        DBUtil.close(prepStmt);
        if (connection == null) {
            DBUtil.close(con);
        }
    }

    @Override
    public void update(T bean) throws PersistenceException {
        this.update(null, bean);
    }

    @Override
    public void update(Connection connection, T bean) throws PersistenceException {
        Connection con = connection == null ? this.getConnection() : connection;
        PreparedStatement prepStmt = null;
        try {
            String statement = null;
            for (PropertyDescriptor property : this.properties) {
                String type = property.getPropertyType().getName();
                SilverTrace.debug("persistence", "SilverpeasBeanDAOImpl.update(SilverpeasBean bean)", "root.MSG_GEN_PARAM_VALUE", "property Name = " + property.getName() + ", type = " + type);
                if (!this.isTypeValid(type)) continue;
                statement = statement == null ? property.getName() + " = ? " : statement + ", " + property.getName() + " = ? ";
            }
            String updateStatement = "UPDATE " + this.getTableName(bean.getPK()) + " SET " + statement + " WHERE id = ?";
            prepStmt = con.prepareStatement(updateStatement);
            SilverTrace.debug("persistence", "SilverpeasBeanDAOImpl.update(SilverpeasBean bean)", "root.MSG_GEN_PARAM_VALUE", "queryStr = " + updateStatement + ", id= " + bean.getPK().getId());
            int count = this.prepareStatementSetProperties(prepStmt, bean);
            prepStmt.setInt(count, Integer.parseInt(bean.getPK().getId()));
            prepStmt.executeUpdate();
        }
        catch (Exception e) {
            try {
                throw new PersistenceException("SilverpeasBeanDAOImpl.update(SilverpeasBean bean) ", 4, "persistence.EX_CANT_UPDATE_OBJECT", "", e);
            }
            catch (Throwable throwable) {
                DBUtil.close(prepStmt);
                if (connection == null) {
                    DBUtil.close(con);
                }
                throw throwable;
            }
        }
        DBUtil.close(prepStmt);
        if (connection == null) {
            DBUtil.close(con);
        }
    }

    @Override
    public WAPrimaryKey add(T bean) throws PersistenceException {
        return this.add(null, bean);
    }

    @Override
    public WAPrimaryKey add(Connection connection, T bean) throws PersistenceException {
        WAPrimaryKey wAPrimaryKey;
        Connection con = connection == null ? this.getConnection() : connection;
        PreparedStatement prepStmt = null;
        try {
            String columns = null;
            String statement = null;
            for (PropertyDescriptor property : this.properties) {
                String type = property.getPropertyType().getName();
                SilverTrace.debug("persistence", "SilverpeasBeanDAOImpl.add(SilverpeasBean bean)", "root.MSG_GEN_PARAM_VALUE", "property Name = " + property.getName() + ", type = " + type);
                if (!this.isTypeValid(type)) continue;
                if (columns == null) {
                    columns = property.getName();
                    statement = " ? ";
                    continue;
                }
                columns = columns + ", " + property.getName();
                statement = statement + ", ? ";
            }
            columns = columns + ", id";
            statement = statement + ", ? ";
            String insertStatement = "INSERT INTO " + this.getTableName(bean.getPK()) + " (" + columns + ") " + " values (" + statement + ")";
            prepStmt = con.prepareStatement(insertStatement);
            SilverTrace.debug("persistence", "SilverpeasBeanDAOImpl.add(SilverpeasBean bean)", "root.MSG_GEN_PARAM_VALUE", "queryStr = " + insertStatement + ", id= " + bean.getPK().getId());
            int count = this.prepareStatementSetProperties(prepStmt, bean);
            int id = DBUtil.getNextId(this.getTableName(bean.getPK()), "id");
            prepStmt.setInt(count, id);
            prepStmt.executeUpdate();
            bean.getPK().setId(id + "");
            wAPrimaryKey = bean.getPK();
        }
        catch (Exception e) {
            try {
                throw new PersistenceException("SilverpeasBeanDAOImpl.add(SilverpeasBean bean)", 4, "persistence.EX_CANT_ADD_OBJECT", "", e);
            }
            catch (Throwable throwable) {
                DBUtil.close(prepStmt);
                if (connection == null) {
                    DBUtil.close(con);
                }
                throw throwable;
            }
        }
        DBUtil.close(prepStmt);
        if (connection == null) {
            DBUtil.close(con);
        }
        return wAPrimaryKey;
    }

    @Override
    public T findByPrimaryKey(WAPrimaryKey pk) throws PersistenceException {
        return this.findByPrimaryKey(null, pk);
    }

    @Override
    public T findByPrimaryKey(Connection connection, WAPrimaryKey pk) throws PersistenceException {
        T t;
        ResultSet rs;
        Connection con;
        PreparedStatement prepStmt;
        block8: {
            prepStmt = null;
            con = connection == null ? this.getConnection() : connection;
            rs = null;
            String selectStatement = "SELECT  " + this.getColumnNames() + " FROM " + this.getTableName(pk) + " WHERE id = ?";
            SilverTrace.debug("persistence", "SilverpeasBeanDAOImpl.findByPrimaryKey(WAPrimaryKey pk)", "root.MSG_GEN_PARAM_VALUE", "queryStr = " + selectStatement + ", id= " + pk.getId());
            prepStmt = con.prepareStatement(selectStatement);
            prepStmt.setInt(1, Integer.parseInt(pk.getId()));
            rs = prepStmt.executeQuery();
            if (!rs.next()) break block8;
            T t2 = this.getSilverpeasBeanFromResultSet(pk, rs);
            DBUtil.close(rs, prepStmt);
            if (connection == null) {
                DBUtil.close(con);
            }
            return t2;
        }
        try {
            t = null;
        }
        catch (Exception e) {
            try {
                throw new PersistenceException("SilverpeasBeanDAOImpl.findByPrimaryKey(WAPrimaryKey pk)", 4, "persistence.EX_CANT_FIND_OBJECT", "", e);
            }
            catch (Throwable throwable) {
                DBUtil.close(rs, prepStmt);
                if (connection == null) {
                    DBUtil.close(con);
                }
                throw throwable;
            }
        }
        DBUtil.close(rs, prepStmt);
        if (connection == null) {
            DBUtil.close(con);
        }
        return t;
    }

    @Override
    public Collection<T> findByWhereClause(WAPrimaryKey pk, String whereClause) throws PersistenceException {
        return this.findByWhereClause(null, pk, whereClause);
    }

    @Override
    public Collection<T> findByWhereClause(Connection connection, WAPrimaryKey pk, String whereClause) throws PersistenceException {
        ArrayList<T> arrayList;
        PreparedStatement prepStmt = null;
        Connection con = connection == null ? this.getConnection() : connection;
        ResultSet rs = null;
        try {
            String selectStatement = "SELECT DISTINCT " + this.getColumnNames() + " FROM " + this.getTableName(pk);
            if (whereClause != null) {
                selectStatement = selectStatement + " WHERE " + whereClause;
            }
            SilverTrace.debug("persistence", "SilverpeasBeanDAOImpl.findByWhereClause(WAPrimaryKey pk, String whereClause)", "root.MSG_GEN_PARAM_VALUE", "queryStr = " + selectStatement + ", id= " + pk.getId() + ", whereClause= " + whereClause);
            prepStmt = con.prepareStatement(selectStatement);
            rs = prepStmt.executeQuery();
            ArrayList<T> list = new ArrayList<T>();
            while (rs.next()) {
                T bean = this.getSilverpeasBeanFromResultSet(pk, rs);
                list.add(bean);
            }
            arrayList = list;
        }
        catch (Exception e) {
            try {
                throw new PersistenceException("SilverpeasBeanDAOImpl.findByWhereClause(WAPrimaryKey pk, String whereClause)", 4, "persistence.EX_CANT_FIND_OBJECT", "", e);
            }
            catch (Throwable throwable) {
                DBUtil.close(rs, prepStmt);
                if (connection == null) {
                    DBUtil.close(con);
                }
                throw throwable;
            }
        }
        DBUtil.close(rs, prepStmt);
        if (connection == null) {
            DBUtil.close(con);
        }
        return arrayList;
    }

    private Connection getConnection() throws PersistenceException {
        try {
            Connection con = null;
            switch (this.connectionType) {
                case 2: {
                    con = DBUtil.makeConnection(this.datasourceName);
                    break;
                }
                case 3: {
                    Class.forName(this.jdbcConnectionParameters.JDBCdriverName);
                    con = DriverManager.getConnection(this.jdbcConnectionParameters.JDBCurl, this.jdbcConnectionParameters.JDBClogin, this.jdbcConnectionParameters.JDBCpassword);
                    break;
                }
                case 1: {
                    con = DBUtil.makeConnection(JNDINames.PERSISTENCE_DB_DATASOURCE);
                    break;
                }
                default: {
                    con = DBUtil.makeConnection(JNDINames.PERSISTENCE_EJB_DATASOURCE);
                }
            }
            return con;
        }
        catch (Exception e) {
            throw new PersistenceException("SilverpeasBeanDAOImpl.getConnection()", 4, "root.EX_CONNECTION_OPEN_FAILED", "", e);
        }
    }

    private String getColumnNames() throws Exception {
        String statement = null;
        for (PropertyDescriptor property : this.properties) {
            String type = property.getPropertyType().getName();
            SilverTrace.debug("persistence", "SilverpeasBeanDAOImpl.getColumnNames()", "root.MSG_GEN_PARAM_VALUE", "property Name = " + property.getName() + ", type = " + type);
            if (!this.isTypeValid(type)) continue;
            statement = statement == null ? property.getName() : statement + ", " + property.getName();
        }
        statement = statement + ", id";
        return statement;
    }

    private T getSilverpeasBeanFromResultSet(WAPrimaryKey pk, ResultSet rs) throws Exception {
        SilverpeasBeanIntf bean = (SilverpeasBeanIntf)this.silverpeasBeanClass.newInstance();
        int count = 1;
        for (PropertyDescriptor property : this.properties) {
            Object[] parameters;
            Object[] parameters2;
            String type = property.getPropertyType().getName();
            if (this.isInteger(type)) {
                int value = rs.getInt(count);
                if (!rs.wasNull()) {
                    parameters2 = new Integer[]{value};
                    property.getWriteMethod().invoke((Object)bean, parameters2);
                }
                ++count;
                continue;
            }
            if (this.isLong(type)) {
                long value = rs.getLong(count);
                if (!rs.wasNull()) {
                    parameters = new Long[]{value};
                    property.getWriteMethod().invoke((Object)bean, parameters);
                }
                ++count;
                continue;
            }
            if (this.isBoolean(type)) {
                boolean value = rs.getBoolean(count);
                if (!rs.wasNull()) {
                    parameters2 = new Boolean[]{value};
                    property.getWriteMethod().invoke((Object)bean, parameters2);
                }
                ++count;
                continue;
            }
            if (this.isString(type)) {
                String value = rs.getString(count);
                if (value != null) {
                    parameters2 = new String[]{value};
                    property.getWriteMethod().invoke((Object)bean, parameters2);
                }
                ++count;
                continue;
            }
            if (this.isDate(type)) {
                String value = rs.getString(count);
                if (value != null) {
                    parameters2 = new Date[1];
                    try {
                        parameters2[0] = DateUtil.parse(value);
                    }
                    catch (Exception e) {
                        SilverTrace.error("persistence", "SilverpeasBeanDAOImpl.getSilverpeasBeanFromResultSet(WAPrimaryKey pk, ResultSet rs)", "root.EX_CANT_PARSE_DATE", "property Name = " + property.getName() + ", date= " + value);
                        throw e;
                    }
                    property.getWriteMethod().invoke((Object)bean, parameters2);
                }
                ++count;
                continue;
            }
            if (this.isFloat(type)) {
                float value = rs.getFloat(count);
                if (!rs.wasNull()) {
                    parameters2 = new Float[]{Float.valueOf(value)};
                    property.getWriteMethod().invoke((Object)bean, parameters2);
                }
                ++count;
                continue;
            }
            if (!type.equals("double") && !type.equals("java.lang.Double")) continue;
            double value = rs.getDouble(count);
            if (!rs.wasNull()) {
                parameters = new Double[]{value};
                property.getWriteMethod().invoke((Object)bean, parameters);
            }
            ++count;
        }
        Class<?> pkClass = pk.getClass();
        String id = rs.getInt(count) + "";
        Class[] types = new Class[]{String.class, WAPrimaryKey.class};
        Constructor<?> construct = pkClass.getConstructor(types);
        Object[] parameters = new Object[]{id, pk};
        WAPrimaryKey maPk = (WAPrimaryKey)construct.newInstance(parameters);
        bean.setPK(maPk);
        return (T)bean;
    }

    private boolean isInteger(String type) {
        return "int".equals(type) || "java.lang.Integer".equals(type);
    }

    private boolean isLong(String type) {
        return "long".equals(type) || "java.lang.Long".equals(type);
    }

    private boolean isBoolean(String type) {
        return "boolean".equals(type) || "java.lang.Boolean".equals(type);
    }

    private boolean isString(String type) {
        return "java.lang.String".equals(type);
    }

    private boolean isDate(String type) {
        return "java.util.Date".equals(type);
    }

    private boolean isDouble(String type) {
        return "double".equals(type) || "java.lang.Double".equals(type);
    }

    private boolean isFloat(String type) {
        return "float".equals(type) || "java.lang.Float".equals(type);
    }

    private String getTableName(WAPrimaryKey pk) {
        String result = "";
        result = this.tableName != null ? this.tableName : pk.getTableName();
        return result;
    }

    private boolean isTypeValid(String javaTypeName) {
        return this.isInteger(javaTypeName) || this.isLong(javaTypeName) || this.isString(javaTypeName) || this.isDate(javaTypeName) || this.isFloat(javaTypeName) || this.isDouble(javaTypeName) || this.isBoolean(javaTypeName);
    }

    private int prepareStatementSetProperties(PreparedStatement prepStmt, T bean) throws IllegalAccessException, SQLException, InvocationTargetException {
        int count = 1;
        for (PropertyDescriptor property : this.properties) {
            Constable l;
            String type = property.getPropertyType().getName();
            if (this.isInteger(type)) {
                Integer integer = (Integer)property.getReadMethod().invoke(bean, new Object[0]);
                if (integer == null) {
                    prepStmt.setInt(count, -1);
                } else {
                    prepStmt.setInt(count, integer);
                }
                ++count;
                continue;
            }
            if (this.isLong(type)) {
                l = (Long)property.getReadMethod().invoke(bean, new Object[0]);
                if (l == null) {
                    prepStmt.setLong(count, 0L);
                } else {
                    prepStmt.setLong(count, (Long)l);
                }
                ++count;
                continue;
            }
            if (this.isBoolean(type)) {
                l = (Boolean)property.getReadMethod().invoke(bean, new Object[0]);
                if (l == null) {
                    prepStmt.setBoolean(count, false);
                } else {
                    prepStmt.setBoolean(count, (Boolean)l);
                }
                ++count;
                continue;
            }
            if (this.isString(type)) {
                String string = (String)property.getReadMethod().invoke(bean, new Object[0]);
                if (string == null) {
                    prepStmt.setNull(count, 12);
                } else {
                    prepStmt.setString(count, string);
                }
                ++count;
                continue;
            }
            if (this.isDate(type)) {
                Date date = (Date)property.getReadMethod().invoke(bean, new Object[0]);
                if (date == null) {
                    prepStmt.setNull(count, 12);
                } else {
                    prepStmt.setString(count, DateUtil.date2SQLDate(date));
                }
                ++count;
                continue;
            }
            if (this.isFloat(type)) {
                Float f = (Float)property.getReadMethod().invoke(bean, new Object[0]);
                if (f == null) {
                    prepStmt.setFloat(count, 0.0f);
                } else {
                    prepStmt.setFloat(count, f.floatValue());
                }
                ++count;
                continue;
            }
            if (this.isDouble(type)) {
                Double d = (Double)property.getReadMethod().invoke(bean, new Object[0]);
                if (d == null) {
                    prepStmt.setDouble(count, 0.0);
                } else {
                    prepStmt.setDouble(count, d);
                }
                ++count;
                continue;
            }
            SilverTrace.debug("persistence", "SilverpeasBeanDAO.prepareStatementSetProperties", "persistence.MSG_WARN_PROPERTIE_NOT_MANAGED", type);
        }
        return count;
    }
}

