/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.util;

import com.stratelia.webactiv.util.Schema;
import com.stratelia.webactiv.util.exception.UtilException;
import java.util.HashSet;
import java.util.Set;

public abstract class SchemaPool {
    private final Set<Schema> pool = new HashSet<Schema>();

    protected abstract Schema newSchema() throws UtilException;

    protected SchemaPool() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseSchemas() {
        Set<Schema> set = this.pool;
        synchronized (set) {
            for (Schema schema : this.pool) {
                this.release(schema);
            }
        }
    }

    protected Schema getInstance() throws UtilException {
        Schema instance = this.newSchema();
        this.pool.add(instance);
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void release(Schema s) {
        Set<Schema> set = this.pool;
        synchronized (set) {
            this.pool.remove(s);
            s.close();
        }
    }
}

