/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.util;

import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.util.ConfigurationStore;
import com.stratelia.webactiv.util.XMLConfigurationException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.IOUtils;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLConfigurationStore
implements ConfigurationStore {
    private Node rootNode = null;
    private Document xmlConfigDOMDoc = null;
    String configFileName = null;

    public XMLConfigurationStore(String configFileName, InputStream configFileInputStream, String rootString) throws Exception {
        this.load(configFileName, configFileInputStream, rootString);
    }

    public XMLConfigurationStore(File file, String rootString) throws Exception {
        this.loadFromFile(file, rootString);
    }

    public XMLConfigurationStore() throws Exception {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            this.xmlConfigDOMDoc = dbf.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new Exception(e.getMessage());
        }
    }

    public Node setRoot(String rootString) {
        if (rootString == null) {
            return null;
        }
        Element el = this.xmlConfigDOMDoc.getDocumentElement();
        Element n = this.xmlConfigDOMDoc.createElement(rootString);
        if (el == null) {
            this.xmlConfigDOMDoc.appendChild(n);
        } else {
            el.appendChild(n);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serialize() throws FileNotFoundException, IOException {
        FileOutputStream out = new FileOutputStream(new File(this.configFileName));
        StreamResult streamResult = new StreamResult(out);
        TransformerFactory tf = TransformerFactory.newInstance();
        try {
            Transformer serializer = tf.newTransformer();
            serializer.setOutputProperty("encoding", "UTF-8");
            serializer.setOutputProperty("indent", "yes");
            serializer.setOutputProperty("omit-xml-declaration", "no");
            DOMSource domSource = new DOMSource(this.xmlConfigDOMDoc);
            serializer.transform(domSource, streamResult);
        }
        catch (TransformerException ex) {
            Logger.getLogger(XMLConfigurationStore.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    public void setConfigFileName(String configfilename) {
        this.configFileName = configfilename;
    }

    private void loadFromFile(File file, String rootString) throws Exception {
        this.configFileName = file.getAbsolutePath();
        this.load(this.configFileName, null, rootString);
    }

    private void doLoad(String rootString) throws Exception, SAXParseException, IOException {
        if (this.xmlConfigDOMDoc == null) {
            throw new Exception("E6000-0025:Cannot create XML document from the configuration file '" + this.configFileName + "'");
        }
        this.xmlConfigDOMDoc.normalize();
        this.rootNode = this.findNode(this.xmlConfigDOMDoc, rootString);
        if (this.rootNode == null) {
            throw new Exception("E6000-0023:Invalid configuration file '" + this.configFileName + "': " + "Cannot find node '" + rootString + "j'");
        }
    }

    private void load(String configFileName, InputStream configFileInputStream, String rootString) throws Exception {
        this.configFileName = configFileName;
        try {
            DOMParser parser = new DOMParser();
            if (configFileInputStream == null) {
                SilverTrace.debug("util", "ResourceLocator.locateResourceAsStream", "Parsing from file", configFileName);
                try {
                    String cname = "file:///" + configFileName.replace('\\', '/');
                    parser.parse(cname);
                }
                catch (SAXException se) {
                    SilverTrace.error("util", "ResourceLocator.load", "root.EX_XML_PARSING_FAILED", se);
                    throw se;
                }
                catch (IOException ioe) {
                    SilverTrace.error("util", "ResourceLocator.load", "root.EX_LOAD_IO_EXCEPTION", ioe);
                    throw ioe;
                }
            } else {
                InputSource ins = new InputSource(configFileInputStream);
                parser.parse(ins);
            }
            this.xmlConfigDOMDoc = parser.getDocument();
            this.doLoad(rootString);
        }
        catch (IOException e) {
            throw new Exception("E6000-0020:Cannot open configuration file '" + configFileName + "': Error:" + e.getMessage());
        }
        catch (SAXParseException err) {
            throw new Exception("E6000-0022:Cannot parse configuration file '" + configFileName + "'" + ": Error at line " + err.getLineNumber() + ", uri '" + err.getSystemId() + "': " + err.getMessage());
        }
        catch (Exception e) {
            throw new Exception("E6000-0021:Cannot open configuration file '" + configFileName + "': Error:" + e.getMessage());
        }
    }

    public String getNodeValue(String nodename) {
        return this.getXMLParamValue(null, nodename, null);
    }

    public String getXMLParamValue(Node n, String entry, String key) {
        Node paramNode;
        String res = null;
        if (n == null) {
            n = this.rootNode;
        }
        if ((paramNode = this.findNode(n, entry)) == null) {
            return null;
        }
        NodeList paramList = paramNode.getChildNodes();
        int paramsize = paramList.getLength();
        for (int pi = 0; pi < paramsize; ++pi) {
            Node psn = paramList.item(pi);
            if (psn instanceof EntityReference) {
                if (!psn.hasChildNodes()) continue;
                NodeList erKids = psn.getChildNodes();
                int erKidsSize = erKids.getLength();
                for (int ii = 0; ii < erKidsSize; ++ii) {
                    Node entity = erKids.item(ii);
                    if (!(entity instanceof Text)) continue;
                    String v = entity.getNodeValue();
                    res = res == null ? v : res + v;
                }
                continue;
            }
            if (!(psn instanceof Text)) continue;
            String v = psn.getNodeValue();
            if (v == null) {
                return null;
            }
            if (key != null) {
                if (!v.trim().equalsIgnoreCase(key)) continue;
                return key;
            }
            res = res == null ? v.trim() : res + v.trim();
        }
        if (res != null) {
            if (key != null) {
                if (res.trim().equalsIgnoreCase(key)) {
                    return key;
                }
                return null;
            }
            return res;
        }
        return null;
    }

    public String[] getXMLParamValues(Node n, String entry, String key) {
        String res = null;
        ArrayList<String> vres = new ArrayList<String>(10);
        Node[] paramNodes = this.findNodes(n, entry);
        if (paramNodes == null) {
            return null;
        }
        for (Node paramNode : paramNodes) {
            NodeList paramList = paramNode.getChildNodes();
            int paramsize = paramList.getLength();
            for (int pi = 0; pi < paramsize; ++pi) {
                Node psn = paramList.item(pi);
                if (psn instanceof EntityReference) {
                    if (!psn.hasChildNodes()) continue;
                    NodeList erKids = psn.getChildNodes();
                    int erKidsSize = erKids.getLength();
                    for (int ii = 0; ii < erKidsSize; ++ii) {
                        Node entity = erKids.item(ii);
                        if (!(entity instanceof Text)) continue;
                        String v = entity.getNodeValue();
                        res = res == null ? v : res + v;
                    }
                    continue;
                }
                if (!(psn instanceof Text)) continue;
                String v = psn.getNodeValue();
                if (v == null) {
                    return null;
                }
                vres.add(v.trim());
            }
        }
        if (!vres.isEmpty()) {
            return vres.toArray(new String[vres.size()]);
        }
        return null;
    }

    public Node getXMLParamNode(String nodename) {
        if (this.rootNode.hasChildNodes()) {
            NodeList list = this.rootNode.getChildNodes();
            int size = list.getLength();
            for (int i = 0; i < size; ++i) {
                Node n = list.item(i);
                String name = n.getNodeName();
                if (!name.equalsIgnoreCase("param") || this.getXMLParamValue(n, "param-name", nodename) == null) continue;
                return n;
            }
        }
        return null;
    }

    public String getAttributeValue(Node n, String attributeName) {
        if (n == null) {
            return null;
        }
        NamedNodeMap amap = n.getAttributes();
        if (amap != null) {
            Node n2 = amap.getNamedItem(attributeName);
            if (n2 == null) {
                return null;
            }
            String v = n2.getNodeValue();
            return v;
        }
        return null;
    }

    public void putPropety(String key, String value) {
        this.put(key, value);
    }

    @Override
    public void putProperty(String key, String value) {
        this.put(key, value);
    }

    public void replaceValue(Node n, String key, String value) {
        Node entry = this.findNode(n, key);
        if (entry != null) {
            n.removeChild(entry);
        }
        Element newElement = this.xmlConfigDOMDoc.createElement(key);
        Text newValue = this.xmlConfigDOMDoc.createTextNode(value);
        newElement.appendChild(newValue);
        n.appendChild(newElement);
    }

    public Node createElement(String key) {
        return this.xmlConfigDOMDoc.createElement(key);
    }

    public Node createTextNode(String value) {
        return this.xmlConfigDOMDoc.createTextNode(value);
    }

    public void appendChild(Node parent, Node child) {
        parent.appendChild(child);
    }

    @Override
    public void put(String key, String value) {
        String[] values = new String[]{value};
        this.put(key, values);
    }

    public void put(String key, String[] values) {
        Node paramNodeParent;
        Node paramNode = this.getXMLParamNode(key);
        if (paramNode != null && (paramNodeParent = paramNode.getParentNode()) != null) {
            paramNodeParent.removeChild(paramNode);
        }
        Element param = this.xmlConfigDOMDoc.createElement("param");
        Element name = this.xmlConfigDOMDoc.createElement("param-name");
        Element description = this.xmlConfigDOMDoc.createElement("param-description");
        Text nameValue = this.xmlConfigDOMDoc.createTextNode(key);
        for (String value : values) {
            Text vValue = this.xmlConfigDOMDoc.createTextNode(value);
            Element v = this.xmlConfigDOMDoc.createElement("param-value");
            param.appendChild(v);
            v.appendChild(vValue);
        }
        this.rootNode.appendChild(param);
        param.appendChild(name);
        name.appendChild(nameValue);
        param.appendChild(description);
        this.xmlConfigDOMDoc.getDocumentElement().normalize();
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        return this.get(key, defaultValue);
    }

    @Override
    public String getProperty(String key) {
        return this.get(key, null);
    }

    @Override
    public String getString(String key) {
        return this.get(key, null);
    }

    @Override
    public String get(String key, String defaultValue) {
        String thisFunction = "XMLConfigurationStore.get";
        if (this.rootNode.hasChildNodes()) {
            NodeList list = this.rootNode.getChildNodes();
            int size = list.getLength();
            if (size == 0) {
                SilverTrace.debug("util", thisFunction, "Root node has an empty children list. Returning default value");
            }
            for (int i = 0; i < size; ++i) {
                Node n = list.item(i);
                String name = n.getNodeName();
                if (!name.equalsIgnoreCase("param") || this.getXMLParamValue(n, "param-name", key) == null) continue;
                String v = this.getXMLParamValue(n, "param-value", null);
                if (v == null) {
                    return defaultValue;
                }
                return v;
            }
        }
        SilverTrace.debug("util", thisFunction, "Root node has no children. Returning default value");
        return defaultValue;
    }

    public long getLongValue(String key) throws XMLConfigurationException {
        String sv = this.get(key, null);
        if (sv == null) {
            throw new XMLConfigurationException(1);
        }
        try {
            long l = Long.parseLong(sv);
            return l;
        }
        catch (Exception x) {
            throw new XMLConfigurationException(2);
        }
    }

    public int getIntValue(String key) throws XMLConfigurationException {
        String sv = this.get(key, null);
        if (sv == null) {
            throw new XMLConfigurationException(1);
        }
        try {
            int i = Integer.parseInt(sv);
            return i;
        }
        catch (Exception x) {
            throw new XMLConfigurationException(2);
        }
    }

    public String[] getValues(String key) {
        if (this.rootNode.hasChildNodes()) {
            NodeList list = this.rootNode.getChildNodes();
            int size = list.getLength();
            for (int i = 0; i < size; ++i) {
                Node n = list.item(i);
                String name = n.getNodeName();
                if (!name.equalsIgnoreCase("param") || this.getXMLParamValue(n, "param-name", key) == null) continue;
                return this.getXMLParamValues(n, "param-value", null);
            }
        }
        return null;
    }

    public Node findNode(Node node, String name) {
        if (node.getNodeName().equals(name)) {
            return node;
        }
        if (node.hasChildNodes()) {
            NodeList list = node.getChildNodes();
            int size = list.getLength();
            for (int i = 0; i < size; ++i) {
                Node found = this.findNode(list.item(i), name);
                if (found == null) continue;
                return found;
            }
        }
        return null;
    }

    public Node[] findNodes(String name) {
        return this.findNodes(this.xmlConfigDOMDoc, name);
    }

    public Node[] findNodes(Node node, String name) {
        if (node == null) {
            return null;
        }
        if (!StringUtil.isDefined(name)) {
            return null;
        }
        ArrayList<Node> v = new ArrayList<Node>(10);
        if (node.getNodeName().equals(name)) {
            Node[] res = new Node[]{node};
            return res;
        }
        if (node.hasChildNodes()) {
            NodeList list = node.getChildNodes();
            int size = list.getLength();
            for (int i = 0; i < size; ++i) {
                Node found = this.findNode(list.item(i), name);
                if (found == null) continue;
                v.add(found);
            }
        }
        if (v.isEmpty()) {
            return null;
        }
        return v.toArray(new Node[v.size()]);
    }

    @Override
    public String[] getAllNames() {
        ArrayList<String> v = null;
        if (!this.rootNode.hasChildNodes()) {
            return null;
        }
        NodeList list = this.rootNode.getChildNodes();
        int size = list.getLength();
        if (size > 0) {
            v = new ArrayList<String>(size);
            for (int i = 0; i < size; ++i) {
                String value;
                Node n = list.item(i);
                String name = n.getNodeName();
                if (!name.equalsIgnoreCase("param") || (value = this.getXMLParamValue(n, "param-name", null)) == null) continue;
                v.add(value);
            }
        }
        if (v != null && !v.isEmpty()) {
            return v.toArray(new String[v.size()]);
        }
        return null;
    }
}

