/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.admin.component.process.check;

import com.silverpeas.util.StringUtil;
import com.stratelia.webactiv.beans.admin.ComponentInst;
import com.stratelia.webactiv.beans.admin.OrganizationController;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.silverpeas.admin.component.exception.ComponentFileFilterException;
import org.silverpeas.admin.component.parameter.ComponentFileFilterParameter;
import org.silverpeas.notification.message.MessageManager;
import org.silverpeas.process.io.IOAccess;
import org.silverpeas.process.io.file.DummyHandledFile;
import org.silverpeas.process.io.file.FileHandler;
import org.silverpeas.process.management.AbstractFileProcessCheck;
import org.silverpeas.process.management.ProcessExecutionContext;
import org.silverpeas.util.NotifierUtil;
import org.silverpeas.util.error.SilverpeasTransverseErrorUtil;

@Named
public class ComponentFileFilterProcessCheck
extends AbstractFileProcessCheck {
    @Inject
    private OrganizationController organizationController;

    @Override
    public void checkFiles(ProcessExecutionContext processExecutionProcess, FileHandler fileHandler) throws Exception {
        if (IOAccess.READ_WRITE.equals((Object)fileHandler.getIoAccess())) {
            Set<String> componentInstanceIds = this.indentifyComponentInstances(processExecutionProcess, fileHandler);
            for (String componentInstanceId : componentInstanceIds) {
                ComponentInst component = this.organizationController.getComponentInst(componentInstanceId);
                ComponentFileFilterParameter componentFileFilter = ComponentFileFilterParameter.from(component);
                for (File sessionDirectory : fileHandler.listAllSessionHandledRootPathFiles()) {
                    for (File sessionFile : FileUtils.listFiles((File)sessionDirectory, (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE)) {
                        if (!sessionFile.getPath().contains(component.getId())) continue;
                        componentFileFilter.verifyFileAuthorized(sessionFile);
                    }
                }
                for (DummyHandledFile dummyHandledFile : fileHandler.getDummyHandledFiles(componentInstanceId)) {
                    if (dummyHandledFile.isDeleted() || componentFileFilter.isMimeTypeAuthorized(dummyHandledFile.getMimeType())) continue;
                    ComponentFileFilterException exception = new ComponentFileFilterException(componentFileFilter, dummyHandledFile.getName());
                    NotifierUtil.addSevere(SilverpeasTransverseErrorUtil.performExceptionMessage(exception, MessageManager.getLanguage()), new Object[0]);
                    throw exception;
                }
            }
        }
    }

    private Set<String> indentifyComponentInstances(ProcessExecutionContext processExecutionProcess, FileHandler fileHandler) {
        HashSet<String> componentInstanceIds = new HashSet<String>();
        if (StringUtil.isDefined(processExecutionProcess.getComponentInstanceId())) {
            componentInstanceIds.add(processExecutionProcess.getComponentInstanceId());
        }
        componentInstanceIds.addAll(fileHandler.getSessionHandledRootPathNames(true));
        return componentInstanceIds;
    }
}

