/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.admin.space.quota;

import com.silverpeas.annotation.Service;
import com.stratelia.webactiv.beans.admin.SpaceInst;
import com.stratelia.webactiv.util.FileRepositoryManager;
import com.stratelia.webactiv.util.ResourceLocator;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.silverpeas.admin.space.quota.AbstractSpaceQuotaService;
import org.silverpeas.admin.space.quota.DataStorageSpaceQuotaKey;
import org.silverpeas.admin.space.quota.DataStorageSpaceQuotaService;
import org.silverpeas.core.admin.OrganisationControllerFactory;
import org.silverpeas.quota.exception.QuotaException;
import org.silverpeas.quota.model.Quota;
import org.silverpeas.quota.offset.AbstractQuotaCountingOffset;
import org.silverpeas.util.UnitUtil;
import org.silverpeas.util.memory.MemoryUnit;

@Service
public class DefaultDataStorageSpaceQuotaService
extends AbstractSpaceQuotaService<DataStorageSpaceQuotaKey>
implements DataStorageSpaceQuotaService {
    private static final ResourceLocator settings = new ResourceLocator("com.silverpeas.jobStartPagePeas.settings.jobStartPagePeasSettings", "");
    private static long dataStorageInPersonalSpaceQuotaDefaultMaxCount = settings.getLong("quota.personalspace.datastorage.default.maxCount", 0L);

    @Override
    public Quota get(DataStorageSpaceQuotaKey key) throws QuotaException {
        if (key.getSpace().isPersonalSpace()) {
            Quota quota = new Quota();
            quota.setId(-1L);
            quota.setType(key.getQuotaType());
            quota.setResourceId(key.getResourceId());
            quota.setMaxCount(dataStorageInPersonalSpaceQuotaDefaultMaxCount);
            quota.setCount(this.getCurrentCount(key));
            return quota;
        }
        return super.get(key);
    }

    @Override
    protected DataStorageSpaceQuotaKey createKeyFrom(SpaceInst space) {
        return DataStorageSpaceQuotaKey.from(space);
    }

    @Override
    public long getCurrentCount(DataStorageSpaceQuotaKey key) throws QuotaException {
        long currentCount = 0L;
        if (key.getSpace() != null) {
            for (String componentId : OrganisationControllerFactory.getOrganisationController().getAllComponentIdsRecur(key.getSpace().getId())) {
                File file = new File(FileRepositoryManager.getAbsolutePath(componentId));
                if (!file.exists()) continue;
                currentCount += FileUtils.sizeOfDirectory((File)file);
            }
        }
        return currentCount;
    }

    @Override
    public Quota verify(DataStorageSpaceQuotaKey key, AbstractQuotaCountingOffset countingOffset) throws QuotaException {
        Quota quota = new Quota();
        if (this.isActivated() && key.isValid()) {
            if (key.getSpace().isPersonalSpace()) {
                quota.setId(-1L);
                quota.setType(key.getQuotaType());
                quota.setResourceId(key.getResourceId());
                quota.setMaxCount(dataStorageInPersonalSpaceQuotaDefaultMaxCount);
                quota = super.verify(key, quota, countingOffset);
            } else {
                quota = super.verify(key, countingOffset);
            }
        }
        return quota;
    }

    @Override
    protected boolean isActivated() {
        return settings.getBoolean("quota.space.datastorage.activated", false);
    }

    static {
        if (dataStorageInPersonalSpaceQuotaDefaultMaxCount < 0L) {
            dataStorageInPersonalSpaceQuotaDefaultMaxCount = 0L;
        }
        dataStorageInPersonalSpaceQuotaDefaultMaxCount = UnitUtil.convertTo(dataStorageInPersonalSpaceQuotaDefaultMaxCount, MemoryUnit.MB, MemoryUnit.B);
    }
}

