/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.attachment;

import com.silverpeas.scheduler.Job;
import com.silverpeas.scheduler.JobExecutionContext;
import com.silverpeas.scheduler.Scheduler;
import com.silverpeas.scheduler.SchedulerEvent;
import com.silverpeas.scheduler.SchedulerEventListener;
import com.silverpeas.scheduler.SchedulerException;
import com.silverpeas.scheduler.SchedulerFactory;
import com.silverpeas.scheduler.trigger.JobTrigger;
import com.silverpeas.util.FileUtil;
import com.silverpeas.util.ForeignPK;
import java.io.File;
import java.text.ParseException;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.silverpeas.attachment.ActifyDocumentProcessor;
import org.silverpeas.attachment.AttachmentService;
import org.silverpeas.attachment.AttachmentServiceFactory;
import org.silverpeas.attachment.model.DocumentType;
import org.silverpeas.attachment.model.SimpleAttachment;
import org.silverpeas.attachment.model.SimpleDocument;
import org.silverpeas.attachment.model.SimpleDocumentPK;
import org.silverpeas.attachment.model.UnlockContext;
import org.silverpeas.attachment.model.UnlockOption;
import org.silverpeas.attachment.util.SimpleDocumentList;

public class ActifyDocumentProcessScheduler
implements SchedulerEventListener {
    private static final Logger logger = Logger.getLogger(ActifyDocumentProcessScheduler.class.getSimpleName());

    public void initialize() {
        if (ActifyDocumentProcessor.isActifySupportEnabled()) {
            try {
                String cronScheduleProcess = ActifyDocumentProcessor.getCRONForActifyImport();
                String cronSchedulePurge = ActifyDocumentProcessor.getCRONForActifyPurge();
                SchedulerFactory schedulerFactory = SchedulerFactory.getFactory();
                Scheduler scheduler = schedulerFactory.getScheduler();
                Job actifyDocumentImporter = this.getActifyDocumentImporter();
                Job actifyDocumentCleaner = this.getActifyDocumentCleaner();
                scheduler.unscheduleJob(actifyDocumentImporter.getName());
                scheduler.unscheduleJob(actifyDocumentCleaner.getName());
                JobTrigger processTrigger = JobTrigger.triggerAt(cronScheduleProcess);
                scheduler.scheduleJob(actifyDocumentImporter, processTrigger, (SchedulerEventListener)this);
                JobTrigger purgeTrigger = JobTrigger.triggerAt(cronSchedulePurge);
                scheduler.scheduleJob(actifyDocumentCleaner, purgeTrigger, (SchedulerEventListener)this);
            }
            catch (SchedulerException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            catch (ParseException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    @Override
    public void triggerFired(SchedulerEvent anEvent) throws Exception {
        logger.log(Level.INFO, "Starting of the job ''{0}''", anEvent.getJobExecutionContext().getJobName());
    }

    @Override
    public void jobSucceeded(SchedulerEvent anEvent) {
        logger.log(Level.INFO, "The job ''{0}'' has succeeded", anEvent.getJobExecutionContext().getJobName());
    }

    @Override
    public void jobFailed(SchedulerEvent anEvent) {
        String errorMsg = "";
        if (anEvent.isExceptionThrown()) {
            errorMsg = ": " + anEvent.getJobThrowable().getMessage();
        }
        logger.log(Level.SEVERE, "The job ''{0}'' has failed {1}", new String[]{anEvent.getJobExecutionContext().getJobName(), errorMsg});
    }

    protected Job getActifyDocumentImporter() {
        return new Job("ImportActify"){

            @Override
            public void execute(JobExecutionContext context) throws Exception {
                File[] elementsList;
                logger.log(Level.INFO, "Importation of the 3D documents generated by Actify...");
                long now = new Date().getTime();
                AttachmentService attachmentService = AttachmentServiceFactory.getAttachmentService();
                String resultActifyPath = ActifyDocumentProcessor.getActifyResultPath();
                int delayBeforeProcess = ActifyDocumentProcessor.getDelayBeforeImport();
                File folderToAnalyse = new File(resultActifyPath);
                for (File element : elementsList = folderToAnalyse.listFiles()) {
                    File[] filesList;
                    long lastModified = element.lastModified();
                    String dirName = element.getName();
                    String resultActifyFullPath = resultActifyPath + File.separator + dirName;
                    if (!ActifyDocumentProcessScheduler.this.isManagedBySilverpeas(element) || lastModified + (long)(delayBeforeProcess * 1000 * 60) >= now) continue;
                    int separatorIdx = dirName.lastIndexOf(95);
                    boolean isVersioned = dirName.startsWith("v_");
                    String componentId = dirName.substring(2, separatorIdx);
                    String publicationId = dirName.substring(separatorIdx + 1);
                    String detailPathToAnalyse = element.getAbsolutePath();
                    logger.log(Level.FINE, "Path to scan for import Actify documents: {0}", detailPathToAnalyse);
                    folderToAnalyse = new File(detailPathToAnalyse);
                    for (File file : filesList = folderToAnalyse.listFiles()) {
                        String fileName = file.getName();
                        String mimeType = FileUtil.getMimeType(fileName);
                        SimpleDocument document = null;
                        if (isVersioned && ActifyDocumentProcessScheduler.this.documentExists(document = attachmentService.findExistingDocument(new SimpleDocumentPK(null, componentId), fileName, new ForeignPK(publicationId), null))) {
                            attachmentService.updateAttachment(document, file, false, false);
                            UnlockContext unlockContext = new UnlockContext(document.getId(), "", null, "");
                            unlockContext.addOption(UnlockOption.UPLOAD);
                            if (!document.isPublic()) {
                                unlockContext.addOption(UnlockOption.PRIVATE_VERSION);
                            }
                            attachmentService.unlock(unlockContext);
                        }
                        if (ActifyDocumentProcessScheduler.this.documentExists(document)) continue;
                        String userId = "0";
                        DocumentType documentType = DocumentType.attachment;
                        SimpleDocument documentSource = ActifyDocumentProcessScheduler.this.getSourceDocument(fileName, new ForeignPK(publicationId, componentId));
                        if (documentSource != null) {
                            userId = documentSource.getCreatedBy();
                            documentType = documentSource.getDocumentType();
                        }
                        document = new SimpleDocument(new SimpleDocumentPK(null, componentId), publicationId, 0, isVersioned, new SimpleAttachment(fileName, null, null, null, file.length(), mimeType, userId, new Date(), null));
                        document.setDocumentType(documentType);
                        attachmentService.createAttachment(document, file, false);
                    }
                    FileUtils.deleteQuietly((File)new File(resultActifyFullPath));
                }
            }
        };
    }

    protected Job getActifyDocumentCleaner() {
        return new Job("PurgeActify"){

            @Override
            public void execute(JobExecutionContext context) throws Exception {
                File[] elementsList;
                logger.log(Level.INFO, "Purge of the source directory used by Actify...");
                int delayBeforePurge = ActifyDocumentProcessor.getDelayBeforePurge();
                long now = new Date().getTime();
                File folderToAnalyse = new File(ActifyDocumentProcessor.getActifySourcePath());
                for (File element : elementsList = folderToAnalyse.listFiles()) {
                    long lastModified = element.lastModified();
                    if (!element.isDirectory() || lastModified + (long)(delayBeforePurge * 1000 * 60) >= now) continue;
                    logger.log(Level.FINE, "Path to purge: {0}", element.getPath());
                    FileUtils.deleteQuietly((File)new File(element.getAbsolutePath()));
                }
            }
        };
    }

    private boolean isManagedBySilverpeas(File directory) {
        String directoryName = directory.getName();
        return directory.isDirectory() && (directoryName.startsWith("a_") || directoryName.startsWith("v_"));
    }

    private boolean documentExists(SimpleDocument document) {
        return document != null;
    }

    private SimpleDocument getSourceDocument(String filename, ForeignPK publication) {
        SimpleDocument source = null;
        SimpleDocumentList<SimpleDocument> documents = AttachmentServiceFactory.getAttachmentService().listDocumentsByForeignKey(publication, null);
        for (SimpleDocument aDocument : documents) {
            String destfile = FilenameUtils.getBaseName((String)filename);
            String srcfile = FilenameUtils.getBaseName((String)aDocument.getFilename());
            if (!ActifyDocumentProcessor.isCADDocumentSupported(aDocument.getFilename()) || !srcfile.equals(destfile)) continue;
            source = aDocument;
            break;
        }
        return source;
    }
}

