/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.attachment;

import com.silverpeas.scheduler.Scheduler;
import com.silverpeas.scheduler.SchedulerEvent;
import com.silverpeas.scheduler.SchedulerEventListener;
import com.silverpeas.scheduler.SchedulerFactory;
import com.silverpeas.scheduler.trigger.JobTrigger;
import com.silverpeas.ui.DisplayI18NHelper;
import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.notificationManager.NotificationManagerException;
import com.stratelia.silverpeas.notificationManager.NotificationMetaData;
import com.stratelia.silverpeas.notificationManager.NotificationSender;
import com.stratelia.silverpeas.notificationManager.UserRecipient;
import com.stratelia.silverpeas.peasCore.URLManager;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.util.ResourceLocator;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.silverpeas.attachment.AttachmentException;
import org.silverpeas.attachment.AttachmentServiceFactory;
import org.silverpeas.attachment.model.SimpleDocument;
import org.silverpeas.util.Link;

public class ScheduledReservedFile
implements SchedulerEventListener {
    public static final String ATTACHMENT_JOB_NAME_PROCESS = "A_ProcessReservedFileAttachment";
    private ResourceLocator resources = new ResourceLocator("org.silverpeas.util.attachment.Attachment", "");
    private ResourceLocator generalMessage = new ResourceLocator("org.silverpeas.multilang.generalMultilang", "");

    public void initialize() {
        try {
            String cron = this.resources.getString("cronScheduledReservedFile");
            Logger.getLogger(this.getClass().getSimpleName()).log(Level.INFO, "Reserved File Processor scheduled with cron ''{0}''", cron);
            SchedulerFactory schedulerFactory = SchedulerFactory.getFactory();
            Scheduler scheduler = schedulerFactory.getScheduler();
            scheduler.unscheduleJob(ATTACHMENT_JOB_NAME_PROCESS);
            JobTrigger trigger = JobTrigger.triggerAt(cron);
            scheduler.scheduleJob(ATTACHMENT_JOB_NAME_PROCESS, trigger, (SchedulerEventListener)this);
        }
        catch (Exception e) {
            SilverTrace.error("attachment", "ScheduledReservedFile.initialize()", "attachment.EX_CANT_INIT_SCHEDULED_RESERVED_FILE", e);
        }
    }

    public void doScheduledReservedFile() throws AttachmentException {
        SilverTrace.info("attachment", "ScheduledReservedFile.doScheduledReservedFile()", "root.MSG_GEN_ENTER_METHOD");
        try {
            ResourceLocator message = new ResourceLocator("org.silverpeas.util.attachment.multilang.attachment", DisplayI18NHelper.getDefaultLanguage());
            StringBuilder messageBody = new StringBuilder();
            Calendar calendar = Calendar.getInstance(Locale.FRENCH);
            calendar.add(5, 1);
            Date expiryDate = calendar.getTime();
            SilverTrace.info("attachment", "ScheduledReservedFile.doScheduledReservedFile()", "root.MSG_GEN_PARAM_VALUE", "expiryDate = " + expiryDate.toString());
            List<SimpleDocument> documents = AttachmentServiceFactory.getAttachmentService().listExpiringDocuments(expiryDate, null);
            SilverTrace.info("attachment", "ScheduledReservedFile.doScheduledReservedFile()", "root.MSG_GEN_PARAM_VALUE", "Attachments = " + documents.size());
            for (SimpleDocument document : documents) {
                String date = this.getExpiryDate(document);
                String subject = this.createMessageSubject(message, false, false);
                messageBody.append(message.getString("attachment.notifName")).append(" '").append(document.getFilename()).append("'");
                SilverTrace.info("attachment", "ScheduledAlertUser.doScheduledAlertUser()", "root.MSG_GEN_PARAM_VALUE", "body=" + messageBody.toString());
                String body = this.createMessageBody(message, messageBody, date, false, false);
                NotificationMetaData notifMetaData = new NotificationMetaData(0, subject, body);
                this.createMessage(date, notifMetaData, document, false, false);
                messageBody = new StringBuilder();
            }
            calendar = Calendar.getInstance(Locale.FRENCH);
            Date alertDate = calendar.getTime();
            SilverTrace.info("attachment", "ScheduledReservedFile.doScheduledReservedFile()", "root.MSG_GEN_PARAM_VALUE", "alertDate = " + alertDate.toString());
            documents = AttachmentServiceFactory.getAttachmentService().listDocumentsRequiringWarning(alertDate, null);
            SilverTrace.info("attachment", "ScheduledReservedFile.doScheduledReservedFile()", "root.MSG_GEN_PARAM_VALUE", "Attachemnts = " + documents.size());
            messageBody = new StringBuilder();
            for (SimpleDocument document : documents) {
                String date = this.getExpiryDate(document);
                String subject = this.createMessageSubject(message, true, false);
                messageBody.append(message.getString("attachment.notifName")).append(" '").append(document.getFilename()).append("'");
                SilverTrace.info("attachment", "ScheduledAlertUser.doScheduledAlertUser()", "root.MSG_GEN_PARAM_VALUE", "body=" + messageBody.toString());
                String body = this.createMessageBody(message, messageBody, date, true, false);
                NotificationMetaData notifMetaData = new NotificationMetaData(0, subject, body);
                this.createMessage(date, notifMetaData, document, true, false);
                messageBody = new StringBuilder();
            }
            calendar = Calendar.getInstance(Locale.FRENCH);
            Date libDate = calendar.getTime();
            SilverTrace.info("attachment", "ScheduledReservedFile.doScheduledReservedFile()", "root.MSG_GEN_PARAM_VALUE", "libDate = " + libDate.toString());
            documents = AttachmentServiceFactory.getAttachmentService().listDocumentsToUnlock(libDate, null);
            SilverTrace.info("attachment", "ScheduledReservedFile.doScheduledReservedFile()", "root.MSG_GEN_PARAM_VALUE", "Attachemnts = " + documents.size());
            messageBody = new StringBuilder();
            for (SimpleDocument document : documents) {
                String date = this.getExpiryDate(document);
                String subject = this.createMessageSubject(message, false, true);
                messageBody.append(message.getString("attachment.notifName")).append(" '").append(document.getFilename()).append("'");
                SilverTrace.info("attachment", "ScheduledAlertUser.doScheduledAlertUser()", "root.MSG_GEN_PARAM_VALUE", "body=" + messageBody.toString());
                String body = this.createMessageBody(message, messageBody, date, false, true);
                NotificationMetaData notifMetaData = new NotificationMetaData(0, subject, body);
                this.createMessage(date, notifMetaData, document, false, true);
                messageBody = new StringBuilder();
                document.unlock();
                AttachmentServiceFactory.getAttachmentService().updateAttachment(document, false, false);
            }
        }
        catch (Exception e) {
            throw new AttachmentException("ScheduledReservedFile.doScheduledReservedFile()", 4, "root.EX_CANT_GET_REMOTE_OBJECT", e);
        }
        SilverTrace.info("attachment", "ScheduledReservedFile.doScheduledReservedFile()", "root.MSG_GEN_EXIT_METHOD");
    }

    private String getExpiryDate(SimpleDocument document) {
        Calendar atDate = Calendar.getInstance();
        atDate.setTime(document.getExpiry());
        String day = "GML.jour" + atDate.get(7);
        String month = "GML.mois" + atDate.get(2);
        String date = this.generalMessage.getString(day) + " " + atDate.get(5) + " " + this.generalMessage.getString(month) + " " + atDate.get(1);
        return date;
    }

    private void createMessageByLanguage(String date, String url, SimpleDocument document, NotificationMetaData notifMetaData, boolean alert, boolean lib) throws AttachmentException {
        for (String language : DisplayI18NHelper.getLanguages()) {
            ResourceLocator message = new ResourceLocator("org.silverpeas.util.attachment.multilang.attachment", language);
            String subject = this.createMessageSubject(message, alert, lib);
            StringBuilder messageBody = new StringBuilder();
            messageBody.append(message.getString("attachment.notifName")).append(" '").append(document.getFilename()).append("'");
            String body = this.createMessageBody(message, messageBody, date, alert, lib);
            notifMetaData.addLanguage(language, subject, body);
            Link link = new Link(url, message.getString("attachment.notifLinkLabel"));
            notifMetaData.setLink(link, language);
        }
    }

    private void createMessage(String date, NotificationMetaData notifMetaData, SimpleDocument document, boolean alert, boolean lib) throws AttachmentException {
        SilverTrace.info("attachment", "ScheduledReservedFile.createMessage()", "root.MSG_GEN_EXIT_METHOD");
        String url = URLManager.getURL(null, null, document.getInstanceId()) + "GoToFilesTab?Id=" + document.getForeignId();
        this.createMessageByLanguage(date, url, document, notifMetaData, alert, lib);
        notifMetaData.addUserRecipient(new UserRecipient(document.getEditedBy()));
        notifMetaData.setComponentId(document.getInstanceId());
        this.notifyUser(notifMetaData, "-1", document.getInstanceId());
    }

    private String createMessageBody(ResourceLocator message, StringBuilder body, String date, boolean alert, boolean lib) {
        if (lib) {
            return body.append(" ").append(message.getString("attachment.notifUserLib")).append("\n\n").toString();
        }
        if (alert) {
            return body.append(" ").append(message.getString("attachment.notifUserAlert")).append(" (").append(date).append(") ").append("\n\n").toString();
        }
        return body.append(" ").append(message.getString("attachment.notifUserExpiry")).append("\n\n").toString();
    }

    private String createMessageSubject(ResourceLocator message, boolean alert, boolean lib) {
        if (lib) {
            return message.getString("attachment.notifSubjectLib");
        }
        if (alert) {
            return message.getString("attachment.notifSubjectAlert");
        }
        return message.getString("attachment.notifSubjectExpiry");
    }

    public void notifyUser(NotificationMetaData notifMetaData, String senderId, String componentId) throws AttachmentException {
        SilverTrace.info("attachment", "AttachmentBmImpl.notifyUser()", "root.MSG_GEN_EXIT_METHOD");
        try {
            SilverTrace.info("attachment", "AttachmentBmImpl.notifyUser()", "root.MSG_GEN_EXIT_METHOD", " senderId = " + senderId + " componentId = " + componentId);
            if (!StringUtil.isDefined(notifMetaData.getSender())) {
                notifMetaData.setSender(senderId);
            }
            NotificationSender notifSender = new NotificationSender(componentId);
            notifSender.notifyUser(notifMetaData);
        }
        catch (NotificationManagerException e) {
            throw new AttachmentException("AttachmentBmImpl.notifyUser()", 4, "attachment.MSG_ATTACHMENT_NOT_EXIST", e);
        }
    }

    @Override
    public void triggerFired(SchedulerEvent anEvent) throws Exception {
        SilverTrace.debug("Attachment", "Attachment_TimeoutManagerImpl.handleSchedulerEvent", "The job '" + anEvent.getJobExecutionContext().getJobName() + "' is executed");
        this.doScheduledReservedFile();
    }

    @Override
    public void jobSucceeded(SchedulerEvent anEvent) {
        SilverTrace.debug("Attachment", "Attachment_TimeoutManagerImpl.handleSchedulerEvent", "The job '" + anEvent.getJobExecutionContext().getJobName() + "' was successful");
    }

    @Override
    public void jobFailed(SchedulerEvent anEvent) {
        SilverTrace.error("Attachment", "Attachment_TimeoutManagerImpl.handleSchedulerEvent", "The job '" + anEvent.getJobExecutionContext().getJobName() + "' was not successful");
    }
}

