/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.authentication;

import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.util.ResourceLocator;
import org.silverpeas.authentication.AuthenticationConnection;
import org.silverpeas.authentication.AuthenticationCredential;
import org.silverpeas.authentication.exception.AuthenticationException;
import org.silverpeas.authentication.exception.AuthenticationPwdChangeNotAvailException;

public abstract class Authentication {
    protected static final String module = "authentication";
    protected boolean enabled = true;
    public static final String ENC_TYPE_UNIX = "CryptUnix";
    public static final String ENC_TYPE_MD5 = "CryptMd5";
    public static final String ENC_TYPE_CLEAR = "ClearText";
    public static final String PASSWORD_IS_ABOUT_TO_EXPIRE = "Svp_Pwd_About_To_Expire";
    public static final String PASSWORD_CHANGE_ALLOWED = "Svp_Password_Change_Allowed";
    private String authServerName;

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getServerName() {
        return this.authServerName;
    }

    public void init(String authenticationServerName, ResourceLocator settings) {
        this.authServerName = authenticationServerName;
        this.enabled = settings.getBoolean(this.authServerName + ".enabled", true);
        this.loadProperties(settings);
    }

    public void authenticate(final AuthenticationCredential credential) throws AuthenticationException {
        this.doSecurityOperation(new SecurityOperation("authenticate"){

            @Override
            public <T> void perform(AuthenticationConnection<T> connection) throws AuthenticationException {
                Authentication.this.doAuthentication(connection, credential);
            }
        });
    }

    public void changePassword(final AuthenticationCredential credential, final String newPassword) throws AuthenticationException {
        this.doSecurityOperation(new SecurityOperation("changePassword"){

            @Override
            public <T> void perform(AuthenticationConnection<T> connection) throws AuthenticationException {
                Authentication.this.doChangePassword(connection, credential, newPassword);
            }
        });
    }

    public void resetPassword(final String login, final String newPassword) throws AuthenticationException {
        this.doSecurityOperation(new SecurityOperation("resetPassword"){

            @Override
            public <T> void perform(AuthenticationConnection<T> connection) throws AuthenticationException {
                Authentication.this.doResetPassword(connection, login, newPassword);
            }
        });
    }

    protected abstract void loadProperties(ResourceLocator var1);

    protected abstract <T> AuthenticationConnection<T> openConnection() throws AuthenticationException;

    protected abstract <T> void closeConnection(AuthenticationConnection<T> var1) throws AuthenticationException;

    protected abstract <T> void doAuthentication(AuthenticationConnection<T> var1, AuthenticationCredential var2) throws AuthenticationException;

    protected <T> void doChangePassword(AuthenticationConnection<T> connection, AuthenticationCredential credential, String newPassword) throws AuthenticationException {
        throw new AuthenticationPwdChangeNotAvailException("AuthenticationServer.changePassword", 4, "authentication.EX_PASSWD_CHANGE_NOTAVAILABLE");
    }

    protected <T> void doResetPassword(AuthenticationConnection<T> connection, String login, String newPassword) throws AuthenticationException {
        throw new AuthenticationPwdChangeNotAvailException("AuthenticationServer.doResetPassword", 4, "authentication.EX_PASSWD_CHANGE_NOTAVAILABLE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSecurityOperation(SecurityOperation op) throws AuthenticationException {
        AuthenticationConnection connection = null;
        try {
            connection = this.openConnection();
            op.perform(connection);
            this.closeConnection(connection);
        }
        finally {
            try {
                if (connection != null) {
                    this.closeConnection(connection);
                }
            }
            catch (AuthenticationException closeEx) {
                SilverTrace.error(module, "Authentication." + op.getName(), "root.EX_EMERGENCY_CONNECTION_CLOSE_FAILED", "", closeEx);
            }
        }
    }

    private abstract class SecurityOperation {
        public static final String AUTHENTICATION = "authenticate";
        public static final String PASSWORD_CHANGE = "changePassword";
        public static final String PASSWORD_RESET = "resetPassword";
        private String name;

        public SecurityOperation(String operationName) {
            this.name = operationName;
        }

        public String getName() {
            return this.name;
        }

        public abstract <T> void perform(AuthenticationConnection<T> var1) throws AuthenticationException;
    }
}

