/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.authentication;

import java.util.HashMap;
import java.util.Map;

public class AuthenticationCredential {
    private String login;
    private String password;
    private String domainId;
    private Map<String, Object> capabilities = new HashMap<String, Object>();

    private AuthenticationCredential() {
    }

    public static AuthenticationCredential newWithAsLogin(String login) {
        AuthenticationCredential credential = new AuthenticationCredential();
        credential.setLogin(login);
        return credential;
    }

    public AuthenticationCredential withAsPassword(String password) {
        this.setPassword(password);
        return this;
    }

    public AuthenticationCredential withAsDomainId(String domainId) {
        this.setDomainId(domainId);
        return this;
    }

    public String getLogin() {
        return this.login;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDomainId() {
        return this.domainId;
    }

    public Map<String, Object> getCapabilities() {
        return this.capabilities;
    }

    private void setLogin(String login) {
        this.login = login;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDomainId(String domainId) {
        this.domainId = domainId;
    }

    public boolean isPasswordSet() {
        return this.password != null;
    }
}

