/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.authentication;

import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.util.ResourceLocator;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import org.silverpeas.authentication.Authentication;
import org.silverpeas.authentication.AuthenticationConnection;
import org.silverpeas.authentication.AuthenticationCredential;
import org.silverpeas.authentication.exception.AuthenticationBadCredentialException;
import org.silverpeas.authentication.exception.AuthenticationException;
import org.silverpeas.authentication.exception.AuthenticationHostException;

public class AuthenticationNT
extends Authentication {
    protected String m_Host;
    protected int m_Port = 9999;
    protected int m_Timeout = 10000;
    char START_DELIM = '\u0001';
    char LOGON_COMMAND = (char)49;
    char GET_USER_INFORMATION_COMMAND = (char)50;
    char END_DELIM = (char)2;

    @Override
    public void loadProperties(ResourceLocator settings) {
        this.m_Host = settings.getString(this.getServerName() + ".NTRISHost");
        this.m_Port = Integer.parseInt(settings.getString(this.getServerName() + ".NTRISPort"));
    }

    protected AuthenticationConnection<Socket> openConnection() throws AuthenticationException {
        try {
            InetAddress localAddr = InetAddress.getByName(this.m_Host);
            Socket socket = new Socket(localAddr, this.m_Port);
            socket.setSoTimeout(this.m_Timeout);
            return new AuthenticationConnection<Socket>(socket);
        }
        catch (Exception ex) {
            throw new AuthenticationHostException("AuthenticationNT.openConnection()", 4, "root.EX_CONNECTION_OPEN_FAILED", "Host=" + this.m_Host + ";Port=" + Integer.toString(this.m_Port), ex);
        }
    }

    protected void closeConnection(AuthenticationConnection connection) throws AuthenticationException {
        try {
            Socket connector = AuthenticationNT.getSocket(connection);
            if (connector != null) {
                connector.close();
            }
        }
        catch (Exception ex) {
            throw new AuthenticationHostException("AuthenticationNT.closeConnection()", 4, "root.EX_CONNECTION_CLOSE_FAILED", "Host=" + this.m_Host + ";Port=" + Integer.toString(this.m_Port), ex);
        }
    }

    protected void doAuthentication(AuthenticationConnection connection, AuthenticationCredential credential) throws AuthenticationException {
        String line;
        String pass;
        String login = credential.getLogin();
        SilverTrace.info("authentication", "AuthenticationNT.doAuthentication()", "authentication.MSG_TRY_TO_AUTHENTICATE_USER", "User=" + login);
        int idx = login.indexOf("\\");
        if (idx > 0) {
            login = login.substring(idx + 1);
        }
        if ((pass = credential.getPassword()) == null) {
            pass = "";
        }
        try {
            Socket socket = AuthenticationNT.getSocket(connection);
            PrintWriter writer = new PrintWriter(socket.getOutputStream(), true);
            BufferedReader reader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            line = reader.readLine();
            StringBuffer sb = new StringBuffer(3 + login.length() + 1 + pass.length() + 1);
            sb.append(this.START_DELIM);
            sb.append(this.LOGON_COMMAND);
            sb.append(this.START_DELIM);
            sb.append("");
            sb.append(this.START_DELIM);
            sb.append(login);
            sb.append(this.START_DELIM);
            sb.append(pass);
            sb.append(this.END_DELIM);
            writer.println(sb);
            line = reader.readLine();
        }
        catch (Exception ex) {
            throw new AuthenticationHostException("AuthenticationNT.doAuthentication()", 4, "authentication.EX_NT_ACCESS_ERROR", ex);
        }
        if (!"-OK".equalsIgnoreCase(line)) {
            if ("-ERR".equalsIgnoreCase(line)) {
                throw new AuthenticationBadCredentialException("AuthenticationNT.doAuthentication()", 4, "authentication.EX_AUTHENTICATION_BAD_CREDENTIAL", "User=" + login);
            }
            throw new AuthenticationHostException("AuthenticationNT.doAuthentication()", 4, "authentication.EX_NT_RETURN_ERROR", "Line=" + line);
        }
        SilverTrace.info("authentication", "AuthenticationNT.doAuthentication()", "authentication.MSG_USER_AUTHENTIFIED", "User=" + login);
    }

    private static Socket getSocket(AuthenticationConnection connection) {
        return (Socket)connection.getConnector();
    }
}

