/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.authentication;

import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.util.DBUtil;
import com.stratelia.webactiv.util.ResourceLocator;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.silverpeas.authentication.Authentication;
import org.silverpeas.authentication.AuthenticationConnection;
import org.silverpeas.authentication.AuthenticationCredential;
import org.silverpeas.authentication.encryption.PasswordEncryption;
import org.silverpeas.authentication.encryption.PasswordEncryptionFactory;
import org.silverpeas.authentication.exception.AuthenticationBadCredentialException;
import org.silverpeas.authentication.exception.AuthenticationException;
import org.silverpeas.authentication.exception.AuthenticationHostException;
import org.silverpeas.authentication.exception.AuthenticationPwdNotAvailException;
import org.silverpeas.authentication.verifier.AuthenticationUserVerifierFactory;
import org.silverpeas.util.crypto.CryptMD5;

public class AuthenticationSQL
extends Authentication {
    protected String jdbcUrl;
    protected String jdbcLogin;
    protected String jdbcPassword;
    protected String jdbcDriver;
    protected String userTableName;
    protected String loginColumnName;
    protected String passwordColumnName;
    protected String passwordAvailableColumnName;

    @Override
    public void loadProperties(ResourceLocator settings) {
        String serverName = this.getServerName();
        this.jdbcUrl = settings.getString(serverName + ".SQLJDBCUrl");
        this.jdbcLogin = settings.getString(serverName + ".SQLAccessLogin");
        this.jdbcPassword = settings.getString(serverName + ".SQLAccessPasswd");
        this.jdbcDriver = settings.getString(serverName + ".SQLDriverClass");
        this.userTableName = settings.getString(serverName + ".SQLUserTableName");
        this.loginColumnName = settings.getString(serverName + ".SQLUserLoginColumnName");
        this.passwordColumnName = settings.getString(serverName + ".SQLUserPasswordColumnName");
        this.passwordAvailableColumnName = settings.getString(serverName + ".SQLUserPasswordAvailableColumnName");
    }

    protected AuthenticationConnection<Connection> openConnection() throws AuthenticationException {
        Driver driverSQL;
        Properties info = new Properties();
        try {
            info.setProperty("user", this.jdbcLogin);
            info.setProperty("password", this.jdbcPassword);
            driverSQL = (Driver)Class.forName(this.jdbcDriver).newInstance();
        }
        catch (Exception iex) {
            throw new AuthenticationHostException("AuthenticationSQL.openConnection()", 4, "root.EX_CANT_INSTANCIATE_DB_DRIVER", "Driver=" + this.jdbcDriver, iex);
        }
        try {
            Connection connection = driverSQL.connect(this.jdbcUrl, info);
            return new AuthenticationConnection<Connection>(connection);
        }
        catch (SQLException ex) {
            throw new AuthenticationHostException("AuthenticationSQL.openConnection()", 4, "root.EX_CONNECTION_OPEN_FAILED", "JDBCUrl=" + this.jdbcUrl, ex);
        }
    }

    protected void closeConnection(AuthenticationConnection connection) throws AuthenticationException {
        Connection sqlConnection = AuthenticationSQL.getSQLConnection(connection);
        try {
            if (sqlConnection != null) {
                sqlConnection.close();
            }
        }
        catch (SQLException ex) {
            throw new AuthenticationHostException("AuthenticationSQL.closeConnection()", 4, "root.EX_CONNECTION_CLOSE_FAILED", "JDBCUrl=" + this.jdbcUrl, ex);
        }
    }

    protected void doAuthentication(AuthenticationConnection connection, AuthenticationCredential credential) throws AuthenticationException {
        String sqlPassword;
        String login = credential.getLogin();
        String password = credential.getPassword();
        if (password == null) {
            password = "";
        }
        if (!StringUtil.isDefined(sqlPassword = this.getPassword(AuthenticationSQL.getSQLConnection(connection), login))) {
            throw new AuthenticationBadCredentialException("AuthenticationSQL.doAuthentication()", 4, "authentication.EX_AUTHENTICATION_BAD_CREDENTIAL", "User=" + login);
        }
        this.checkPassword(login, password, sqlPassword);
        AuthenticationUserVerifierFactory.getUserMustChangePasswordVerifier(credential).verify();
    }

    private String getPassword(Connection connection, String login) throws AuthenticationException {
        String sqlPasswd;
        ResultSet rs = null;
        PreparedStatement stmt = null;
        String loginQuery = StringUtil.isDefined(this.passwordAvailableColumnName) ? "SELECT " + this.loginColumnName + ", " + this.passwordColumnName + ", " + this.passwordAvailableColumnName + " FROM " + this.userTableName + " WHERE " + this.loginColumnName + " = ?" : "SELECT " + this.loginColumnName + ", " + this.passwordColumnName + " FROM " + this.userTableName + " WHERE " + this.loginColumnName + " = ?";
        try {
            stmt = connection.prepareStatement(loginQuery);
            stmt.setString(1, login);
            rs = stmt.executeQuery();
            if (rs.next()) {
                String validString;
                if (StringUtil.isDefined(this.passwordAvailableColumnName) && "N".equalsIgnoreCase(validString = rs.getString(this.passwordAvailableColumnName))) {
                    throw new AuthenticationPwdNotAvailException("AuthenticationSQL.getPassword()", 4, "authentication.EX_PWD_NOT_AVAILABLE", "User=" + login);
                }
            } else {
                throw new AuthenticationBadCredentialException("AuthenticationSQL.doAuthentication()", 4, "authentication.EX_USER_NOT_FOUND", "User=" + login);
            }
            sqlPasswd = rs.getString(this.passwordColumnName);
            SilverTrace.info("authentication", "AuthenticationSQL.doAuthentication()", "authentication.MSG_USER_AUTHENTIFIED", "User=" + login);
        }
        catch (SQLException ex) {
            try {
                throw new AuthenticationHostException("AuthenticationSQL.doAuthentication()", 4, "authentication.EX_SQL_ACCESS_ERROR", ex);
            }
            catch (Throwable throwable) {
                DBUtil.close(rs, stmt);
                throw throwable;
            }
        }
        DBUtil.close(rs, stmt);
        return sqlPasswd;
    }

    private void updatePassword(Connection connection, String login, String newPassword) throws AuthenticationException {
        PreparedStatement stmt = null;
        String updateQuery = "UPDATE " + this.userTableName + " SET " + this.passwordColumnName + " = ? WHERE " + this.loginColumnName + " = ?";
        try {
            stmt = connection.prepareStatement(updateQuery);
            stmt.setString(1, newPassword);
            stmt.setString(2, login);
            stmt.executeUpdate();
        }
        catch (SQLException ex) {
            throw new AuthenticationHostException("AuthenticationSQL.updatePassword()", 4, "authentication.EX_SQL_ACCESS_ERROR", ex);
        }
        finally {
            DBUtil.close(stmt);
        }
    }

    protected void doChangePassword(AuthenticationConnection connection, AuthenticationCredential credential, String newPassword) throws AuthenticationException {
        Connection sqlConnection = AuthenticationSQL.getSQLConnection(connection);
        String login = credential.getLogin();
        String oldPassword = credential.getPassword();
        String passwordInDB = this.getPassword(sqlConnection, login);
        this.checkPassword(login, oldPassword, passwordInDB);
        String newPasswordInDB = this.getNewPasswordDigest(newPassword);
        this.updatePassword(sqlConnection, login, newPasswordInDB);
    }

    protected void doResetPassword(AuthenticationConnection connection, String login, String newPassword) throws AuthenticationException {
        Connection sqlConnection = AuthenticationSQL.getSQLConnection(connection);
        String newPasswordInDB = this.getNewPasswordDigest(newPassword);
        this.updatePassword(sqlConnection, login, newPasswordInDB);
    }

    private static Connection getSQLConnection(AuthenticationConnection connection) {
        return (Connection)connection.getConnector();
    }

    private String getNewPasswordDigest(String newPassword) {
        PasswordEncryptionFactory factory = PasswordEncryptionFactory.getFactory();
        PasswordEncryption encryption = factory.getDefaultPasswordEncryption();
        return encryption.encrypt(newPassword);
    }

    private void checkPassword(String login, String password, String digest) throws AuthenticationBadCredentialException {
        block2: {
            try {
                PasswordEncryptionFactory factory = PasswordEncryptionFactory.getFactory();
                PasswordEncryption encryption = factory.getPasswordEncryption(digest);
                encryption.check(password, digest);
            }
            catch (AssertionError error) {
                String actualDigest = CryptMD5.encrypt(password);
                if (actualDigest.equals(digest)) break block2;
                throw new AuthenticationBadCredentialException("AuthenticationSQL.checkPassword()", 4, "authentication.EX_INCORRECT_PASSWORD", "User=" + login);
            }
        }
    }
}

