/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.authentication.verifier;

import com.silverpeas.util.StringUtil;
import com.silverpeas.util.i18n.I18NHelper;
import com.stratelia.webactiv.beans.admin.UserDetail;
import javax.servlet.http.HttpServletRequest;
import org.silverpeas.authentication.exception.AuthenticationUserMustAcceptTermsOfService;
import org.silverpeas.authentication.verifier.AbstractAuthenticationVerifier;
import org.silverpeas.cache.service.CacheServiceFactory;
import org.silverpeas.termsOfService.constant.TermsOfServiceAcceptanceFrequency;

public class UserMustAcceptTermsOfServiceVerifier
extends AbstractAuthenticationVerifier {
    public static final String ERROR_USER_TOS_REFUSED = "Error_UserTosRefused";
    public static final String ERROR_USER_TOS_TIMEOUT = "Error_UserTosTimeout";
    private static TermsOfServiceAcceptanceFrequency globalAcceptanceFrequency = TermsOfServiceAcceptanceFrequency.decode(settings.getString("termsOfServiceAcceptanceFrequency"));
    private static final int LIVE_10_MINUTES = 600;
    private String tosToken;

    protected UserMustAcceptTermsOfServiceVerifier(UserDetail user) {
        super(user);
    }

    public String getDestination(HttpServletRequest request) {
        request.setAttribute("tosToken", (Object)this.tosToken);
        request.setAttribute("language", (Object)this.getUser().getUserPreferences().getLanguage());
        boolean specificTemplateContentActivated = settings.getBoolean("termsOfServiceAcceptanceSpecificTemplateContent.domain" + this.getUser().getDomainId(), false);
        if (specificTemplateContentActivated) {
            request.setAttribute("templateDomainIdContent", (Object)("_domain" + this.getUser().getDomainId()));
        }
        return "/CredentialsServlet/TermsOfServiceRequest";
    }

    public UserMustAcceptTermsOfServiceVerifier verify() throws AuthenticationUserMustAcceptTermsOfService {
        if (this.isTermsOfServiceAcceptanceDateIsExpired()) {
            this.tosToken = CacheServiceFactory.getApplicationCacheService().add(this, 600);
            throw new AuthenticationUserMustAcceptTermsOfService();
        }
        return this;
    }

    private synchronized boolean isTermsOfServiceAcceptanceDateIsExpired() {
        if (this.getUser() == null || this.getUser().isAnonymous()) {
            return false;
        }
        String specificAcceptanceFrequencyValue = settings.getString("termsOfServiceAcceptanceFrequency.domain" + this.getUser().getDomainId(), null);
        TermsOfServiceAcceptanceFrequency acceptanceFrequency = StringUtil.isDefined(specificAcceptanceFrequencyValue) ? TermsOfServiceAcceptanceFrequency.decode(specificAcceptanceFrequencyValue) : globalAcceptanceFrequency;
        return acceptanceFrequency.isActivated() && acceptanceFrequency.isAcceptanceDateExpired(this.getUser().getTosAcceptanceDate(), I18NHelper.defaultLanguage);
    }

    public UserMustAcceptTermsOfServiceVerifier clearCache() {
        UserMustAcceptTermsOfServiceVerifier.clearCache(this.tosToken);
        return this;
    }

    protected static synchronized UserMustAcceptTermsOfServiceVerifier get(String tosToken) {
        UserMustAcceptTermsOfServiceVerifier verifier = CacheServiceFactory.getApplicationCacheService().get(tosToken, UserMustAcceptTermsOfServiceVerifier.class);
        if (verifier == null) {
            verifier = new UserMustAcceptTermsOfServiceVerifier(null);
        }
        return verifier;
    }

    private static synchronized void clearCache(String tosToken) {
        if (tosToken != null) {
            CacheServiceFactory.getApplicationCacheService().remove(tosToken);
        }
    }
}

