/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.cache.service;

import com.stratelia.webactiv.util.GeneralPropertiesManager;
import org.silverpeas.cache.service.CacheService;
import org.silverpeas.cache.service.EhCacheService;
import org.silverpeas.cache.service.InMemoryCacheService;
import org.silverpeas.cache.service.SimpleCacheService;
import org.silverpeas.cache.service.ThreadCacheService;
import org.silverpeas.cache.service.VolatileResourceCacheService;

public class CacheServiceFactory {
    private static final CacheServiceFactory instance = new CacheServiceFactory();
    private final SimpleCacheService threadCacheService = new ThreadCacheService();
    private final SimpleCacheService requestCacheService = new ThreadCacheService();
    private final CacheService cacheService;

    private CacheServiceFactory() {
        int nbMaxElements = GeneralPropertiesManager.getInteger("application.cache.common.nbMaxElements", 0);
        if (nbMaxElements < 0) {
            nbMaxElements = 0;
        }
        this.cacheService = new EhCacheService(nbMaxElements);
    }

    private static CacheServiceFactory getInstance() {
        return instance;
    }

    public static SimpleCacheService getThreadCacheService() {
        return CacheServiceFactory.getInstance().threadCacheService;
    }

    public static SimpleCacheService getRequestCacheService() {
        return CacheServiceFactory.getInstance().requestCacheService;
    }

    public static SimpleCacheService getSessionCacheService() {
        InMemoryCacheService simpleCacheService = CacheServiceFactory.getInstance().requestCacheService.get("@SessionCache@", InMemoryCacheService.class);
        if (simpleCacheService != null) {
            return simpleCacheService;
        }
        return CacheServiceFactory.getRequestCacheService();
    }

    public static VolatileResourceCacheService getSessionVolatileResourceCacheService() {
        VolatileResourceCacheService volatileResourceCacheService = CacheServiceFactory.getSessionCacheService().get(VolatileResourceCacheService.class.getName(), VolatileResourceCacheService.class);
        if (volatileResourceCacheService == null) {
            volatileResourceCacheService = new VolatileResourceCacheService();
            CacheServiceFactory.getSessionCacheService().put(VolatileResourceCacheService.class.getName(), volatileResourceCacheService);
        }
        return volatileResourceCacheService;
    }

    public static CacheService getApplicationCacheService() {
        return CacheServiceFactory.getInstance().cacheService;
    }

    public static void clearAllThreadCaches() {
        CacheServiceFactory.getThreadCacheService().clear();
        CacheServiceFactory.getRequestCacheService().clear();
    }
}

