/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.cache.service.Handler;

import java.lang.reflect.ParameterizedType;
import org.silverpeas.cache.service.CacheServiceFactory;
import org.silverpeas.cache.service.SimpleCacheService;

public abstract class CacheValueHandler<V> {
    private final Class<V> valueClass;

    protected CacheValueHandler() {
        try {
            this.valueClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract <C extends SimpleCacheService> C getCacheService();

    protected abstract String getCacheKeySuffix();

    public V get() {
        String cacheKey = this.getClass().getName() + "_" + this.getCacheKeySuffix();
        V value = CacheServiceFactory.getRequestCacheService().get(cacheKey, this.valueClass);
        if (value == null && (value = this.defaultValue()) != null) {
            CacheServiceFactory.getRequestCacheService().put(cacheKey, value);
        }
        return value;
    }

    protected abstract V defaultValue();
}

