/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.cache.service;

import com.silverpeas.SilverpeasContent;
import com.silverpeas.session.SessionInfo;
import com.silverpeas.util.ForeignPK;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.silverpeas.attachment.AttachmentServiceFactory;

public class VolatileResourceCacheService {
    private Map<ForeignPK, Object> componentResources = new HashMap<ForeignPK, Object>();

    public int newVolatileIntegerIdentifier() {
        String volatileId = this.newVolatileIntegerIdentifierAsString();
        return Integer.parseInt(volatileId);
    }

    public synchronized String newVolatileIntegerIdentifierAsString() {
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException ignored) {
            // empty catch block
        }
        String currentTime = String.valueOf(System.currentTimeMillis());
        return "-" + currentTime.substring(currentTime.length() - 9, currentTime.length());
    }

    public long newVolatileLongIdentifier() {
        String volatileId = this.newVolatileLongIdentifierAsString();
        return Long.parseLong(volatileId);
    }

    public synchronized String newVolatileLongIdentifierAsString() {
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException ignored) {
            // empty catch block
        }
        String currentTime = String.valueOf(System.currentTimeMillis());
        return "-" + currentTime.substring(1);
    }

    public String newVolatileStringIdentifier() {
        return "volatile-" + UUID.randomUUID().toString();
    }

    public Object addComponentResource(SilverpeasContent contribution) {
        return this.componentResources.put(new ForeignPK(contribution.getId(), contribution.getComponentInstanceId()), contribution);
    }

    public Object removeComponentResource(String resourceId, String componentInstanceId) {
        return this.componentResources.remove(new ForeignPK(resourceId, componentInstanceId));
    }

    public void clear() {
        final VolatileResourceCacheService current = this;
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    current.deleteAllAttachments();
                }
                catch (Throwable throwable) {
                    SilverTrace.warn("cache", VolatileResourceCacheService.class.getName(), "The clear of volatile cache did not end successfully...");
                }
            }
        });
        try {
            thread.start();
        }
        catch (Throwable throwable) {
            SilverTrace.warn("cache", VolatileResourceCacheService.class.getName(), "The clear of volatile cache did not end successfully...");
        }
    }

    private void deleteAllAttachments() {
        for (Map.Entry<ForeignPK, Object> componentResource : this.componentResources.entrySet()) {
            AttachmentServiceFactory.getAttachmentService().deleteAllAttachments(componentResource.getKey().getId(), componentResource.getKey().getInstanceId());
        }
    }

    public static void clearFrom(SessionInfo sessionInfo) {
        VolatileResourceCacheService cache = sessionInfo.getCache().get(VolatileResourceCacheService.class.getName(), VolatileResourceCacheService.class);
        if (cache != null) {
            cache.clear();
        }
    }
}

