/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.date;

import com.silverpeas.calendar.DateTime;
import com.stratelia.webactiv.util.DateUtil;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EnumSet;
import java.util.Set;
import java.util.TimeZone;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.silverpeas.date.DayPeriod;
import org.silverpeas.date.MonthPeriod;
import org.silverpeas.date.PeriodType;
import org.silverpeas.date.UndefinedPeriod;
import org.silverpeas.date.WeekPeriod;
import org.silverpeas.date.YearPeriod;
import org.silverpeas.notification.message.MessageManager;
import org.silverpeas.util.time.TimeData;
import org.silverpeas.util.time.TimeUnit;

public class Period
implements Comparable,
Serializable,
Cloneable {
    private static final long serialVersionUID = 6378275537498456869L;
    private static final Set<PeriodType> knownPeriodTypes = EnumSet.allOf(PeriodType.class);
    public static final Period UNDEFINED;
    private PeriodType periodType = PeriodType.unknown;
    private DateTime beginDatable;
    private DateTime endDatable;

    public static Period check(Period period) {
        return period != null && period.isDefined() ? period : UNDEFINED;
    }

    public static Period getPeriodWithUndefinedIfNull(Date beginDate, Date endDate) {
        return Period.from(beginDate != null ? new DateTime(beginDate) : DateUtil.MINIMUM_DATE, endDate != null ? new DateTime(endDate) : DateUtil.MAXIMUM_DATE);
    }

    public static Period from(Date beginDate, Date endDate) {
        return Period.from(new DateTime(beginDate), new DateTime(endDate));
    }

    public static Period from(Date beginDate, Date endDate, TimeZone timeZone) {
        return Period.from(new DateTime(beginDate, timeZone), new DateTime(endDate, timeZone));
    }

    public static Period from(DateTime beginDatable, DateTime endDatable) {
        Period period = Period.check(new Period(beginDatable, endDatable));
        for (PeriodType periodToIdentify : knownPeriodTypes) {
            Period guessedPeriod = Period.from(beginDatable, periodToIdentify, MessageManager.getLanguage());
            if (!guessedPeriod.equals(period)) continue;
            return guessedPeriod;
        }
        return period;
    }

    public static Period from(Date referenceDate, PeriodType periodType) {
        return Period.from(referenceDate, periodType, MessageManager.getLanguage());
    }

    public static Period from(Date referenceDate, TimeZone timeZone, PeriodType periodType) {
        return Period.from(referenceDate, timeZone, periodType, MessageManager.getLanguage());
    }

    public static Period from(DateTime referenceDatable, PeriodType periodType) {
        return Period.from(referenceDatable.asDate(), periodType, MessageManager.getLanguage());
    }

    public static Period from(Date referenceDate, PeriodType periodType, String locale) {
        return Period.from(new DateTime(referenceDate), periodType, locale);
    }

    public static Period from(Date referenceDate, TimeZone timeZone, PeriodType periodType, String locale) {
        return Period.from(new DateTime(referenceDate, timeZone), periodType, locale);
    }

    public static Period from(DateTime referenceDatable, PeriodType periodType, String locale) {
        switch (periodType) {
            case year: {
                return new YearPeriod(referenceDatable);
            }
            case month: {
                return new MonthPeriod(referenceDatable);
            }
            case week: {
                return new WeekPeriod(referenceDatable, locale);
            }
        }
        return new DayPeriod(referenceDatable);
    }

    protected Period(DateTime beginDatable, DateTime endDatable) {
        this(beginDatable, endDatable, beginDatable.getTimeZone());
    }

    protected Period(DateTime beginDatable, DateTime endDatable, TimeZone timeZone) {
        this.beginDatable = beginDatable;
        this.endDatable = endDatable;
        this.inTimeZone(timeZone == null ? TimeZone.getDefault() : timeZone);
    }

    public boolean isDefined() {
        return this.getBeginDatable().isDefined() || this.getEndDatable().isDefined();
    }

    public boolean isNotDefined() {
        return !this.isDefined();
    }

    public Period inTimeZone(TimeZone timeZone) {
        this.beginDatable.inTimeZone(timeZone);
        this.endDatable.inTimeZone(timeZone);
        return this;
    }

    public TimeZone getTimeZone() {
        return this.beginDatable.getTimeZone();
    }

    public PeriodType getPeriodType() {
        return this.periodType;
    }

    protected void setPeriodType(PeriodType periodType) {
        this.periodType = periodType;
    }

    public Date getBeginDate() {
        return this.beginDatable.asDate();
    }

    public Date getEndDate() {
        return this.endDatable.asDate();
    }

    public DateTime getBeginDatable() {
        return this.beginDatable;
    }

    public boolean isBeginDefined() {
        return this.beginDatable.isDefined();
    }

    public boolean isBeginNotDefined() {
        return this.beginDatable.isNotDefined();
    }

    public DateTime getEndDatable() {
        return this.endDatable;
    }

    public boolean isEndDefined() {
        return this.endDatable.isDefined();
    }

    public boolean isEndNotDefined() {
        return this.endDatable.isNotDefined();
    }

    public void setDate(Date dateReference, PeriodType periodType) {
        this.setDate(new DateTime(dateReference), periodType);
    }

    public void setDate(Date dateReference, TimeZone timeZone, PeriodType periodType) {
        this.setDate(new DateTime(dateReference, timeZone), periodType);
    }

    public void setDate(DateTime referenceDatable, PeriodType periodType) {
        Period myReferencePeriod = Period.from(referenceDatable, periodType, MessageManager.getLanguage());
        this.beginDatable = myReferencePeriod.getBeginDatable();
        this.endDatable = myReferencePeriod.getEndDatable();
        this.periodType = myReferencePeriod.getPeriodType();
    }

    public void setDates(Date beginDate, Date endDate) {
        this.setDates(new DateTime(beginDate), new DateTime(endDate));
    }

    public void setDates(Date beginDate, Date endDate, TimeZone timeZone) {
        this.setDates(new DateTime(beginDate, timeZone), new DateTime(endDate, timeZone));
    }

    public void setDates(DateTime beginDatable, DateTime endDatable) {
        this.beginDatable = beginDatable;
        this.endDatable = endDatable;
        this.periodType = Period.from(beginDatable, endDatable).getPeriodType();
    }

    public TimeData getElapsedTimeData() {
        return this.beginDatable.getTimeDataTo(this.endDatable);
    }

    public TimeData getCoveredDaysTimeData() {
        return ((DateTime)this.beginDatable.getBeginOfDay()).getTimeDataTo(((DateTime)((DateTime)this.endDatable.addMilliseconds(-1)).getEndOfDay()).addMilliseconds(1));
    }

    public int compareTo(Object o) {
        return this.compareTo((Period)o);
    }

    public int compareTo(Period period) {
        return this.getBeginDate().compareTo(period.getBeginDate()) != 0 ? this.getBeginDate().compareTo(period.getBeginDate()) : this.getEndDate().compareTo(period.getEndDate());
    }

    public boolean isLongerThan(Period period) {
        long givenElapsedTime;
        long elapsedTime = this.getEndDate().getTime() - this.getBeginDate().getTime();
        return elapsedTime > (givenElapsedTime = period.getEndDate().getTime() - period.getBeginDate().getTime());
    }

    public boolean equals(Object o) {
        return o instanceof Period && this.getBeginDate().equals(((Period)o).getBeginDate()) && this.getEndDate().equals(((Period)o).getEndDate());
    }

    public int hashCode() {
        HashCodeBuilder hash = new HashCodeBuilder();
        hash.append((Object)this.getBeginDate());
        hash.append((Object)this.getEndDate());
        return hash.toHashCode();
    }

    public boolean isValid() {
        return this.isDefined() && this.getBeginDate() != null && this.getEndDate() != null && this.getBeginDate().compareTo(this.getEndDate()) <= 0;
    }

    public String toString() {
        return this.formatPeriodForTests();
    }

    protected String formatPeriodForTests() {
        StringBuilder sb = new StringBuilder("Period(");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        if (this.getBeginDate() != null) {
            sb.append(sdf.format(this.getBeginDate()));
        } else {
            sb.append("NA");
        }
        sb.append(", ");
        if (this.getEndDate() != null) {
            sb.append(sdf.format(this.getEndDate()));
        } else {
            sb.append("NA");
        }
        sb.append(") -> elapsed time ");
        sb.append(this.getElapsedTimeData().getFormattedValueOnly(TimeUnit.DAY));
        sb.append(" day(s), covered time ");
        sb.append(this.getCoveredDaysTimeData().getFormattedValueOnly(TimeUnit.DAY));
        sb.append(" day(s), ");
        sb.append(this.getPeriodType().name());
        sb.append(" type, ");
        sb.append(this.isValid() ? "is valid" : "is not valid");
        return sb.toString();
    }

    public boolean contains(Date date) {
        return DateUtil.compareTo(this.getBeginDate(), date, false) <= 0 && DateUtil.compareTo(this.getEndDate(), date, false) >= 0;
    }

    public boolean contains(Period period) {
        return DateUtil.compareTo(this.getBeginDate(), period.getBeginDate()) <= 0 && DateUtil.compareTo(this.getEndDate(), period.getEndDate()) >= 0;
    }

    public boolean containsPartOf(Period period) {
        return DateUtil.compareTo(this.getBeginDate(), period.getEndDate()) <= 0 && DateUtil.compareTo(this.getEndDate(), period.getBeginDate()) >= 0;
    }

    public Period clone() {
        try {
            return (Period)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        knownPeriodTypes.remove((Object)PeriodType.unknown);
        UNDEFINED = new UndefinedPeriod();
    }
}

