/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.dateReminder;

import com.silverpeas.scheduler.Scheduler;
import com.silverpeas.scheduler.SchedulerEvent;
import com.silverpeas.scheduler.SchedulerEventListener;
import com.silverpeas.scheduler.SchedulerFactory;
import com.silverpeas.scheduler.trigger.JobTrigger;
import com.stratelia.silverpeas.notificationManager.NotificationManagerException;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.util.ResourceLocator;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.inject.Named;
import org.silverpeas.EntityReference;
import org.silverpeas.dateReminder.exception.DateReminderException;
import org.silverpeas.dateReminder.persistent.DateReminderDetail;
import org.silverpeas.dateReminder.persistent.PersistentResourceDateReminder;
import org.silverpeas.dateReminder.persistent.service.DateReminderServiceFactory;
import org.silverpeas.dateReminder.provider.DateReminderProcess;
import org.silverpeas.dateReminder.provider.DateReminderProcessRegistration;

@Named
public class DateReminderScheduler
implements SchedulerEventListener {
    public static final String DATEREMINDER_JOB_NAME_PROCESS = "A_ProcessDateReminder";

    @PostConstruct
    public void initialize() {
        try {
            ResourceLocator resources = new ResourceLocator("org.silverpeas.dateReminder.settings.dateReminderSettings", "");
            String cron = resources.getString("cronScheduledDateReminder");
            Logger.getLogger(this.getClass().getSimpleName()).log(Level.INFO, "Date reminder Processor scheduled with cron ''{0}''", cron);
            SchedulerFactory schedulerFactory = SchedulerFactory.getFactory();
            Scheduler scheduler = schedulerFactory.getScheduler();
            scheduler.unscheduleJob(DATEREMINDER_JOB_NAME_PROCESS);
            JobTrigger trigger = JobTrigger.triggerAt(cron);
            scheduler.scheduleJob(DATEREMINDER_JOB_NAME_PROCESS, trigger, (SchedulerEventListener)this);
        }
        catch (Exception e) {
            SilverTrace.error("dateReminder", "ScheduledDateReminderService.initialize()", "dateReminder.EX_CANT_INIT_SCHEDULED_DATEREMINDER", e);
        }
    }

    public void doScheduledDateReminder() throws DateReminderException {
        SilverTrace.info("dateReminder", "ScheduledDateReminderService.doScheduledDateReminder()", "root.MSG_GEN_ENTER_METHOD");
        Calendar calendar = Calendar.getInstance(Locale.FRENCH);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date deadLine = calendar.getTime();
        SilverTrace.info("dateReminder", "ScheduledDateReminderService.doScheduledDateReminder()", "root.MSG_GEN_PARAM_VALUE", "deadLine = " + deadLine.toString());
        Collection<PersistentResourceDateReminder> listResourceDateReminder = DateReminderServiceFactory.getDateReminderService().listAllDateReminderMaturing(deadLine);
        SilverTrace.info("dateReminder", "ScheduledDateReminderService.doScheduledDateReminder()", "root.MSG_GEN_PARAM_VALUE", "ResourceDateReminder = " + listResourceDateReminder.size());
        boolean performed = false;
        EntityReference entityReference = null;
        for (PersistentResourceDateReminder resourceDateReminder : listResourceDateReminder) {
            performed = false;
            for (DateReminderProcess dateReminderProcess : DateReminderProcessRegistration.getProcesses(resourceDateReminder)) {
                performed = false;
                try {
                    entityReference = dateReminderProcess.perform(resourceDateReminder);
                    performed = true;
                }
                catch (NotificationManagerException e) {
                    SilverTrace.error("dateReminder", "ScheduledDateReminderService.doScheduledDateReminder()", "dateReminder.EX_ERROR_WHILE_PERFORMING_DATEREMINDER", "Type = " + resourceDateReminder.getResourceType() + ", ResourceId = " + resourceDateReminder.getId());
                    performed = false;
                }
                if (!performed) continue;
                DateReminderDetail dateReminderDetail = resourceDateReminder.getDateReminder();
                dateReminderDetail.setProcessStatus(1);
                DateReminderServiceFactory.getDateReminderService().set(entityReference, dateReminderDetail);
            }
        }
        SilverTrace.info("dateReminder", "ScheduledDateReminderService.doScheduledDateReminder()", "root.MSG_GEN_EXIT_METHOD");
    }

    @Override
    public void triggerFired(SchedulerEvent anEvent) throws Exception {
        SilverTrace.debug("dateReminder", "ScheduledDateReminderService.triggerFired", "The job '" + anEvent.getJobExecutionContext().getJobName() + "' is executed");
        this.doScheduledDateReminder();
    }

    @Override
    public void jobSucceeded(SchedulerEvent anEvent) {
        SilverTrace.debug("dateReminder", "ScheduledDateReminderService.jobSucceeded", "The job '" + anEvent.getJobExecutionContext().getJobName() + "' was successful");
    }

    @Override
    public void jobFailed(SchedulerEvent anEvent) {
        SilverTrace.error("dateReminder", "ScheduledDateReminderService.jobFailed", "The job '" + anEvent.getJobExecutionContext().getJobName() + "' failed");
    }
}

