/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.dateReminder.persistent;

import com.silverpeas.util.StringUtil;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.silverpeas.EntityReference;
import org.silverpeas.dateReminder.exception.DateReminderValidationException;
import org.silverpeas.dateReminder.persistent.DateReminderDetail;
import org.silverpeas.persistence.model.identifier.UuidIdentifier;
import org.silverpeas.persistence.model.jpa.AbstractJpaEntity;

@Entity
@Table(name="st_dateReminder")
@NamedQueries(value={@NamedQuery(name="getResource", query="from PersistentResourceDateReminder where resourceType = :type and resourceId = :resourceId"), @NamedQuery(name="getListResourceByDeadLine", query="from PersistentResourceDateReminder where processStatus = 0 and dateReminder <= :dateReminder")})
public class PersistentResourceDateReminder
extends AbstractJpaEntity<PersistentResourceDateReminder, UuidIdentifier> {
    private static final long serialVersionUID = 5956074363457906409L;
    public static final PersistentResourceDateReminder NONEDATEREMINDER = new PersistentResourceDateReminder();
    @Column(name="resourceType", nullable=false)
    private String resourceType = "UNKNOWN";
    @Column(name="resourceId", nullable=false)
    private String resourceId;
    @Column(name="dateReminder", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dateReminder;
    @Column(name="message")
    private String message;
    @Column(name="processStatus")
    private int processStatus;

    public boolean exists() {
        return this.getId() != null;
    }

    public boolean notExists() {
        return this.getId() == null;
    }

    public void validate() throws DateReminderValidationException {
        if (this.resourceType == null || "UNKNOWN".equals(this.resourceType) || !StringUtil.isDefined(this.resourceId)) {
            throw new DateReminderValidationException("The dateReminder isn't valid! Missing resource reference");
        }
        if (this.dateReminder == null) {
            throw new DateReminderValidationException("The dateReminder isn't valid! Missing the date");
        }
    }

    public <E, R extends EntityReference<E>> R getResource(Class<R> referenceClass) {
        EntityReference ref = null;
        if (this.resourceType != null && !this.resourceType.equals("UNKNOWN") && StringUtil.isDefined(this.resourceId)) {
            try {
                ref = (EntityReference)referenceClass.getConstructor(String.class).newInstance(this.resourceId);
                if (!ref.getType().equals(this.resourceType)) {
                    ref = null;
                }
            }
            catch (Exception ex) {
                Logger.getLogger(PersistentResourceDateReminder.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return (R)ref;
    }

    public void setResource(EntityReference resource) {
        if (resource != null) {
            this.resourceType = resource.getType();
            this.resourceId = resource.getId();
        }
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public DateReminderDetail getDateReminder() {
        return new DateReminderDetail(this.dateReminder, this.message, this.processStatus, this.getCreatedBy(), this.getLastUpdatedBy());
    }

    private void setCreatorId(String userId) {
        super.setCreatedBy(userId);
    }

    private void setUpdaterId(String userId) {
        super.setLastUpdatedBy(userId);
    }

    public void setDateReminder(DateReminderDetail dateReminder) {
        if (dateReminder != null) {
            this.dateReminder = dateReminder.getDateReminder();
            this.message = dateReminder.getMessage();
            this.processStatus = dateReminder.getProcessStatus();
            this.setCreatorId(dateReminder.getCreatorId());
            this.setUpdaterId(dateReminder.getUpdaterId());
        }
    }

    public boolean isDefined() {
        return this.isPersisted() && this != NONEDATEREMINDER;
    }

    public String toString() {
        return "PersistentResourceDateReminder{resourceType='" + this.resourceType + '\'' + ", resourceId='" + this.resourceId + '\'' + ", dateReminder ='" + this.dateReminder + '\'' + ", message ='" + this.message + '\'' + '}';
    }
}

