/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.dateReminder.provider;

import com.silverpeas.util.MapUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.silverpeas.EntityReference;
import org.silverpeas.dateReminder.persistent.PersistentResourceDateReminder;
import org.silverpeas.dateReminder.provider.DateReminderProcess;

public class DateReminderProcessRegistration {
    private static final Map<String, List<DateReminderProcess>> processes = new HashMap<String, List<DateReminderProcess>>();

    public static synchronized void register(Class resourceType, DateReminderProcess process) {
        MapUtil.putAddList(processes, EntityReference.getType(resourceType), process);
    }

    public static synchronized void unregister(Class resourceType, DateReminderProcess process) {
        MapUtil.removeValueList(processes, EntityReference.getType(resourceType), process);
    }

    public static List<DateReminderProcess> getProcesses(PersistentResourceDateReminder dateReminder) {
        ArrayList processesOfType = processes.get(dateReminder.getResourceType());
        return processesOfType != null ? processesOfType : new ArrayList(0);
    }
}

