/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.image.imagemagick;

import com.silverpeas.util.StringUtil;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Named;
import javax.inject.Singleton;
import org.im4java.core.ConvertCmd;
import org.im4java.core.IMOperation;
import org.im4java.core.Operation;
import org.im4java.process.ProcessStarter;

@Named(value="im4javaManager")
@Singleton
public class Im4javaManager {
    @PostConstruct
    public void initialize() throws Exception {
        if (!this.verify(ProcessStarter.getGlobalSearchPath())) {
            for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
                if (!"path".equals(entry.getKey().toLowerCase())) continue;
                this.verify(entry.getValue());
                break;
            }
        }
    }

    private boolean verify(String path) {
        boolean verified = true;
        if (path == null) {
            path = "";
        }
        try {
            ConvertCmd cmd = new ConvertCmd();
            cmd.setSearchPath(path);
            cmd.run((Operation)new IMOperation().version(), new Object[0]);
            ProcessStarter.setGlobalSearchPath((String)path);
        }
        catch (Exception e) {
            ProcessStarter.setGlobalSearchPath(null);
            verified = false;
        }
        return verified;
    }

    public static boolean isActivated() {
        return StringUtil.isDefined(ProcessStarter.getGlobalSearchPath());
    }
}

