/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.importExport.attachment;

import com.silverpeas.form.importExport.XMLModelContentType;
import com.silverpeas.util.FileUtil;
import com.silverpeas.util.MimeTypes;
import com.silverpeas.util.StringUtil;
import com.silverpeas.util.i18n.AbstractBean;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.util.FileRepositoryManager;
import com.stratelia.webactiv.util.WAPrimaryKey;
import java.io.File;
import java.io.Serializable;
import java.util.Date;
import org.apache.commons.io.FilenameUtils;
import org.silverpeas.importExport.attachment.AttachmentPK;

public final class AttachmentDetail
extends AbstractBean
implements Serializable,
MimeTypes,
Cloneable {
    private static final long serialVersionUID = 5441809463555598057L;
    public static final String ATTACHMENTS_FOLDER = "attachments";
    public static final transient int GROUP_FILE = 0;
    public static final transient int GROUP_FILE_LINK = 1;
    public static final transient int GROUP_HTML_LINK = 2;
    public static final transient int GROUP_DIR = 3;
    public static final transient int GROUP_DUMMY = 4;
    private AttachmentPK pk = null;
    private String physicalName = null;
    private String type = null;
    private Date creationDate;
    private long size;
    private String context = null;
    private WAPrimaryKey foreignKey = null;
    private String author = null;
    private String title = null;
    private String info = null;
    private int orderNum;
    private String instanceId = null;
    private String workerId = null;
    private String cloneId = null;
    public static final String IMPORT_UPDATE_RULE_ADD = "add";
    public static final String IMPORT_UPDATE_RULE_REPLACE = "replace";
    private String importUpdateRule = "add";
    private boolean removeAfterImport = false;
    private String originalPath;
    private Date reservationDate = null;
    private Date alertDate = null;
    private Date expiryDate = null;
    private String xmlForm = null;
    private XMLModelContentType xmlModelContentType = null;

    public String getCloneId() {
        return this.cloneId;
    }

    public void setCloneId(String cloneId) {
        this.cloneId = cloneId;
    }

    public AttachmentDetail() {
    }

    public AttachmentDetail(WAPrimaryKey foreignKey) {
        SilverTrace.info("attachment", "Contructor AttachmentDetail(WAPrimaryKey foreignKey)", "root.MSG_GEN_PARAM_VALUE", "foreignKey = " + foreignKey.toString());
        this.foreignKey = foreignKey;
    }

    public AttachmentDetail(AttachmentPK attachPK, String physicalName, String logicalName, String description, String type, long size, String context, Date creationDate, WAPrimaryKey foreignKey, String author) {
        this.pk = attachPK;
        if (this.pk == null) {
            SilverTrace.info("attachment", "Contructor with author", "root.MSG_GEN_PARAM_VALUE", "pk = null !");
        } else {
            SilverTrace.info("attachment", "Contructor with author", "root.MSG_GEN_PARAM_VALUE", "pk = " + this.pk.toString());
        }
        this.physicalName = physicalName;
        this.setLogicalName(logicalName);
        this.setDescription(description);
        this.type = type;
        this.checkMimeType();
        this.size = size;
        this.setContext(context);
        this.creationDate = creationDate;
        this.foreignKey = foreignKey;
        this.author = author;
    }

    public AttachmentDetail(AttachmentPK attachPK, String physicalName, String logicalName, String description, String type, long size, String context, Date creationDate, WAPrimaryKey foreignKey) {
        this.pk = attachPK;
        SilverTrace.info("attachment", "Contructor without author and without title", "root.MSG_GEN_PARAM_VALUE", "pk = " + this.pk.toString());
        this.physicalName = physicalName;
        this.setLogicalName(logicalName);
        this.setDescription(description);
        this.type = type;
        this.checkMimeType();
        this.size = size;
        this.setContext(context);
        this.creationDate = creationDate;
        this.foreignKey = foreignKey;
    }

    public AttachmentDetail(AttachmentPK attachPK, String physicalName, String logicalName, String description, String type, long size, String context, Date creationDate, WAPrimaryKey foreignKey, String title, String info, int orderNum) {
        this.pk = attachPK;
        SilverTrace.info("attachment", "Contructor without author but with title", "root.MSG_GEN_PARAM_VALUE", "pk = " + this.pk.toString());
        this.physicalName = physicalName;
        this.setLogicalName(logicalName);
        this.setDescription(description);
        this.type = type;
        this.checkMimeType();
        this.size = size;
        this.setContext(context);
        this.creationDate = creationDate;
        this.foreignKey = foreignKey;
        this.title = title;
        this.info = info;
        this.orderNum = orderNum;
    }

    public AttachmentDetail(AttachmentPK attachPK, String physicalName, String logicalName, String description, String type, long size, String context, Date creationDate, WAPrimaryKey foreignKey, String author, String title) {
        this.pk = attachPK;
        if (this.pk == null) {
            SilverTrace.info("attachment", "Contructor with author and title", "root.MSG_GEN_PARAM_VALUE", "pk = null !");
        } else {
            SilverTrace.info("attachment", "Contructor with author an title", "root.MSG_GEN_PARAM_VALUE", "pk = " + this.pk.toString());
        }
        this.physicalName = physicalName;
        this.setLogicalName(logicalName);
        this.setDescription(description);
        this.type = type;
        this.checkMimeType();
        this.size = size;
        this.setContext(context);
        this.creationDate = creationDate;
        this.foreignKey = foreignKey;
        this.author = author;
        this.title = title;
    }

    public AttachmentDetail(AttachmentPK attachPK) {
        this.pk = attachPK;
        SilverTrace.info("attachment", "Contructor AttachmentDetail(AttachmentPK attachPK)", "root.MSG_GEN_PARAM_VALUE", "pk = " + this.pk.toString());
    }

    public AttachmentPK getPK() {
        return this.pk;
    }

    public void setPK(AttachmentPK pk) {
        this.pk = pk;
        if (pk == null) {
            SilverTrace.info("attachment", "AttachmentDetail.setPK()", "root.MSG_GEN_PARAM_VALUE", "pk is null !");
        } else {
            this.instanceId = pk.getInstanceId();
            SilverTrace.info("attachment", "AttachmentDetail.setPK()", "root.MSG_GEN_PARAM_VALUE", "pk is not null = " + pk.toString());
        }
    }

    public String getPhysicalName() {
        return this.physicalName;
    }

    public void setPhysicalName(String physicalName) {
        this.physicalName = physicalName;
    }

    public String getLogicalName() {
        return this.getName();
    }

    public void setLogicalName(String logicalName) {
        SilverTrace.info("attachment", "AttachmentDetail.setLogicalName()", "root.MSG_GEN_PARAM_VALUE", "logicalName = " + logicalName);
        this.setName(logicalName);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
        this.checkMimeType();
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public void setContext(String context) {
        this.context = context != null && !context.equals("null") && context.length() > 0 ? context : null;
    }

    public String getContext() {
        return this.context;
    }

    public void setForeignKey(WAPrimaryKey foreignKey) {
        this.foreignKey = foreignKey;
        this.instanceId = foreignKey.getInstanceId();
    }

    public WAPrimaryKey getForeignKey() {
        return this.foreignKey;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public void setInfo(String info) {
        this.info = info;
    }

    public String getInfo() {
        return this.info;
    }

    public void setOrderNum(int orderNum) {
        this.orderNum = orderNum;
    }

    public int getOrderNum() {
        return this.orderNum;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setWorkerId(String workerId) {
        this.workerId = workerId;
    }

    public String getWorkerId() {
        return this.workerId;
    }

    public int getAttachmentGroup() {
        int valret = 0;
        if (this.getDescription() != null) {
            if (this.getDescription().startsWith("link")) {
                valret = 1;
            } else if (this.getDescription().startsWith("html")) {
                valret = 2;
            } else if (this.getDescription().startsWith("dir")) {
                valret = 3;
            } else if (this.getDescription().startsWith("dummy")) {
                valret = 4;
            }
        }
        return valret;
    }

    protected String getLanguage(String language) {
        if (language != null && ("fr".equalsIgnoreCase(language) || "".equals(language.trim()))) {
            return null;
        }
        return language;
    }

    public String getAttachmentPath() {
        if (this.isPhysicalPathAbsolute()) {
            return this.physicalName.replace('/', File.separatorChar);
        }
        String directory = FileRepositoryManager.getAbsolutePath(this.getInstanceId(), FileRepositoryManager.getAttachmentContext(this.getContext()));
        if (!directory.endsWith(File.separator)) {
            directory = directory + File.separatorChar;
        }
        directory = directory.replace('/', File.separatorChar);
        return directory + this.getPhysicalName();
    }

    private boolean isPhysicalPathAbsolute() {
        String filePath = FilenameUtils.separatorsToSystem((String)this.physicalName);
        File file = new File(filePath);
        return file.exists() && file.isFile();
    }

    public boolean isOpenOfficeCompatible() {
        return FileUtil.isOpenOfficeCompatible(this.getLogicalName());
    }

    @Deprecated
    public boolean isOfficeDocument() {
        return this.isOpenOfficeCompatible();
    }

    public boolean isSpinfireDocument() {
        boolean isSpinfireDocument = false;
        if (this.getType() != null) {
            SilverTrace.info("attachment", "AttachmentDetail.isSpinfireDocument()", "root.MSG_GEN_PARAM_VALUE", "isSpinfireDocument = " + this.getType().equals("application/xview3d-3d"));
            isSpinfireDocument = this.getType().equals("application/xview3d-3d");
        }
        return isSpinfireDocument;
    }

    public String getExtension() {
        return FileRepositoryManager.getFileExtension(this.getLogicalName());
    }

    public Object clone() {
        AttachmentDetail clone = new AttachmentDetail();
        clone.setAuthor(this.author);
        clone.setCloneId(this.cloneId);
        clone.setContext(this.context);
        clone.setCreationDate(this.creationDate);
        clone.setDescription(this.getDescription());
        clone.setForeignKey(this.foreignKey);
        clone.setInfo(this.info);
        clone.setInstanceId(this.instanceId);
        clone.setLogicalName(this.getLogicalName());
        clone.setOrderNum(this.orderNum);
        clone.setPhysicalName(this.physicalName);
        clone.setPK(this.pk);
        clone.setSize(this.size);
        clone.setTitle(this.title);
        clone.setType(this.type);
        clone.setWorkerId(this.workerId);
        return clone;
    }

    public int hashCode() {
        int hash = 5;
        hash = 89 * hash + (this.pk != null ? this.pk.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object arg0) {
        if (arg0 == null) {
            return false;
        }
        if (arg0 instanceof AttachmentDetail) {
            AttachmentDetail a2 = (AttachmentDetail)arg0;
            return a2.getPK().getId().equals(this.getPK().getId());
        }
        return false;
    }

    public String getImportUpdateRule() {
        return this.importUpdateRule;
    }

    public void setImportUpdateRule(String updateRule) {
        this.importUpdateRule = updateRule;
    }

    public void checkMimeType() {
        if (this.getLogicalName() != null && (!StringUtil.isDefined(this.type) || "application/octet-stream".equalsIgnoreCase(this.type))) {
            this.type = FileUtil.getMimeType(this.getLogicalName());
        }
    }

    public String getXmlForm() {
        return this.xmlForm;
    }

    public void setXmlForm(String xmlForm) {
        this.xmlForm = xmlForm;
    }

    public XMLModelContentType getXMLModelContentType() {
        return this.xmlModelContentType;
    }

    public boolean isRemoveAfterImport() {
        return this.removeAfterImport;
    }

    public void setRemoveAfterImport(boolean removeAfterImport) {
        this.removeAfterImport = removeAfterImport;
    }

    public void setOriginalPath(String originalPath) {
        this.originalPath = originalPath;
    }

    public String getOriginalPath() {
        return this.originalPath;
    }
}

