/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.importExport.versioning;

import com.silverpeas.form.importExport.XMLModelContentType;
import com.silverpeas.jcrutil.converter.ConverterUtil;
import com.silverpeas.util.FileUtil;
import com.silverpeas.util.MimeTypes;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.util.FileRepositoryManager;
import com.stratelia.webactiv.util.GeneralPropertiesManager;
import com.stratelia.webactiv.util.ResourceLocator;
import java.io.File;
import java.io.Serializable;
import java.util.Date;
import org.apache.commons.io.FilenameUtils;
import org.silverpeas.importExport.attachment.AttachmentDetail;
import org.silverpeas.importExport.versioning.DocumentPK;
import org.silverpeas.importExport.versioning.DocumentVersionPK;

public class DocumentVersion
implements Serializable,
Cloneable,
MimeTypes {
    private static final long serialVersionUID = 1L;
    public static final int STATUS_VALIDATION_NOT_REQ = 0;
    public static final int STATUS_VALIDATION_REQUIRED = 1;
    public static final int STATUS_VERSION_VALIDATED = 2;
    public static final int STATUS_VERSION_REFUSED = 3;
    public static final int TYPE_DEFAULT_VERSION = 1;
    public static final int TYPE_PUBLIC_VERSION = 0;
    public static final String CONTEXT = "Versioning";
    public static final String CONTEXT_VERSIONING = "Versioning" + File.separator;
    private DocumentVersionPK pk;
    private DocumentPK documentPK;
    private int majorNumber;
    private int minorNumber;
    private int authorId;
    private Date creationDate;
    private String comments;
    private int type = 1;
    private int status = 0;
    private String physicalName;
    private String logicalName;
    private String mimeType;
    private long size;
    private String instanceId;
    private String xmlForm = null;
    private String creatorName;
    private XMLModelContentType xmlModelContentType = null;
    private boolean removeAfterImport = false;
    private String originalPath;

    public DocumentVersion() {
    }

    public DocumentVersion(DocumentVersionPK pk, DocumentPK documentPK, int majorNumber, int minorNumber, int authorId, Date creationDate, String comments, int type, int status, String physicalName, String logicalName, String mimeType, long size, String instanceId) {
        this.pk = pk;
        this.documentPK = documentPK;
        this.majorNumber = majorNumber;
        this.minorNumber = minorNumber;
        this.authorId = authorId;
        this.creationDate = creationDate;
        this.comments = comments;
        this.type = type;
        this.status = status;
        this.physicalName = physicalName;
        this.logicalName = logicalName;
        this.mimeType = mimeType;
        this.size = size;
        this.instanceId = instanceId;
    }

    public DocumentVersion(AttachmentDetail attachment) {
        this.creationDate = attachment.getCreationDate();
        this.physicalName = attachment.getPhysicalName();
        this.logicalName = attachment.getLogicalName();
        this.mimeType = attachment.getType();
        this.size = attachment.getSize();
        this.instanceId = attachment.getPK().getInstanceId();
    }

    public DocumentVersionPK getPk() {
        return this.pk;
    }

    public void setPk(DocumentVersionPK pk) {
        this.pk = pk;
    }

    public DocumentPK getDocumentPK() {
        return this.documentPK;
    }

    public void setDocumentPK(DocumentPK documentPK) {
        this.documentPK = documentPK;
    }

    public int getMajorNumber() {
        return this.majorNumber;
    }

    public void setMajorNumber(int majorNumber) {
        this.majorNumber = majorNumber;
    }

    public int getMinorNumber() {
        return this.minorNumber;
    }

    public void setMinorNumber(int minorNumber) {
        this.minorNumber = minorNumber;
    }

    public int getAuthorId() {
        return this.authorId;
    }

    public void setAuthorId(int authorId) {
        this.authorId = authorId;
    }

    public Date getCreationDate() {
        if (this.creationDate != null) {
            return new Date(this.creationDate.getTime());
        }
        return null;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = new Date(creationDate.getTime());
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getPhysicalName() {
        return this.physicalName;
    }

    public void setPhysicalName(String physicalName) {
        this.physicalName = physicalName;
    }

    public String getLogicalName() {
        return this.logicalName;
    }

    public void setLogicalName(String logicalName) {
        this.logicalName = logicalName;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public long getSize() {
        return this.size;
    }

    public String getDisplaySize() {
        return FileRepositoryManager.formatFileSize(this.getSize());
    }

    public void setSize(long size) {
        this.size = size;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    @Deprecated
    public boolean isOfficeDocument() {
        return this.isOpenOfficeCompatibleDocument();
    }

    public String getJcrPath() {
        StringBuilder jcrPath = new StringBuilder(500);
        jcrPath.append(this.getInstanceId()).append('/');
        jcrPath.append(CONTEXT).append('/');
        if (this.getDocumentPK().getId() != null) {
            jcrPath.append(this.getDocumentPK().getId()).append('/');
        }
        jcrPath.append(this.majorNumber).append(".").append(this.minorNumber).append('/');
        jcrPath.append(ConverterUtil.escapeIllegalJcrChars(this.getLogicalName()));
        return jcrPath.toString();
    }

    public String getWebdavUrl() {
        StringBuilder url = new StringBuilder(500);
        ResourceLocator messages = GeneralPropertiesManager.getGeneralResourceLocator();
        String webAppContext = messages.getString("ApplicationURL");
        if (!webAppContext.endsWith("/")) {
            webAppContext = webAppContext + '/';
        }
        url.append(webAppContext).append(messages.getString("webdav.respository")).append('/').append(messages.getString("webdav.workspace")).append('/').append(this.getJcrPath());
        return url.toString();
    }

    public boolean isSpinfireDocument() {
        SilverTrace.info("versioning", "DocumentVersion.isSpinfireDocument()", "root.MSG_GEN_PARAM_VALUE", "isSpinfireDocument = " + "application/xview3d-3d".equals(this.getMimeType()));
        return "application/xview3d-3d".equals(this.getMimeType());
    }

    public boolean isOpenOfficeCompatibleDocument() {
        boolean isOpenOfficeCompatibleDocument = false;
        if (this.getLogicalName() != null) {
            isOpenOfficeCompatibleDocument = FileUtil.isOpenOfficeCompatible(this.getLogicalName());
            SilverTrace.info("versioning", "DocumentVersion.isSpinfireDocument()", "root.MSG_GEN_PARAM_VALUE", "isOpenOfficeCompatibleDocument = " + isOpenOfficeCompatibleDocument);
        }
        return isOpenOfficeCompatibleDocument;
    }

    public String toString() {
        return "DocumentVersion object : [  pk = " + this.pk + ", documentPK = " + this.documentPK + ", majorNumber = " + this.majorNumber + ", minorNumber = " + this.minorNumber + ", authorId = " + this.authorId + ", creationDate = " + this.creationDate + ", comments = " + this.comments + ", type = " + this.type + ", status = " + this.status + ", physicalName = " + this.physicalName + ", logicalName = " + this.logicalName + ", mimeType = " + this.mimeType + ", size = " + this.size + " ];";
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public String getDocumentPath() {
        if (this.isPhysicalPathAbsolute()) {
            return FilenameUtils.separatorsToSystem((String)this.physicalName);
        }
        String directory = FileRepositoryManager.getAbsolutePath(this.getInstanceId(), new String[]{CONTEXT});
        if (!(directory = FilenameUtils.separatorsToSystem((String)directory)).endsWith(File.separator)) {
            directory = directory + File.separator;
        }
        return directory + this.getPhysicalName();
    }

    private boolean isPhysicalPathAbsolute() {
        String filePath = FilenameUtils.separatorsToSystem((String)this.physicalName);
        File file = new File(filePath);
        return file.exists() && file.isFile();
    }

    public String getCreatorName() {
        return this.creatorName;
    }

    public void setCreatorName(String creatorName) {
        this.creatorName = creatorName;
    }

    public String getXmlForm() {
        return this.xmlForm;
    }

    public void setXmlForm(String xmlForm) {
        this.xmlForm = xmlForm;
    }

    public XMLModelContentType getXMLModelContentType() {
        return this.xmlModelContentType;
    }

    public void setXMLModelContentType(XMLModelContentType xmlModelContentType) {
        this.xmlModelContentType = xmlModelContentType;
    }

    public String getDocumentIcon() {
        String icon = "";
        if (this.getPhysicalName().lastIndexOf(46) >= 0) {
            String fileType = FileRepositoryManager.getFileExtension(this.getPhysicalName());
            icon = FileRepositoryManager.getFileIcon(fileType);
        } else {
            icon = FileRepositoryManager.getFileIcon("");
        }
        return icon;
    }

    public boolean isRemoveAfterImport() {
        return this.removeAfterImport;
    }

    public void setRemoveAfterImport(boolean removeAfterImport) {
        this.removeAfterImport = removeAfterImport;
    }

    public void setOriginalPath(String originalPath) {
        this.originalPath = originalPath;
    }

    public String getOriginalPath() {
        return this.originalPath;
    }
}

