/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.mail;

import com.silverpeas.util.MailUtil;
import com.silverpeas.util.StringUtil;
import java.io.UnsupportedEncodingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;

public class MailAddress {
    private String email = "";
    private String name = "";

    public static MailAddress eMail(String email) {
        MailAddress mailAddress = new MailAddress();
        if (StringUtil.isDefined(email)) {
            mailAddress.email = email;
        }
        return mailAddress;
    }

    private MailAddress() {
    }

    public MailAddress withName(String name) {
        this.name = StringUtil.defaultStringIfNotDefined(name);
        return this;
    }

    public String getEmail() {
        return this.email;
    }

    public String getName() {
        return this.name;
    }

    public InternetAddress getAuthorizedInternetAddress() throws UnsupportedEncodingException, AddressException {
        return MailUtil.getAuthorizedEmailAddress(this.getEmail(), this.getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MailAddress that = (MailAddress)o;
        return this.email.equals(that.email) && this.name.equals(that.name);
    }

    public int hashCode() {
        int result = this.email.hashCode();
        result = 31 * result + this.name.hashCode();
        return result;
    }
}

