/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.notification.jsondiff;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.silverpeas.notification.jsondiff.Op;
import org.silverpeas.notification.jsondiff.Operation;

public class JsonPatch
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final ObjectMapper mapper = new ObjectMapper();
    private Map<String, Operation> operations = new LinkedHashMap<String, Operation>(5);

    public List<Operation> getOperations() {
        return new ArrayList<Operation>(this.operations.values());
    }

    public Operation getOperationByPath(String path) {
        return this.operations.get(path);
    }

    public void addOperation(Operation operation) {
        if (operation.getOp() != Op.none) {
            this.operations.put(operation.getPath(), operation);
        }
    }

    public void setOperations(List<Operation> operations) {
        this.operations.clear();
        if (operations != null) {
            for (Operation operation : operations) {
                this.addOperation(operation);
            }
        }
    }

    public String toJson() throws IOException {
        return mapper.writeValueAsString(this.getOperations());
    }

    public void fromJson(String json) throws IOException {
        this.setOperations((List)mapper.readValue(json, (TypeReference)new TypeReference<List<Operation>>(){}));
    }
}

