/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.password.service;

import com.stratelia.webactiv.util.ResourceLocator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.silverpeas.password.rule.PasswordRule;

public class PasswordCheck {
    protected static ResourceLocator settings = new ResourceLocator("org.silverpeas.password.settings.password", "");
    private static final Map<String, ResourceLocator> multilang = new HashMap<String, ResourceLocator>();
    private Collection<PasswordRule> requiredRulesInError = new ArrayList<PasswordRule>();
    private Collection<PasswordRule> combinedRules = new ArrayList<PasswordRule>();
    private Collection<PasswordRule> combinedRulesInError = new ArrayList<PasswordRule>();
    private int nbMatchingCombinedRules;
    private int nbCombinedErrorsAuthorized;

    PasswordCheck(Collection<PasswordRule> combinedRules, int nbMatchingCombinedRules) {
        this.combinedRules = combinedRules;
        this.nbMatchingCombinedRules = nbMatchingCombinedRules;
        this.nbCombinedErrorsAuthorized = combinedRules.size() - nbMatchingCombinedRules;
    }

    void addRequiredError(PasswordRule rule) {
        this.requiredRulesInError.add(rule);
    }

    void addCombinedError(PasswordRule rule) {
        this.combinedRulesInError.add(rule);
    }

    public Collection<PasswordRule> getRequiredRulesInError() {
        return this.requiredRulesInError;
    }

    public Collection<PasswordRule> getCombinedRulesInError() {
        return this.combinedRulesInError;
    }

    public boolean isCorrect() {
        return this.requiredRulesInError.isEmpty() && this.isRuleCombinationRespected();
    }

    public boolean isRuleCombinationRespected() {
        return this.combinedRulesInError.isEmpty() || this.combinedRulesInError.size() <= this.nbCombinedErrorsAuthorized;
    }

    public String getFormattedErrorMessage(String language) {
        StringBuilder errorMessage = new StringBuilder();
        if (!this.requiredRulesInError.isEmpty()) {
            errorMessage.append(this.getString("password.checking.error.message", language, this.getFormattedPasswordListMessage(this.requiredRulesInError, language)));
        }
        if (!this.combinedRulesInError.isEmpty()) {
            if (errorMessage.length() > 0) {
                errorMessage.append(". ");
            }
            errorMessage.append(this.getString("password.checking.combined.error.message", language, String.valueOf(this.nbMatchingCombinedRules), this.getFormattedPasswordListMessage(this.combinedRules, language)));
        }
        return errorMessage.toString();
    }

    private String getFormattedPasswordListMessage(Collection<PasswordRule> rules, String language) {
        StringBuilder formattedMessage = new StringBuilder();
        for (PasswordRule rule : rules) {
            if (formattedMessage.length() > 0) {
                formattedMessage.append(", ");
            }
            formattedMessage.append(rule.getDescription(language));
        }
        return formattedMessage.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getString(String key, String language, String ... params) {
        ResourceLocator messages = multilang.get(language);
        if (messages == null) {
            Map<String, ResourceLocator> map = multilang;
            synchronized (map) {
                messages = new ResourceLocator("org.silverpeas.password.multilang.passwordBundle", language);
                multilang.put(language, messages);
            }
        }
        return params != null && params.length > 0 ? messages.getStringWithParams(key, params) : messages.getString(key, "");
    }
}

