/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.process.annotation;

import com.stratelia.webactiv.util.ActionType;
import com.stratelia.webactiv.util.WAPrimaryKey;
import java.util.List;
import java.util.Map;
import org.silverpeas.process.annotation.DummyHandledFileConverter;
import org.silverpeas.process.annotation.DummyHandledFileConverterRegistration;
import org.silverpeas.process.annotation.SimulationElement;
import org.silverpeas.process.io.file.DummyHandledFile;
import org.silverpeas.process.io.file.FileHandler;
import org.silverpeas.process.management.AbstractFileProcess;
import org.silverpeas.process.management.ProcessExecutionContext;
import org.silverpeas.process.session.ProcessSession;

public class SimulationElementConversionProcess
extends AbstractFileProcess<ProcessExecutionContext> {
    private final Map<Class<SimulationElement>, List<SimulationElement>> elements;
    private final WAPrimaryKey targetPK;
    private final ActionType actionType;

    SimulationElementConversionProcess(Map<Class<SimulationElement>, List<SimulationElement>> elements, WAPrimaryKey targetPK, ActionType actionType) {
        this.elements = elements;
        this.targetPK = targetPK;
        this.actionType = actionType;
    }

    @Override
    public void processFiles(ProcessExecutionContext processExecutionProcess, ProcessSession session, FileHandler fileHandler) throws Exception {
        for (Map.Entry<Class<SimulationElement>, List<SimulationElement>> typeElements : this.elements.entrySet()) {
            DummyHandledFileConverter<SimulationElement> converter = DummyHandledFileConverterRegistration.getConverter(typeElements.getKey());
            if (converter == null) {
                throw new AssertionError((Object)"SimulationElementConversionProcess.processFiles : converter is null (converter must exist for a type of element)");
            }
            List<DummyHandledFile> handledFiles = converter.convert(typeElements.getValue(), this.targetPK, this.actionType);
            for (DummyHandledFile dummyHandledFile : handledFiles) {
                fileHandler.addDummyHandledFile(dummyHandledFile);
            }
        }
    }
}

