/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.quota.service.dao.jdbc;

import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.util.DBUtil;
import com.stratelia.webactiv.util.JNDINames;
import java.sql.Connection;
import org.silverpeas.quota.exception.QuotaRuntimeException;
import org.silverpeas.quota.model.Quota;
import org.silverpeas.quota.service.dao.QuotaDAO;
import org.silverpeas.quota.service.dao.jdbc.JDBCQuotaRequester;

public class JDBCQuotaDAO
implements QuotaDAO {
    @Override
    public Quota getByTypeAndResourceId(String type, String resourceId) {
        Connection con = this.openConnection();
        try {
            Quota quota = JDBCQuotaRequester.getByTypeAndResourceId(con, type, resourceId);
            return quota;
        }
        catch (Exception re) {
            throw new QuotaRuntimeException(this.getClass().getSimpleName() + ".getByTypeAndResourceId()", 4, "quota.GETTING_QUOTA_FAILED", re);
        }
        finally {
            this.closeConnection(con);
        }
    }

    private Connection openConnection() {
        try {
            return DBUtil.makeConnection(JNDINames.SILVERPEAS_DATASOURCE);
        }
        catch (Exception e) {
            throw new QuotaRuntimeException(this.getClass().getSimpleName() + ".openConnection()", 4, "root.EX_CONNECTION_OPEN_FAILED", e);
        }
    }

    private void closeConnection(Connection con) {
        if (con != null) {
            try {
                con.close();
            }
            catch (Exception e) {
                SilverTrace.error("quota", this.getClass().getSimpleName() + ".closeConnection()", "root.EX_CONNECTION_CLOSE_FAILED", "", e);
            }
        }
    }
}

