/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.search.indexEngine.model;

import com.silverpeas.util.i18n.I18NHelper;
import java.io.Serializable;
import java.util.Date;
import org.silverpeas.search.indexEngine.DateFormatter;

public class FieldDescription
implements Serializable {
    private static final long serialVersionUID = -475049855423827178L;
    private final String content;
    private final String lang;
    private final String fieldName;
    private final boolean stored;

    public FieldDescription(String fieldName, String content, String lang) {
        this.content = content;
        this.lang = I18NHelper.checkLanguage(lang);
        this.fieldName = fieldName;
        this.stored = false;
    }

    public FieldDescription(String fieldName, String content, String lang, boolean stored) {
        this.content = content;
        this.lang = I18NHelper.checkLanguage(lang);
        this.fieldName = fieldName;
        this.stored = stored;
    }

    public FieldDescription(String fieldName, Date begin, Date end, String lang) {
        String content = "";
        if (begin != null && end != null) {
            content = "[" + DateFormatter.date2IndexFormat(begin) + " TO " + DateFormatter.date2IndexFormat(end) + "]";
        } else if (begin != null && end == null) {
            content = "[" + DateFormatter.date2IndexFormat(begin) + " TO " + "99999999" + "]";
        } else if (begin == null && end != null) {
            content = "[00000000 TO " + DateFormatter.date2IndexFormat(end) + "]";
        }
        this.content = content;
        this.lang = I18NHelper.checkLanguage(lang);
        this.fieldName = fieldName;
        this.stored = false;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getContent() {
        return this.content;
    }

    public String getLang() {
        return this.lang;
    }

    public boolean isStored() {
        return this.stored;
    }
}

