/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.search.indexEngine.model;

import java.io.Serializable;
import java.util.StringTokenizer;

public final class IndexEntryPK
implements Serializable {
    private static final long serialVersionUID = 339617003068469338L;
    private final String component;
    private final String objectType;
    private final String objectId;
    private static final String SEP = "|";

    public IndexEntryPK(String space, String component, String objectType, String objectId) {
        this.component = component;
        this.objectType = objectType;
        this.objectId = objectId;
    }

    public IndexEntryPK(String componentId, String objectType, String objectId) {
        this.component = componentId;
        this.objectType = objectType;
        this.objectId = objectId;
    }

    public String getSpace() {
        return null;
    }

    public String getComponent() {
        return this.component;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public String toString() {
        return this.getComponent() + SEP + this.getObjectType() + SEP + this.getObjectId();
    }

    public boolean equals(Object o) {
        if (o instanceof IndexEntryPK) {
            IndexEntryPK k = (IndexEntryPK)o;
            return this.toString().equals(k.toString());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public static IndexEntryPK create(String s) {
        StringTokenizer Stk = new StringTokenizer(s, SEP, true);
        String comp = "";
        String objType = "";
        String objId = "";
        if (Stk.hasMoreTokens()) {
            comp = Stk.nextToken();
        }
        if (comp.equals(SEP)) {
            comp = "";
        } else if (Stk.hasMoreTokens()) {
            Stk.nextToken();
        }
        if (Stk.hasMoreTokens()) {
            objType = Stk.nextToken();
        }
        if (objType.equals(SEP)) {
            objType = "";
        } else if (Stk.hasMoreTokens()) {
            Stk.nextToken();
        }
        if (Stk.hasMoreTokens()) {
            objId = Stk.nextToken();
        }
        return new IndexEntryPK(comp, objType, objId);
    }
}

