/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.search.indexEngine.model;

import com.silverpeas.util.FileUtil;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.silverpeas.search.indexEngine.model.DirectorySPFilter;
import org.silverpeas.search.indexEngine.model.FileSPFilter;
import org.silverpeas.search.indexEngine.model.FilenameComparator;
import org.silverpeas.search.indexEngine.model.FullIndexEntry;
import org.silverpeas.search.indexEngine.model.IndexEngineProxy;
import org.silverpeas.search.indexEngine.model.IndexEntryPK;

public class RepositoryIndexer {
    public static final String ADD_ACTION = "add";
    public static final String REMOVE_ACTION = "remove";
    private String spaceId = null;
    private String componentId = null;
    private int count = 0;

    public RepositoryIndexer(String spaceId, String componentId) {
        SilverTrace.debug("indexEngine", "RepositoryIndexer.RepositoryIndexer()", "root.MSG_GEN_PARAM_VALUE", "spaceId=" + spaceId + " ComponentId=" + componentId);
        this.spaceId = spaceId;
        this.componentId = componentId;
    }

    public String getSpaceId() {
        return this.spaceId;
    }

    public String getComponentId() {
        return this.componentId;
    }

    public void pathIndexer(String path, String creationDate, String creatorId, String action) {
        this.pathIndexer(new File(path), creationDate, creatorId, action);
    }

    public void pathIndexer(File path, String creationDate, String creatorId, String action) {
        SilverTrace.debug("indexEngine", "RepositoryIndexer.pathIndexer()", "root.MSG_GEN_ENTER_METHOD", "path=" + path);
        SilverTrace.debug("indexEngine", "RepositoryIndexer.pathIndexer()", "root.MSG_GEN_PARAM_VALUE", "separator = " + File.separator);
        if (path.isDirectory()) {
            this.indexDirectory(action, creationDate, creatorId, path);
            this.processFileList(path, creationDate, creatorId, action);
        }
        SilverTrace.info("indexEngine", "RepositoryIndexer.pathIndexer()", "root.MSG_GEN_PARAM_VALUE", "Fichiers \u00e0 indexer=" + Integer.toString(this.count));
    }

    private void processFileList(File dir, String creationDate, String creatorId, String action) {
        if (this.count % 10000 == 0) {
            SilverTrace.info("indexEngine", "RepositoryIndexer.processFileList()", "root.MSG_GEN_PARAM_VALUE", "# of indexed documents =" + this.count);
        }
        File[] dirs = dir.listFiles(DirectorySPFilter.getInstance());
        File[] files = dir.listFiles(FileSPFilter.getInstance());
        List<File> dirList = Arrays.asList(dirs);
        Collections.sort(dirList, FilenameComparator.comparator);
        List<File> fileList = Arrays.asList(files);
        Collections.sort(fileList, FilenameComparator.comparator);
        for (File currentFile : fileList) {
            this.indexFile(action, creationDate, creatorId, currentFile);
        }
        for (File currentDir : dirList) {
            this.indexDirectory(action, creationDate, creatorId, currentDir);
            this.processFileList(currentDir, creationDate, creatorId, action);
        }
    }

    private void indexDirectory(String action, String creationDate, String creatorId, File directory) {
        String unixDirectoty = FilenameUtils.separatorsToUnix((String)directory.getPath());
        if (ADD_ACTION.equals(action)) {
            FullIndexEntry fullIndexEntry = new FullIndexEntry(this.getComponentId(), "LinkedDir", unixDirectoty);
            fullIndexEntry.setTitle(directory.getName());
            fullIndexEntry.setCreationDate(creationDate);
            fullIndexEntry.setCreationUser(creatorId);
            IndexEngineProxy.addIndexEntry(fullIndexEntry);
            ++this.count;
        } else if (REMOVE_ACTION.equals(action)) {
            IndexEntryPK indexEntry = new IndexEntryPK(this.getComponentId(), "LinkedDir", unixDirectoty);
            IndexEngineProxy.removeIndexEntry(indexEntry);
        }
    }

    public void indexFile(String action, String creationDate, String creatorId, File file) {
        String unixFilePath = FilenameUtils.separatorsToUnix((String)file.getPath());
        if (ADD_ACTION.equals(action)) {
            boolean haveGotExtension;
            String fileName = file.getName();
            FullIndexEntry fullIndexEntry = new FullIndexEntry(this.getComponentId(), "LinkedFile", unixFilePath);
            fullIndexEntry.setTitle(fileName);
            boolean bl = haveGotExtension = fileName.lastIndexOf(46) != -1;
            if (haveGotExtension) {
                fullIndexEntry.setPreView(fileName.substring(0, fileName.lastIndexOf(46)));
            } else {
                fullIndexEntry.setPreView(fileName);
            }
            fullIndexEntry.setCreationDate(creationDate);
            fullIndexEntry.setCreationUser(creatorId);
            if (haveGotExtension && !fileName.startsWith("~")) {
                String format = FileUtil.getMimeType(fileName);
                String lang = "fr";
                fullIndexEntry.addFileContent(unixFilePath, null, format, lang);
            }
            IndexEngineProxy.addIndexEntry(fullIndexEntry);
            ++this.count;
        } else if (REMOVE_ACTION.equals(action)) {
            IndexEntryPK indexEntry = new IndexEntryPK(this.getComponentId(), "LinkedFile", unixFilePath);
            IndexEngineProxy.removeIndexEntry(indexEntry);
        }
    }
}

