/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.search.searchEngine.model;

import com.silverpeas.util.ArrayUtil;
import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.spell.SpellChecker;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Version;
import org.silverpeas.search.indexEngine.IndexFileManager;
import org.silverpeas.search.indexEngine.model.DidYouMeanIndexer;
import org.silverpeas.search.indexEngine.model.IndexManager;
import org.silverpeas.search.searchEngine.model.ParseException;
import org.silverpeas.search.searchEngine.model.QueryDescription;
import org.silverpeas.search.searchEngine.model.WAIndexSearcher;

public class DidYouMeanSearcher {
    private List<SpellChecker> spellCheckers = new ArrayList<SpellChecker>();
    private String query = null;
    private final File uploadIndexDir = new File(IndexFileManager.getIndexUpLoadPath());

    public String[] suggest(QueryDescription queryDescription) throws ParseException, IOException {
        String[] suggestions = null;
        String field = "content";
        if (StringUtil.isDefined(queryDescription.getQuery())) {
            Query parsedQuery;
            Analyzer analyzer = new IndexManager().getAnalyzer(queryDescription.getRequestedLanguage());
            QueryParser queryParser = new QueryParser(Version.LUCENE_36, "content", analyzer);
            try {
                parsedQuery = queryParser.parse(queryDescription.getQuery());
            }
            catch (org.apache.lucene.queryParser.ParseException exception) {
                throw new ParseException("DidYouMeanSearcher", (Exception)((Object)exception));
            }
            this.query = parsedQuery.toString("content");
            StringTokenizer tokens = new StringTokenizer(this.query);
            WAIndexSearcher waIndexSearcher = new WAIndexSearcher();
            Set<String> spellIndexPaths = waIndexSearcher.getIndexPathSet(queryDescription.getSpaceComponentPairSet());
            try {
                while (tokens.hasMoreTokens()) {
                    SpellChecker spellCheck = new SpellChecker((Directory)FSDirectory.open((File)this.uploadIndexDir));
                    this.spellCheckers.add(spellCheck);
                    String token = tokens.nextToken().replaceAll("\"", "");
                    for (String path : spellIndexPaths) {
                        File file = new File(path + "Spell");
                        if (!file.exists()) continue;
                        FSDirectory directory = FSDirectory.open((File)file);
                        spellCheck.setSpellIndex((Directory)directory);
                        if (spellCheck.exist(token)) continue;
                        spellCheck.suggestSimilar(token, 1);
                    }
                }
            }
            catch (IOException e) {
                SilverTrace.error("searchEngine", DidYouMeanIndexer.class.toString(), "root.EX_LOAD_IO_EXCEPTION", e);
            }
            suggestions = this.buildFinalResult();
        }
        return suggestions;
    }

    private String[] buildFinalResult() throws IOException {
        StringBuilder currentSentence = new StringBuilder();
        StringTokenizer tokens = new StringTokenizer(this.query);
        int countTokens = tokens.countTokens();
        for (SpellChecker spellCheck : this.spellCheckers) {
            String currentToken;
            Object[] suggestWords = spellCheck.suggestSimilar(currentToken = tokens.nextToken(), 1);
            if (!ArrayUtil.isEmpty((Object[])suggestWords)) {
                this.getPrefixOperator(currentSentence, currentToken, false);
                currentSentence.append((String)suggestWords[0]);
                this.getSuffixOperator(currentSentence, currentToken, false);
                continue;
            }
            if (countTokens <= 1) continue;
            this.getPrefixOperator(currentSentence, currentToken, true);
            currentSentence.append(currentToken);
            this.getSuffixOperator(currentSentence, currentToken, true);
        }
        return new String[]{currentSentence.toString().replaceAll("\\+", "").replaceAll("-", "").replaceAll("  ", " ").trim()};
    }

    private void getSuffixOperator(StringBuilder currentSentence, String currentToken, boolean originalString) {
        if (currentToken.endsWith("*")) {
            currentSentence.append("* ");
        } else if (currentToken.endsWith("\"") && !originalString) {
            currentSentence.append("\" ");
        } else {
            currentSentence.append(" ");
        }
    }

    private void getPrefixOperator(StringBuilder currentSentence, String currentToken, boolean originalString) {
        if (currentToken.startsWith("-")) {
            currentSentence.append(" NOT ");
        } else if (currentToken.startsWith("+")) {
            currentSentence.append(" AND ");
        } else if (currentToken.startsWith("\"") && !originalString) {
            currentSentence.append("\"");
        } else if (currentToken.startsWith("OR")) {
            currentSentence.append(" OR ");
        } else {
            currentSentence.append(" ");
        }
    }
}

