/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.search.searchEngine.model;

import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.silverpeas.search.indexEngine.model.ExternalComponent;
import org.silverpeas.search.indexEngine.model.FieldDescription;
import org.silverpeas.search.indexEngine.model.SpaceComponentPair;

public final class QueryDescription
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Set<SpaceComponentPair> spaceComponentPairSet = new HashSet<SpaceComponentPair>();
    private String query = "";
    private String searchingUser = "";
    private String requestedLang = null;
    private String requestedAuthor = null;
    private String requestedCreatedBefore = null;
    private String requestedCreatedAfter = null;
    private String requestedUpdatedBefore = null;
    private String requestedUpdatedAfter = null;
    private Map<String, String> xmlQuery = null;
    private String xmlTitle = null;
    private List<FieldDescription> multiFieldQuery = null;
    private boolean searchBySpace = false;
    private boolean searchByComponentType = false;
    private String requestedFolder = null;
    private Set<ExternalComponent> extComponents = new HashSet<ExternalComponent>();

    public QueryDescription() {
    }

    public QueryDescription(String query) {
        this.setQuery(query);
    }

    public void setQuery(String query) {
        this.query = query == null ? "" : query.toLowerCase();
        this.query = this.findAndReplace(this.query, " and ", " AND ");
        this.query = this.findAndReplace(this.query, " or ", " OR ");
        this.query = this.findAndReplace(this.query, " not ", " NOT ");
        if (this.query.indexOf("not ") == 0) {
            this.query = "NOT " + this.query.substring(4, this.query.length());
        }
        SilverTrace.info("searchEngine", "QueryDescription.setQuery()", "root.MSG_GEN_PARAM_VALUE", "Query String to Lucence= " + this.query);
    }

    public String getQuery() {
        return this.query;
    }

    public void setSearchingUser(String searchingUser) {
        this.searchingUser = searchingUser == null ? "" : searchingUser.toLowerCase();
    }

    public String getSearchingUser() {
        return this.searchingUser;
    }

    public void addSpaceComponentPair(String space, String component) {
        SilverTrace.info("searchEngine", "QueryDescription.addSpaceComponentPair()", "root.MSG_GEN_PARAM_VALUE", "space = " + space + ", component=" + component);
        this.spaceComponentPairSet.add(new SpaceComponentPair(space, component));
    }

    public void addComponent(String component) {
        SilverTrace.info("searchEngine", "QueryDescription.addComponent()", "root.MSG_GEN_PARAM_VALUE", "component=" + component);
        this.spaceComponentPairSet.add(new SpaceComponentPair(null, component));
    }

    public Set<SpaceComponentPair> getSpaceComponentPairSet() {
        return this.spaceComponentPairSet;
    }

    public void setRequestedLanguage(String requestedLang) {
        this.requestedLang = requestedLang;
    }

    public String getRequestedLanguage() {
        if (this.requestedLang == null) {
            return Locale.getDefault().getLanguage();
        }
        return this.requestedLang;
    }

    public void setRequestedAuthor(String author) {
        this.requestedAuthor = author == null ? null : author.toLowerCase();
    }

    public String getRequestedAuthor() {
        return this.requestedAuthor;
    }

    public void setRequestedCreatedBefore(String beforedate) {
        this.requestedCreatedBefore = beforedate;
    }

    public String getRequestedCreatedBefore() {
        return this.requestedCreatedBefore;
    }

    public void setRequestedCreatedAfter(String afterdate) {
        this.requestedCreatedAfter = afterdate;
    }

    public String getRequestedCreatedAfter() {
        return this.requestedCreatedAfter;
    }

    public void setXmlQuery(Map<String, String> xmlQuery) {
        this.xmlQuery = xmlQuery;
    }

    public Map<String, String> getXmlQuery() {
        return this.xmlQuery;
    }

    public String getXmlTitle() {
        return this.xmlTitle;
    }

    public void setXmlTitle(String xmlTitle) {
        this.xmlTitle = xmlTitle;
    }

    public List<FieldDescription> getMultiFieldQuery() {
        return this.multiFieldQuery;
    }

    public void clearMultiFieldQuery() {
        if (this.multiFieldQuery != null) {
            this.multiFieldQuery.clear();
        }
    }

    public void addFieldQuery(FieldDescription fieldQuery) {
        if (fieldQuery == null) {
            return;
        }
        if (this.multiFieldQuery == null) {
            this.multiFieldQuery = new ArrayList<FieldDescription>();
        }
        this.multiFieldQuery.add(fieldQuery);
    }

    public void addFieldQueries(List<FieldDescription> fieldQueries) {
        if (this.multiFieldQuery == null) {
            this.multiFieldQuery = new ArrayList<FieldDescription>();
        }
        this.multiFieldQuery.addAll(fieldQueries);
    }

    public void setFieldQueries(List<FieldDescription> fieldQueries) {
        this.clearMultiFieldQuery();
        this.addFieldQueries(fieldQueries);
    }

    public boolean isEmpty() {
        return !StringUtil.isDefined(this.query) && this.getMultiFieldQuery() == null && this.getXmlQuery() == null && !StringUtil.isDefined(this.xmlTitle);
    }

    private String findAndReplace(String source, String find, String replace) {
        int index = source.indexOf(find);
        while (index > -1) {
            source = source.substring(0, index) + replace + source.substring(index + find.length(), source.length());
            index = source.indexOf(find);
        }
        return source;
    }

    public boolean isPeriodDefined() {
        return StringUtil.isDefined(this.requestedCreatedAfter) || StringUtil.isDefined(this.requestedCreatedBefore) || StringUtil.isDefined(this.requestedUpdatedAfter) || StringUtil.isDefined(this.requestedUpdatedBefore);
    }

    public boolean isSearchBySpace() {
        return this.searchBySpace;
    }

    public void setSearchBySpace(boolean isSearchBySpace) {
        this.searchBySpace = isSearchBySpace;
    }

    public String getRequestedUpdatedBefore() {
        return this.requestedUpdatedBefore;
    }

    public void setRequestedUpdatedBefore(String requestedUpdatedBefore) {
        this.requestedUpdatedBefore = requestedUpdatedBefore;
    }

    public String getRequestedUpdatedAfter() {
        return this.requestedUpdatedAfter;
    }

    public void setRequestedUpdatedAfter(String requestedUpdatedAfter) {
        this.requestedUpdatedAfter = requestedUpdatedAfter;
    }

    public Set<ExternalComponent> getExtComponents() {
        return this.extComponents;
    }

    public void addExternalComponents(String server, String component, String path, String url) {
        SilverTrace.info("searchEngine", "QueryDescription.addExternalComponents()", "root.MSG_GEN_PARAM_VALUE", "server = " + server + ", component=" + component);
        this.extComponents.add(new ExternalComponent(server, component, path, url));
    }

    public boolean isSearchByComponentType() {
        return this.searchByComponentType;
    }

    public void setSearchByComponentType(boolean searchByComponentType) {
        this.searchByComponentType = searchByComponentType;
    }

    public void setRequestedFolder(String requestedFolder) {
        this.requestedFolder = requestedFolder;
    }

    public String getRequestedFolder() {
        return this.requestedFolder;
    }
}

