/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.token.persistent;

import com.silverpeas.util.StringUtil;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.silverpeas.EntityReference;
import org.silverpeas.token.Token;
import org.silverpeas.token.annotation.TokenGenerator;
import org.silverpeas.token.exception.TokenException;
import org.silverpeas.token.exception.TokenValidationException;
import org.silverpeas.token.persistent.PersistentResourceTokenGenerator;
import org.silverpeas.token.persistent.service.PersistentResourceTokenService;
import org.silverpeas.token.persistent.service.TokenServiceFactory;

@Entity
@Table(name="st_token")
@TokenGenerator(value=PersistentResourceTokenGenerator.class)
public class PersistentResourceToken
implements Token {
    private static final long serialVersionUID = 5956074363457906409L;
    public static final PersistentResourceToken NoneToken = new PersistentResourceToken();
    @Id
    @TableGenerator(name="UNIQUE_ID_GEN", table="uniqueId", pkColumnName="tablename", valueColumnName="maxId", pkColumnValue="st_token", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.TABLE, generator="UNIQUE_ID_GEN")
    @Column(name="id")
    private Long id;
    @Column(name="tokenType", nullable=false)
    private String resourceType = "UNKNOWN";
    @Column(name="resourceId", nullable=false)
    private String resourceId;
    @Column(name="token", nullable=false)
    private String value;
    @Column(name="saveCount", nullable=false)
    private int saveCount = 0;
    @Column(name="saveDate", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date saveDate;

    protected PersistentResourceToken() {
    }

    protected PersistentResourceToken(EntityReference resource, String value) {
        this.value = value;
        this.resourceId = resource.getId();
        this.resourceType = resource.getType();
    }

    public static PersistentResourceToken createToken(EntityReference resource) throws TokenException {
        PersistentResourceTokenService service = TokenServiceFactory.getTokenService();
        return service.initialize(resource);
    }

    public static PersistentResourceToken getOrCreateToken(EntityReference resource) throws TokenException {
        PersistentResourceTokenService service = TokenServiceFactory.getTokenService();
        PersistentResourceToken token = service.get(resource);
        if (!token.isDefined()) {
            token = service.initialize(resource);
        }
        return token;
    }

    public static PersistentResourceToken getToken(String token) {
        PersistentResourceTokenService service = TokenServiceFactory.getTokenService();
        return service.get(token);
    }

    @PrePersist
    @PreUpdate
    private void performSaveDate() {
        this.setSaveCount(this.getSaveCount() + 1);
        this.setSaveDate(new Date());
    }

    public boolean exists() {
        return this.getId() != null;
    }

    public boolean notExists() {
        return this.getId() == null;
    }

    public void validate() throws TokenValidationException {
        if (this.resourceType == null || "UNKNOWN".equals(this.resourceType) || !StringUtil.isDefined(this.resourceId)) {
            throw new TokenValidationException("The token isn't valid! Missing resource reference");
        }
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public <E, R extends EntityReference<E>> R getResource(Class<R> referenceClass) {
        EntityReference ref = null;
        if (this.resourceType != null && !this.resourceType.equals("UNKNOWN") && StringUtil.isDefined(this.resourceId)) {
            try {
                ref = (EntityReference)referenceClass.getConstructor(String.class).newInstance(this.resourceId);
                if (!ref.getType().equals(this.resourceType)) {
                    ref = null;
                }
            }
            catch (Exception ex) {
                Logger.getLogger(PersistentResourceToken.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return (R)ref;
    }

    public void setResource(EntityReference resource) {
        if (resource != null) {
            this.resourceType = resource.getType();
            this.resourceId = resource.getId();
        }
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public int getSaveCount() {
        return this.saveCount;
    }

    public void setSaveCount(int saveCount) {
        this.saveCount = saveCount;
    }

    public Date getSaveDate() {
        return this.saveDate;
    }

    public void setSaveDate(Date saveDate) {
        this.saveDate = saveDate;
    }

    public String toString() {
        return "PersistentResourceToken{resourceType='" + this.resourceType + '\'' + ", resourceId='" + this.resourceId + '\'' + ", value='" + this.value + '\'' + '}';
    }

    @Override
    public boolean isDefined() {
        return this.exists() && this != NoneToken;
    }
}

